#ifndef _NWAYPARAMS_HH
#define _NWAYPARAMS_HH

/**
 * The parameters for the analysis step
 */
class NwayParams {
public:
	// Minimum flanks for blocks
	int minflanks = 50;

	// Maximum overlap in gaps
	int maxover = 25;

	// Minimum gap size
	int mingapsize = 10;

	// Minimum Coverage in gaps
	float mincov = 0.7;

	// Maximum distance in gaps (reverse)
	int maxdist = 20;

	// Maximal difference ratio (reverse)
	float maxdiffratio = 0.3;

	// Manimal block flanks
	int minblockflanks = 150;

	// For fasta extraction - extend nucleotide start and end by this number
	int extractext = 100;

	// Gap search method ("1=overlap" or "2=distance", see result.cc)
	int gapsearch = 1;

	// Target minimum length for evaluation of density
	int tminlen = 0;

	// Target maximum length for evaluation of density
	int tmaxlen = 0;

	// Sliding window extension (used for density calculation step)
	int densext = 20;

	// Sliding window step size (used for density calculation step)
	int densstep = 5;

	NwayParams() {
	}

	NwayParams(int argc, char** argv) {
		for (int i = 1; i < argc; i++) {
			if (strcmp(argv[i], "-fl") == 0) {
				minflanks = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-ov") == 0) {
				maxover = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-gs") == 0) {
				mingapsize = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-co") == 0) {
				mincov = atof(argv[++i]);
			} else if (strcmp(argv[i], "-di") == 0) {
				maxdist = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-dr") == 0) {
				maxdiffratio = atof(argv[++i]);
			} else if (strcmp(argv[i], "-bf") == 0) {
				minblockflanks = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-ee") == 0) {
				extractext = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-sm") == 0) {
				gapsearch = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-tl") == 0) {
				tminlen = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-tm") == 0) {
				tmaxlen = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-de") == 0) {
				densext = atoi(argv[++i]);
			} else if (strcmp(argv[i], "-ds") == 0) {
				densstep = atoi(argv[++i]);
			}
		}
	}
};

#endif
