#include <iostream>
#include <fstream>
#include <string.h>
#include <sys/time.h>

#include "exception.hh"
#include "cparams.hh"
#include "result.hh"

using namespace std;

// Program to calculates the fasta sequences
const char* fastapgm = (char*) "/data/projects/n-way/calculate/nway_calc_fasta.pl";

// Program to check density
const char* densitypgm = (char*) "/data/projects/n-way/calculate/nway_calc_density.pl";

int main(int argc, char** argv) {
	char command[256];
	try {
		struct timeval t;

		gettimeofday(&t, NULL);

		// Do nway analysis

		int start = t.tv_sec;
		CommandParams cparams(argc, argv);
		NwayParams params(argc, argv);
		NwayResult result(&cparams, &params);
		gettimeofday(&t, NULL);
		cout << "==> Analyze: " << (t.tv_sec - start) << " seconds\n" << flush;

		// Write fasta

		start = t.tv_sec;
		sprintf(command, "%s -fn %s -ff %s -pg %s -e %d", fastapgm, cparams.nwayfile, cparams.fastafile,
				cparams.genomespath, params.extractext);
		system(command);
		gettimeofday(&t, NULL);
		cout << "==> Fasta: " << (t.tv_sec - start) << " seconds\n" << flush;

		// Check density

		if (params.tminlen > 0) {
			start = t.tv_sec;
			sprintf(command, "%s -fn %s -ff %s -tl %d -tm %d -e %d", densitypgm, cparams.nwayfile, cparams.fastafile,
					params.tminlen, params.tmaxlen, params.extractext);
			system(command);
			gettimeofday(&t, NULL);
			cout << "==> Density: " << (t.tv_sec - start) << " seconds\n" << flush;
		}
	} catch (NwayException& e) {
		cerr << e.what() << std::endl;
		return 1;
	} catch (exception& e) {
		cerr << e.what() << std::endl;
		return 1;
	}

	return 0;
}
