#ifndef _COMMANDPARAMS_HH
#define _COMMANDPARAMS_HH

#include "exception.hh"

/**
 * The command line parameters
 */
class CommandParams {
	// Maximum number of species
	static const int MAXSPEC = 128;

public:
	char* target = NULL;
	int specn = 0;
	char* specs[MAXSPEC];
	char* coordfile = (char*) "input.coords";
	char* nwayfile = (char*) "calc.nway";
	char* fastafile = (char*) "calc.nway.fa";
	char* dbpath = NULL;
	char* genomespath = NULL;

	CommandParams(int argc, char** argv) {
		for (int i = 1; i < argc; i++) {
			if (strcmp(argv[i], "-t") == 0) {
				target = argv[++i];
			} else if (strcmp(argv[i], "-s") == 0) {
				char* spec = strtok(argv[++i], ",");
				while (spec != NULL && specn < MAXSPEC) {
					specs[specn++] = spec;
					spec = strtok(NULL, ",");
				}
			} else if (strcmp(argv[i], "-fc") == 0) {
				coordfile = argv[++i];
			} else if (strcmp(argv[i], "-fn") == 0) {
				nwayfile = argv[++i];
			} else if (strcmp(argv[i], "-ff") == 0) {
				fastafile = argv[++i];
			} else if (strcmp(argv[i], "-pd") == 0) {
				dbpath = argv[++i];
			} else if (strcmp(argv[i], "-pg") == 0) {
				genomespath = argv[++i];
			}
		}

		if (target == NULL || specn == 0 || dbpath == NULL || genomespath == NULL) {
			cout << "Usage: " << argv[0] << " -t target -s spec{,spec}" //
					<< " -pd dbpath -pg genomespath" //
					<< " [-fc coordfile] [-fn nwayfile] [-ff fastafile]" << endl;
			cout << "Where" << endl;
			cout << "  target       - the target species" << endl;
			cout << "  spec         - the query species" << endl;
			cout << "  dbpath       - the path to the 2-way data" << endl;
			cout << "  genomespath  - the path to the genomes data" << endl;
			cout << "  coordfile    - the file containing the request coordinates" << endl;
			cout << "               - (default " << coordfile << ")" << endl;
			cout << "  nwayfile     - the result (nway) file" << endl;
			cout << "               - (default " << nwayfile << ")" << endl;
			cout << "  fastafile    - the fasta file" << endl;
			cout << "               - (default " << fastafile << ")" << endl;

			throw NwayException((char*) "Please specify parameters -t, -s, -pd and -pg!");
		}
	}
};

#endif
