/**
 * Program to check the *.bed against *.bin files in the db folder of nway.
 *
 * Just enter the desired folder db/target/species and call this program.  It looks
 * if every single input coordinate in (block,gap) *.bed files is present in the
 * generated binary files.
 */

#include <iostream>
#include <fstream>
#include <string.h>
#include <math.h>
#include <regex>
#include <unistd.h>

#include "exception.hh"
#include "bedfile.hh"
#include "bedfiles.hh"

using namespace std;

char* DBPATH = (char*) "/data/projects/n-way/db";

BedFiles files(DBPATH);

void check(char* specpath, const char* target, const char* spec, char type) {
	char* stype = type == 'b' ? (char*) "block" : (char*) "gap";
	cout << "check " << stype << endl;

	char bedfile[256];
	sprintf(bedfile, (char*) "%s/calc.%s.bed", specpath, stype);

	ifstream bed(bedfile);
	BedFile* bin = files.get((char*) target, (char*) spec, type);

	char line[256];
	int count = 1;

	NEXTLINE: while (!bed.eof()) {
		bed.getline(line, sizeof(line) - 1);
		if (strtok(line, " \t")) {
			// Get data form text bed file
			char* chr1 = strtok(NULL, " \t");
			int start1 = atoi(strtok(NULL, " \t"));
			int end1 = atoi(strtok(NULL, " \t"));
			char* chr2 = strtok(NULL, " \t");
			int start2 = atoi(strtok(NULL, " \t"));
			int end2 = atoi(strtok(NULL, " \t"));

			// Search coordinates in binary file
			bool found = false;
			for (int i = bin->getFirstIndex1(chr1); !found && i != ENDOFLIST; i = bin->getNextIndex1(i)) {
				char* entry = bin->getEntry(i);
				found = strcmp(chr1, bin->getChr1(entry)) == 0 && start1 == bin->getStart1(entry)
						&& end1 == bin->getEnd1(entry);
			}
			if (!found) {
				cout << "Cannot find chr1=" << chr1 << " start1=" << start1 << " end1=" << end1 << endl;
			}
			found = false;
			for (int i = bin->getFirstIndex2(chr2); !found && i != ENDOFLIST; i = bin->getNextIndex2(i)) {
				char* entry = bin->getEntry(i);
				found = strcmp(chr2, bin->getChr2(entry)) == 0 && start2 == bin->getStart2(entry)
						&& end2 == bin->getEnd2(entry);
			}
			if (!found) {
				cout << "Cannot find chr2=" << chr2 << " start2=" << start2 << " end2=" << end2 << endl;
			}
		}
	}

	bed.close();
}

int main(int argc, char** argv) {
	char path[256];
	getcwd(path, 256);
	regex re("/.*/([^/]+)/([^/]+)$");
	cmatch m;

	if (regex_search(path, m, re)) {
		string target = m[1];
		string spec = m[2];
		check(path, target.c_str(), spec.c_str(), 'b');
		check(path, target.c_str(), spec.c_str(), 'g');
	}

	return 0;
}
