#ifndef _BEDFILES_HH
#define _BEDFILES_HH

#include <unordered_map>

#include "bedfile.hh"

using namespace std;

class BedFiles {
	char* basepath;
	unordered_map<string, BedFile*> beds;

public:
	/**
	 * Create BedFiles with the path where the binary BedFile(s) can be found.
	 */
	BedFiles(char* basepath);

	/**
	 * Returns the BedFile for a specific target, species and type
	 */
	BedFile* get(char* target, char* spec, char type);
};

#endif
