#include <string.h>

#include "bedfiles.hh"

BedFiles::BedFiles(char* basepath) {
	this->basepath = basepath;
}

BedFile* BedFiles::get(char* target, char* spec, char type) {
	char key[128];

	// Target is NOT needed for the key
	sprintf(key, "%s.%c", spec, type);

	BedFile* bed = beds[key];
	if (bed == NULL) {
		char path[128];
		char* blockorgap = type == 'b' ? (char*) "block" : (char*) "gap";
		sprintf(path, "%s/%s/%s/calc.%s.bed.bin", basepath, target, spec, blockorgap);
		bed = new BedFile(path);
		beds[key] = bed;
	}

	return bed;
}
