# These plots can be saved as pdfs and imported into cowplot using magick.
# Before used sweave and latex, but magick is a better solution. 

# ------- Run in R if latex solution desired-------------------------

# Use sweave and latex. Code below transferred to g_d_sep_overlap_fig_1.Rnw. Then following commands in R. 
# Note important to have Sweave.sty in same folder. 
# Sweave gave better results than generating each pdf separately in R and then directly combining in latex using subfigure.
# Tried tikz, but did not work with chart.Correlation for some reason, though did work with corrplot

# Sys.setenv(PATH=paste(Sys.getenv("PATH"),"/Library/TeX/texbin",sep=":"))
# Sweave("g_d_sep_overlap_fig_1.Rnw")
# tools::texi2pdf("g_d_sep_overlap_fig_1.tex")

# # # equivalent:
# # tools::texi2dvi("g_d_sep_overlap_fig_1.tex",pdf=TRUE)

# # or in unix terminal:
# # pdflatex g_d_sep_overlap_fig_1.tex


# ------------------ Code chunks for g_d_overlap_1.Rnw follow if latex desired ----------------------
# Otherwise use directly in R

library(corrplot)
library(PerformanceAnalytics)
library(ggplot2)
library(magick)
library(cowplot)
library(RColorBrewer)


# slightly modify PerformanceAnalytics::chart.Correlation for more pleasing results

chart.Corr <- function (R, histogram = TRUE, method = c("pearson", "kendall", "spearman"), ticksize=0.1, tickthick=0.1,  ...) 
{
    x = checkData(R, method = "matrix")
    if (missing(method)) 
        method = method[1]
    panel.cor <- function(x, y, digits = 2, prefix = "", use = "pairwise.complete.obs", 
        method = "pearson", cex.cor, ...) {
        usr <- par("usr")
        on.exit(par(usr))
        par(usr = c(0, 1, 0, 1))
        r <- cor(x, y, use = use, method = method)
        txt <- format(c(r, 0.123456789), digits = digits)[1]
        txt <- paste(prefix, txt, sep = "")
        if (missing(cex.cor)) 
            cex <- 0.8/strwidth(txt)
        test <- cor.test(as.numeric(x), as.numeric(y), method = method)
        Signif <- symnum(test$p.value, corr = FALSE, na = FALSE, 
            cutpoints = c(0, 0.001, 0.01, 0.05, 0.1, 1), symbols = c("***", 
                "**", "*", ".", " "))
        text(0.5, 0.5, txt, cex = cex * (abs(r) + 0.3)/1.3)
        text(0.7, 0.8, Signif, cex = cex, col = 2)
    }
    f <- function(t) {
        dnorm(t, mean = mean(x), sd = sd.xts(x))
    }
    dotargs <- list(...)
    dotargs$method <- NULL
    rm(method)
    hist.panel = function(x, ... = NULL) {
        par(new = TRUE)
        hist(x, col = "light gray", probability = TRUE, axes = FALSE, 
            main = "", breaks = "FD")
        lines(density(x, na.rm = TRUE), col = "red", lwd = 1)
        rug(x, ticksize=ticksize,lwd=tickthick)
    }
    if (histogram) 
        pairs(x, gap = 0, lower.panel = panel.smooth, upper.panel = panel.cor,
            diag.panel = hist.panel)
    else pairs(x, gap = 0, lower.panel = panel.smooth, upper.panel = panel.cor)
}




logP <-  read.table("log10P_human.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE)
colnames(logP)[c(5:15)] <- c("0 nM","8 nM","25 nM","75 nM","avg", "wk 1", "wk 2", "wk 3", "wk 4", "wk 6","avg")

g <- read.delim("growth_loci.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
d <- read.delim("paclitaxel_loci.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)



#Unfortunately layout does not workwith chart.Correlation, so print each panel pdf separately and put together with magick.
# pdf(file='g_d_overlap_1.pdf', width = 7.5,  height = 6.67)

# layout(
# matrix(c(rep(1,50), rep(2,50), 
		# rep(3,50), rep(4,50)
# ), 
# 2, 100, byrow = TRUE))

#--------------------- (1) g_P_vals_cor-----------------


pdf(file='g_d_overlap_1A.pdf', width = 5,  height = 5, useDingbats = FALSE)
chart.Corr(
		logP[seq(1,nrow(logP),by=100),c(5:9)],
                 method="pearson",
                 histogram=TRUE,
                 ticksize=0.05,
                 tickthick=0.01,
                 par(
                 	lwd=0.4, 
                 	pch="."
					)
			)

# mtext("Growth", at=2.5, line=2, cex=3)

# mtext("A",side=3,line=2.5, 
             # # at=par("usr")[1]-.45*diff(par("usr")[1:2]),
             # # cex=1.2,font=2)
dev.off()

#--------------------- (2) d_P_vals_cor-----------------

pdf(file='g_d_overlap_1B.pdf', width = 5,  height = 5, useDingbats = FALSE)
chart.Corr(
		logP[seq(1,nrow(logP),by=100),c(10:15)],
                 method="pearson",
                 histogram=TRUE,
                 ticksize=0.05,
                 tickthick=0.01,
                 par(
                 	lwd=0.4, 
                 	pch="."
					)
			)

# mtext("Paclitaxel", at=2.5, line=2, cex=3)

# mtext("B",side=3,line=2.5, 
             # at=par("usr")[1]-.45*diff(par("usr")[1:2]),
             # cex=1.2,font=2)
dev.off()

#--------------------- (3) g_loci_overlap -----------------


g_overlap_frac <- data.frame("0 nM"=numeric(), "8 nM"=numeric(), "25 nM"=numeric(), "75 nM"=numeric(), "avg"=numeric(),check.names=FALSE,fix.empty.names=FALSE)

k <- c(0,8,25,75,"avg")

for(i in 1:5) 
{
	for(j in 1:5) 
	{
		g_overlap_frac[i,j] <- dim(g[g$conc==k[i],][with(g[g$conc==k[i],], paste(Chromosome, ensembl_gene_id, sep = "\r")) %in% with(g[g$conc==k[j],], paste(Chromosome, ensembl_gene_id, sep="\r")), ])[1]
	}
}

row.names(g_overlap_frac) <- c(colnames(g_overlap_frac))

g_overlap_dec <- g_overlap_frac
for(i in 1:5) {
	g_overlap_dec[i,] <- g_overlap_dec[i,]/g_overlap_dec[i,i]
}

# write.table(g_overlap_frac,"g_overlap_frac.txt",sep="\t",row.names=FALSE)
# write.table(g_overlap_dec,"g_overlap_dec.txt",sep="\t",row.names=FALSE)

pal <- colorRampPalette(brewer.pal(3, "Blues"))


pdf(file='g_d_overlap_1C.pdf', width = 5,  height = 5, useDingbats = FALSE)
#Using corrplot to give heatmap, hence one color and use of cl.lim = c(0,1):

corrplot(as.matrix(g_overlap_dec),is.corr=FALSE,method="pie", addCoefasPercent=FALSE, col=pal(200), tl.col="black", addCoef.col ="black", cl.pos="r",cl.lim=c(0,1),cl.length=3,cl.ratio=0.25, cl.align.text="l", tl.cex=1.25, cl.cex=1.2, number.cex=1.2, oma = c(0,0,0,0), mar=c(0,0,0,1))
# mtext("Growth", at=3.0, line=2, cex=3)
dev.off()



#use ggplot to get airy blue plot: 
# ggplot(data = melt(apply(g_overlap_dec,2,function(x) {x})), aes(x = Var1, y = Var2)) +
  # geom_tile(aes(fill = value),colour = "grey90")+ scale_fill_gradient(low = "white",high = "steelblue")+theme(
	# panel.grid.major = element_blank(), 
	# panel.grid.minor = element_blank(), 
	# panel.background = element_blank(), axis.ticks = element_blank())

# mtext("C",side=3,line=2.5, 
             # at=par("usr")[1]-.45*diff(par("usr")[1:2]),
             # cex=1.2,font=2)

#--------------------- (4) d_loci_overlap -----------------

# no loci w1
d_overlap_frac <- data.frame("wk 2"=numeric(), "wk 3"=numeric(), "wk 4"=numeric(), "wk 6"=numeric(), "avg"=numeric(),check.names=FALSE,fix.empty.names=FALSE)

k <- as.character(c(2,3,4,6,"avg"))

for(i in 1:5) 
{
	for(j in 1:5) 
	{
		d_overlap_frac[i,j] <- dim(d[d$wk==k[i],][with(d[d$wk==k[i],], paste(Chromosome, ensembl_gene_id, sep = "\r")) %in% with(d[d$wk==k[j],], paste(Chromosome, ensembl_gene_id, sep="\r")), ])[1]
	}
}

row.names(d_overlap_frac) <- c(colnames(d_overlap_frac))

d_overlap_dec <- d_overlap_frac
for(i in 1:5) {
	d_overlap_dec[i,] <- d_overlap_dec[i,]/d_overlap_dec[i,i]
}

# write.table(d_overlap_frac,"d_overlap_frac.txt",sep="\t",row.names=FALSE)
# write.table(d_overlap_dec,"d_overlap_dec.txt",sep="\t",row.names=FALSE)


pal <- colorRampPalette(brewer.pal(3, "Blues"))


pdf(file='g_d_overlap_1D.pdf', width = 5,  height = 5, useDingbats = FALSE)

corrplot(as.matrix(d_overlap_dec),is.corr=FALSE,method="pie", addCoefasPercent=FALSE, col=pal(200), tl.col="black", addCoef.col ="black", cl.pos="r",cl.lim=c(0,1),cl.length=3,cl.ratio=0.25, cl.align.text="l", tl.cex=1.25, cl.cex=1.2, number.cex=1.2, oma = c(0,0,0,0), mar=c(0,0,0,1))
# mtext("Paclitaxel", at=2.5, line=2, cex=3)
dev.off()



# mtext("D",side=3,line=2.5, 
             # at=par("usr")[1]-.45*diff(par("usr")[1:2]),
             # cex=1.2,font=2)

#---------Finale------------------------


p1 <- ggdraw() + draw_image(magick::image_read_pdf("g_d_overlap_1A.pdf", density = 300),scale=0.8) + draw_label("Growth", fontface='plain', size=14, x=0.5,y=0.92) + draw_label("A", fontface='bold',x=0.05,y=0.98, size=16)
p2 <- ggdraw() + draw_image(magick::image_read_pdf("g_d_overlap_1B.pdf", density = 300),scale=0.8) + draw_label("Paclitaxel", fontface='plain', size=14, x=0.55,y=0.92) + draw_label("B", fontface='bold',x=0.05,y=0.98, size=16)
p3 <- ggdraw() + draw_image(magick::image_read_pdf("g_d_overlap_1C.pdf", density = 300),scale=1.0) + draw_label("Growth", fontface='plain', size=14, x=0.55,y=0.92) + draw_label("C", fontface='bold',x=0.05,y=0.98, size=16)
p4 <- ggdraw() + draw_image(magick::image_read_pdf("g_d_overlap_1D.pdf", density = 300),scale=1.0) + draw_label("Paclitaxel", fontface='plain', size=14, x=0.55,y=0.92) + draw_label("D", fontface='bold',x=0.05,y=0.98, size=16)


pdf("g_d_overlap_1.pdf", width=7.5, height=8, useDingbats = FALSE)
plot_grid(p1, p2, p3,  p4, ncol = 2, nrow = 2, align="h")
dev.off()






#--------- hi res Finale---------------------


p1 <- ggdraw() + draw_image(magick::image_read_pdf("g_d_overlap_1A.pdf", density = 1200),scale=0.8) + draw_label("Growth", fontface='plain', size=14, x=0.5,y=0.92) + draw_label("A", fontface='bold',x=0.05,y=0.98, size=16)
p2 <- ggdraw() + draw_image(magick::image_read_pdf("g_d_overlap_1B.pdf", density = 1200),scale=0.8) + draw_label("Paclitaxel", fontface='plain', size=14, x=0.55,y=0.92) + draw_label("B", fontface='bold',x=0.05,y=0.98, size=16)
p3 <- ggdraw() + draw_image(magick::image_read_pdf("g_d_overlap_1C.pdf", density = 1200),scale=1.0) + draw_label("Growth", fontface='plain', size=14, x=0.55,y=0.92) + draw_label("C", fontface='bold',x=0.05,y=0.98, size=16)
p4 <- ggdraw() + draw_image(magick::image_read_pdf("g_d_overlap_1D.pdf", density = 1200),scale=1.0) + draw_label("Paclitaxel", fontface='plain', size=14, x=0.55,y=0.92) + draw_label("D", fontface='bold',x=0.05,y=0.98, size=16)


pdf("g_d_overlap_hi_res_1.pdf", width=7.5, height=8, useDingbats = FALSE)
plot_grid(p1, p2, p3,  p4, ncol = 2, nrow = 2, align="h")
dev.off()















