library(ggplot2)
library(cowplot)
library(magick)


# --------------- import growth genes ------------

g <- read.delim("growth_loci.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE,check.names=FALSE)


#----------------- Prepare human logP ---------------------


logP <- read.table("log10P_human.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
human_thresh_95 <- read.table("human_thresh_95.txt",header=FALSE,sep="\t",stringsAsFactors=FALSE,row.names=1,col.names=c("","thresh"))



# Sort:
chrOrder<-paste("chr",c(1:22,"X"),sep="")
logP$Chromosome <- factor(logP$Chromosome, levels=chrOrder)
logP <- logP[order(logP$Chromosome, logP$pos), ]
logP$Chromosome <- as.character(logP$Chromosome)



# # Transform chr1 etc. to numbers
# logP$Chromosome <- gsub('chr', '', logP$Chromosome)
# logP[logP$Chromosome == "X","Chromosome"] <- 23
# chrOrder<-c(1:23)
# logP$Chromosome <- factor(logP$Chromosome, levels=chrOrder)
# logP <- logP[order(logP$Chromosome, logP$pos), ]
# logP$Chromosome <- as.numeric(logP$Chromosome)

# # Compute chromosome size
# gen_coord <- aggregate(pos~Chromosome,FUN=max,data=logP)
# colnames(gen_coord)[2] <- "chr_size"
# gen_coord$Chromosome <-factor(gen_coord$Chromosome, levels=chrOrder)
# gen_coord <- gen_coord[order(gen_coord$Chromosome), ]
# gen_coord$Chromosome <- as.numeric(gen_coord$Chromosome)

# # Use cumsum to make genome coordinates
# gen_coord$coord <- c(0,cumsum(gen_coord$chr_size)[-23])

# # merge genome coordinates with logP
# logP <- merge(logP,gen_coord[,c("Chromosome","coord")])
# logP$Chromosome <-factor(logP$Chromosome, levels=chrOrder)
# logP <- logP[order(logP$Chromosome, logP$pos), ]
# logP$Chromosome <- as.numeric(logP$Chromosome)

# logP$coord <- logP$pos + logP$coord


# # find midpoints of chromosomes for breaks in ggplot
# mid <- function(x) {(max(x)+min(x))/2}
# chr_mid <- aggregate(coord~Chromosome,FUN = mid,data=logP)
# colnames(chr_mid)[2] <- "mid"
# chr_mid$Chromosome <-factor(chr_mid$Chromosome, levels=chrOrder)
# chr_mid <- chr_mid[order(chr_mid$Chromosome), ]
# chr_mid$Chromosome <- as.numeric(chr_mid$Chromosome)

# # Define breaks as mid-points chromosomes
# breaks <- chr_mid$mid


# # attractive grey and skyblue color scheme
# cb1<-rep(c("grey", "skyblue"), 12)


# standard black color scheme
cb1<-rep(c("black", "black"), 12)




# ----------- Select large genes: -------------------

head(g[order(-g$geneLength),c("Chromosome","pos","conc","log10P","dist","geneSymbol","geneLength","gene_description")],30)



# --------------- Provide 0 nM growth to UCSC genome browser ---------------------



# ############## DO NOT DELETE #######################
# Important if want to reconstruct 0 nM growth data for UCSC genome browser


# g_0nM <- logP[,c("Chromosome","pos","log10p_g_0nM")]
# g_0nM$posS <- g_0nM$pos + 1
# g_0nM <- g_0nM[,c("Chromosome","pos","posS","log10p_g_0nM")]
# g_0nM$pos <- format(g_0nM$pos,scientific=FALSE)
# g_0nM$posS <- format(g_0nM$posS,scientific=FALSE)


# head(g_0nM)
  # # Chromosome       pos      posS log10p_g_0nM
# # 1       chr1      5000      5001 6.982125e-09
# # 2       chr1     10000     10001 3.158713e-01
# # 3       chr1     15000     15001 3.842510e-01
# # 4       chr1     20000     20001 5.904982e-01
# # 5       chr1     25000     25001 6.445060e-01
# # 6       chr1     30000     30001 3.869687e-01

# write.table(g_0nM, "growth_0nM_log10P.txt",quote=FALSE,sep="\t",row.names=FALSE,col.names=FALSE)


# # # Place following header at top of paclitaxel_logP_wk6.txt and use in bedGraph format on ucsc genome browser
# # track type=bedGraph name="-log10P" description="use name of gene zoomed in on" visibility=full color=0,0,255 altColor=255,0,0 priority=20

# # Custom track settings
# # Display mode: full
# # Type of graph: points
# # Track height: 128 pixels
# # Data view scaling: auto-scale to data view
# # Always include zero: ON
# # Vertical viewing range:  min: 0; max: 1000  (range: 0 to 1000) (greyed out)
# # Transform function: Transform data points by: NONE
# # Windowing function: mean
# # Smoothing window: OFF
# # Negate values: not selected
# # Draw y indicator lines: 
# # at y = 0.0: ON at y = 6.87537594442391 ON (corresponds to human_thresh_95.txt, for log10p_g_0nM)


# # Configure Image page on ucsc genome browser:
# # image width:	400	pixels
# # 	
# # text size: 12


# # Remember to get rid of splicoforms and nc genes by clicking GENCODE v31 bar on left of diagram, if desired. Then click on wrench and select "Transcript class": coding, "Transcript Annotation Method": All, "Transcript Biotype": protein_coding, "Tag":appris_principal_1, "Support Level": All. Leave "Highlight items" unselected.



# CSMD3: chr8:109,893,235-116,799,981
# NRG3: chr10:80,561,624-84,193,994 (need to show appris_principal_1 and appris_principal_3 to see NRG3)



# --------------- Provide 8 nM growth to UCSC genome browser ---------------------



# ############## DO NOT DELETE #######################
# Important if want to reconstruct 8 nM growth data for UCSC genome browser


# g_8nM <- logP[,c("Chromosome","pos","log10p_g_8nM")]
# g_8nM$posS <- g_8nM$pos + 1
# g_8nM <- g_8nM[,c("Chromosome","pos","posS","log10p_g_8nM")]
# g_8nM$pos <- format(g_8nM$pos,scientific=FALSE)
# g_8nM$posS <- format(g_8nM$posS,scientific=FALSE)


# head(g_8nM)
  # # Chromosome       pos      posS log10p_g_8nM
# # 1       chr1      5000      5001 7.400561e-09
# # 2       chr1     10000     10001 2.475338e-01
# # 3       chr1     15000     15001 3.312301e-01
# # 4       chr1     20000     20001 6.546860e-01
# # 5       chr1     25000     25001 8.301207e-01
# # 6       chr1     30000     30001 6.239936e-01

# write.table(g_8nM, "growth_8nM_log10P.txt",quote=FALSE,sep="\t",row.names=FALSE,col.names=FALSE)


# # # Place following header at top of paclitaxel_logP_wk6.txt and use in bedGraph format on ucsc genome browser
# # track type=bedGraph name="-log10P" description="use name of gene zoomed in on" visibility=full color=0,0,255 altColor=255,0,0 priority=20

# # Custom track settings
# # Display mode: full
# # Type of graph: points
# # Track height: 128 pixels
# # Data view scaling: auto-scale to data view
# # Always include zero: ON
# # Vertical viewing range:  min: 0; max: 1000  (range: 0 to 1000) (greyed out)
# # Transform function: Transform data points by: NONE
# # Windowing function: mean
# # Smoothing window: OFF
# # Negate values: not selected
# # Draw y indicator lines: 
# # at y = 0.0: ON at y = 8.12635869239555 ON (corresponds to human_thresh_95.txt, for log10p_g_8nM)


# # Configure Image page on ucsc genome browser:
# # image width:	400	pixels
# # label area width:	10	characters	
# # text size: 12


# # Remember to get rid of splicoforms and nc genes by clicking GENCODE v31 bar on left of diagram, if desired.



# --------------- Provide 25 nM growth to UCSC genome browser ---------------------



# ############## DO NOT DELETE #######################
# Important if want to reconstruct 25 nM growth data for UCSC genome browser


# g_25nM <- logP[,c("Chromosome","pos","log10p_g_25nM")]
# g_25nM$posS <- g_25nM$pos + 1
# g_25nM <- g_25nM[,c("Chromosome","pos","posS","log10p_g_25nM")]
# g_25nM$pos <- format(g_25nM$pos,scientific=FALSE)
# g_25nM$posS <- format(g_25nM$posS,scientific=FALSE)


# head(g_25nM)
  # # Chromosome       pos      posS log10p_g_25nM
# # 1       chr1      5000      5001  6.682535e-09
# # 2       chr1     10000     10001  3.580423e-02
# # 3       chr1     15000     15001  1.201381e-01
# # 4       chr1     20000     20001  6.079669e-01
# # 5       chr1     25000     25001  1.073263e+00
# # 6       chr1     30000     30001  1.186067e+00

# write.table(g_25nM, "growth_25nM_log10P.txt",quote=FALSE,sep="\t",row.names=FALSE,col.names=FALSE)


# # # Place following header at top of paclitaxel_logP_wk6.txt and use in bedGraph format on ucsc genome browser
# # track type=bedGraph name="-log10P" description="use name of gene zoomed in on" visibility=full color=0,0,255 altColor=255,0,0 priority=20

# # Custom track settings
# # Display mode: full
# # Type of graph: points
# # Track height: 128 pixels
# # Data view scaling: auto-scale to data view
# # Always include zero: ON
# # Vertical viewing range:  min: 0; max: 1000  (range: 0 to 1000) (greyed out)
# # Transform function: Transform data points by: NONE
# # Windowing function: mean
# # Smoothing window: OFF
# # Negate values: not selected
# # Draw y indicator lines: 
# # at y = 0.0: ON at y = 7.98475537997625 ON (corresponds to human_thresh_95.txt, for log10p_g_25nM)


# # Configure Image page on ucsc genome browser:
# # image width:	400	pixels
# # 	
# # text size: 12



# # Remember to get rid of splicoforms and nc genes by clicking GENCODE v31 bar on left of diagram, if desired. Then click on wrench and select "Transcript class": coding, "Transcript Annotation Method": All, "Transcript Biotype": protein_coding, "Tag":appris_principal_1, "Support Level": All. Leave "Highlight items" unselected.



# GALNTL6: chr4:171,488,945-173,331,030
# CDH12: chr5:19,510,875-25,093,138
# NRXN3: chr14:77,728,296-81,371,966



# --------------- Provide 75 nM growth to UCSC genome browser ---------------------



# ############## DO NOT DELETE #######################
# Important if want to reconstruct 75 nM growth data for UCSC genome browser


# g_75nM <- logP[,c("Chromosome","pos","log10p_g_75nM")]
# g_75nM$posS <- g_75nM$pos + 1
# g_75nM <- g_75nM[,c("Chromosome","pos","posS","log10p_g_75nM")]
# g_75nM$pos <- format(g_75nM$pos,scientific=FALSE)
# g_75nM$posS <- format(g_75nM$posS,scientific=FALSE)


# head(g_75nM)
  # # Chromosome       pos      posS log10p_g_75nM
# # 1       chr1      5000      5001  1.266072e-09
# # 2       chr1     10000     10001  2.715086e-01
# # 3       chr1     15000     15001  2.011749e-01
# # 4       chr1     20000     20001  1.094025e-01
# # 5       chr1     25000     25001  4.681747e-01
# # 6       chr1     30000     30001  9.089903e-01

# write.table(g_75nM, "growth_75nM_log10P.txt",quote=FALSE,sep="\t",row.names=FALSE,col.names=FALSE)


# # # Place following header at top of paclitaxel_logP_wk6.txt and use in bedGraph format on ucsc genome browser
# # track type=bedGraph name="-log10P" description="use name of gene zoomed in on" visibility=full color=0,0,255 altColor=255,0,0 priority=20

# # Custom track settings
# # Display mode: full
# # Type of graph: points
# # Track height: 128 pixels
# # Data view scaling: auto-scale to data view
# # Always include zero: ON
# # Vertical viewing range:  min: 0; max: 1000  (range: 0 to 1000) (greyed out)
# # Transform function: Transform data points by: NONE
# # Windowing function: mean
# # Smoothing window: OFF
# # Negate values: not selected
# # Draw y indicator lines: 
# # at y = 0.0: ON at y = 18.1033524350681 ON (corresponds to human_thresh_95.txt, for log10p_g_75nM)


# # Configure Image page on ucsc genome browser:
# # image width:	400	pixels
# # label area width:	10	characters	
# # text size: 12


# # Remember to get rid of splicoforms and nc genes by clicking GENCODE v31 bar on left of diagram, if desired. Then click on wrench and select "Transcript class": coding, "Transcript Annotation Method": All, "Transcript Biotype": protein_coding, "Tag":appris_principal_1, "Support Level": All. Leave "Highlight items" unselected.



# PTPRT: chr20:41,047,522-43,560,731



# --------------- Provide avg nM growth to UCSC genome browser ---------------------



# ############## DO NOT DELETE #######################
# Important if want to reconstruct avg nM growth data for UCSC genome browser


# g_avg <- logP[,c("Chromosome","pos","log10p_g_avg")]
# g_avg$posS <- g_avg$pos + 1
# g_avg <- g_avg[,c("Chromosome","pos","posS","log10p_g_avg")]
# g_avg$pos <- format(g_avg$pos,scientific=FALSE)
# g_avg$posS <- format(g_avg$posS,scientific=FALSE)


# head(g_avg)
  # # Chromosome       pos      posS log10p_g_avg
# # 1       chr1      5000      5001 6.424671e-09
# # 2       chr1     10000     10001 1.328866e-02
# # 3       chr1     15000     15001 9.428313e-02
# # 4       chr1     20000     20001 5.810749e-01
# # 5       chr1     25000     25001 1.064995e+00
# # 6       chr1     30000     30001 1.222462e+00

# write.table(g_avg, "growth_avg_log10P.txt",quote=FALSE,sep="\t",row.names=FALSE,col.names=FALSE)


# # # Place following header at top of paclitaxel_logP_wk6.txt and use in bedGraph format on ucsc genome browser
# # track type=bedGraph name="-log10P" description="use name of gene zoomed in on" visibility=full color=0,0,255 altColor=255,0,0 priority=20

# # Custom track settings
# # Display mode: full
# # Type of graph: points
# # Track height: 128 pixels
# # Data view scaling: auto-scale to data view
# # Always include zero: ON
# # Vertical viewing range:  min: 0; max: 1000  (range: 0 to 1000) (greyed out)
# # Transform function: Transform data points by: NONE
# # Windowing function: mean
# # Smoothing window: OFF
# # Negate values: not selected
# # Draw y indicator lines: 
# # at y = 0.0: ON at y = 8.07462412671946 ON (corresponds to human_thresh_95.txt, for log10p_g_avg)


# # Configure Image page on ucsc genome browser:
# # image width:	400	pixels
# # label area width:	10	characters	
# # text size: 12


# # Remember to get rid of splicoforms and nc genes by clicking GENCODE v31 bar on left of diagram, if desired.




# --------------- Do similar for paclitaxel log10P vals and provide to UCSC genome browser ---------------------






# ------------ Read pdfs ------------------------

# chr1:207,668,797-214,917,696
p1 <- ggdraw() + draw_image(magick::image_read_pdf("TRAF5_Growth_plat_0nM.pdf", density = 300),scale=1.0) + coord_cartesian(clip = "off") # + draw_label("Paclitaxel", fontface='plain', size=12, x=0.55,y=0.92) + draw_label("D", fontface='bold',x=0.05,y=0.98)



# chr4:79,018,225-84,944,150
p2 <- ggdraw() + draw_image(magick::image_read_pdf("RASGEF1B_Growth_plat_8nM.pdf", density = 300),scale=1.0) + coord_cartesian(clip = "off")
# p3a <- ggdraw() + draw_image(magick::image_read_pdf("CSMD1_0nM.pdf", density = 300),scale=1.4) + coord_cartesian(clip = "off")



# chr8:130,068,224-135,994,149
p3 <- ggdraw() + draw_image(magick::image_read_pdf("PHF20L1_Growth_plat_25nM.pdf", density = 300),scale=1.0) + coord_cartesian(clip = "off")



# chr9:3,266,706-8,660,090
p4 <- ggdraw() + draw_image(magick::image_read_pdf("KIAA2026_Growth_plat_avg.pdf", density = 300),scale=1.0) + coord_cartesian(clip = "off")


# difficult to find paclitaxel plateaus, so omitted
# p5 <- ggdraw() + draw_image(magick::image_read_pdf("Paclitaxel_plat_3wk.pdf", density = 300),scale=1.0) + coord_cartesian(clip = "off")
# p6 <- ggdraw() + draw_image(magick::image_read_pdf("Paclitaxel_plat_4wk.pdf", density = 300),scale=1.0) + coord_cartesian(clip = "off")


# -------------- Combine pdfs ------------------------------

# File size ~ 980 kb
pdf("g_d_plateaus_1.pdf", width=7.5, height=5.666667, useDingbats = FALSE)
plot_grid(p1, p2, p3,  p4, ncol = 2, nrow = 2, labels=c("A", "B", "C", "D"), label_size = 16, align="h")
dev.off()

# if smaller file size required, but do not gain much, so use pdf:
# File size ~956 kb
# png("g_d_plateaus_1.png",width=7.5,height= 5.666667,units="in",res=300)
# plot_grid(p1, p2, p3,  p4, p5, p6, ncol = 2, nrow = 2, labels=c("A", "B", "C", "D"), label_size = 14, align="h")
# dev.off()


# hi res

p1 <- ggdraw() + draw_image(magick::image_read_pdf("TRAF5_Growth_plat_0nM.pdf", density = 1200),scale=1.0) + coord_cartesian(clip = "off") # + draw_label("Paclitaxel", fontface='plain', size=12, x=0.55,y=0.92) + draw_label("D", 
p2 <- ggdraw() + draw_image(magick::image_read_pdf("RASGEF1B_Growth_plat_8nM.pdf", density = 1200),scale=1.0) + coord_cartesian(clip = "off")
p3 <- ggdraw() + draw_image(magick::image_read_pdf("PHF20L1_Growth_plat_25nM.pdf", density = 1200),scale=1.0) + coord_cartesian(clip = "off")
p4 <- ggdraw() + draw_image(magick::image_read_pdf("KIAA2026_Growth_plat_avg.pdf", density = 1200),scale=1.0) + coord_cartesian(clip = "off")


pdf("g_d_plateaus_hi_res_1.pdf", width=7.5, height=5.666667, useDingbats = FALSE)
plot_grid(p1, p2, p3,  p4, ncol = 2, nrow = 2, labels=c("A", "B", "C", "D"), label_size = 16, align="h")
dev.off()









































































