g <- read.delim("growth_loci.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
d <- read.delim("paclitaxel_loci.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)



g_unique <- read.delim("growth_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
d_unique <- read.delim("paclitaxel_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)


# -------- Overall numbers of loci ----------------


dim(g)
# [1] 1836   50


dim(d)
# [1]  97  50


dim(g_unique)
# [1] 859   50


dim(d_unique)
# [1] 38  50 <<<<<<<<<<<< use in paper




# -------------- Growth loci ------------------

dim(g)
# [1] 1836   50 <<<<<<<<<<< use in paper


dim(g_unique)
# [1] 859  50 <<<<<<<<<<< use in paper





chisq.test(c(length(g[g$conc==0,"conc"]),length(g[g$conc==8,"conc"]),length(g[g$conc==25,"conc"]),length(g[g$conc==75,"conc"])),rescale.p=TRUE)

	# Chi-squared test for given probabilities

# data:  c(length(g[g$conc == 0, "conc"]), length(g[g$conc == 8, "conc"]),     length(g[g$conc == 25, "conc"]), length(g[g$conc == 75, "conc"]))
# X-squared = 333.92, df = 3, p-value < 2.2e-16

chisq.test(c(length(g[g$conc==0,"conc"]),length(g[g$conc==8,"conc"]),length(g[g$conc==25,"conc"]),length(g[g$conc==75,"conc"])),rescale.p=TRUE)$p.value
# [1] 4.522452e-72

str(chisq.test(c(length(g[g$conc==0,"conc"]),length(g[g$conc==8,"conc"]),length(g[g$conc==25,"conc"]),length(g[g$conc==75,"conc"])),rescale.p=TRUE))
# List of 9
 # $ statistic: Named num 334
  # ..- attr(*, "names")= chr "X-squared"
 # $ parameter: Named num 3
  # ..- attr(*, "names")= chr "df"
 # $ p.value  : num 4.52e-72
 # $ method   : chr "Chi-squared test for given probabilities"
 # $ data.name: chr [1:2] "c(length(g[g$conc == 0, \"conc\"]), length(g[g$conc == 8, \"conc\"]), " "    length(g[g$conc == 25, \"conc\"]), length(g[g$conc == 75, \"conc\"]))"
 # $ observed : int [1:4] 409 460 466 55
 # $ expected : num [1:4] 348 348 348 348
 # $ residuals: num [1:4] 3.3 6.03 6.36 -15.69
 # $ stdres   : num [1:4] 3.81 6.97 7.34 -18.12
 # - attr(*, "class")= chr "htest"




# -------------- Paclitaxel loci ------------------

dim(d)
# [1] 97 50 <<<<<<<<<<< use in paper


dim(d_unique)
# [1] 38 50 <<<<<<<<<<< use in paper



chisq.test(c(length(d[d$wk==1,"wk"]),length(d[d$wk==2,"wk"]),length(d[d$wk==3,"wk"]),length(d[d$wk==4,"wk"]),length(d[d$wk==6,"wk"])),rescale.p=TRUE)

	# Chi-squared test for given probabilities

# data:  c(length(d[d$wk == 1, "wk"]), length(d[d$wk == 2, "wk"]), length(d[d$wk ==     3, "wk"]), length(d[d$wk == 4, "wk"]), length(d[d$wk == 6,     "wk"]))
# X-squared = 43.694, df = 4, p-value = 7.425e-09 <<<<<<<<<<<< use in paper

chisq.test(c(length(d[d$wk==1,"wk"]),length(d[d$wk==2,"wk"]),length(d[d$wk==3,"wk"]),length(d[d$wk==4,"wk"]),length(d[d$wk==6,"wk"])),rescale.p=TRUE)$p.value
# [1] 7.425152e-09 <<<<<<<<<<<< use in paper

str(chisq.test(c(length(d[d$wk==1,"wk"]),length(d[d$wk==2,"wk"]),length(d[d$wk==3,"wk"]),length(d[d$wk==4,"wk"]),length(d[d$wk==6,"wk"])),rescale.p=TRUE))
# List of 9
 # $ statistic: Named num 43.7
  # ..- attr(*, "names")= chr "X-squared"
 # $ parameter: Named num 4
  # ..- attr(*, "names")= chr "df"
 # $ p.value  : num 7.43e-09
 # $ method   : chr "Chi-squared test for given probabilities"
 # $ data.name: chr [1:3] "c(length(d[d$wk == 1, \"wk\"]), length(d[d$wk == 2, \"wk\"]), length(d[d$wk == " "    3, \"wk\"]), length(d[d$wk == 4, \"wk\"]), length(d[d$wk == 6, " "    \"wk\"]))"
 # $ observed : int [1:5] 0 2 26 19 25
 # $ expected : num [1:5] 14.4 14.4 14.4 14.4 14.4
 # $ residuals: num [1:5] -3.79 -3.27 3.06 1.21 2.79
 # $ stdres   : num [1:5] -4.24 -3.65 3.42 1.36 3.12
 # - attr(*, "class")= chr "htest"
 














