library(ggplot2)
library(cowplot) #used with plot_grid 


#----------------Aesthetics ---------------------------


theme2 <- theme(
	plot.margin = unit(c(t=0.5,r=1,b=0.5,l=1), "cm"),
	panel.grid.major = element_blank(), 
	panel.grid.minor = element_blank(), 
	panel.background = element_blank(), 
	legend.position="none", 
	axis.line.x = element_line(colour = "black", size = 0.1), 
	axis.line.y = element_line(colour = "black", size = 0.1), 
	axis.ticks = element_line(colour = "black", size = 0.1),
	axis.text=element_text(size=12), #numbers on tick marks of x and y axes
	axis.title=element_text(size=14), #titles of x and y axes
	axis.title.y=element_text(margin=margin(0,13,0,0)), #moves y axis title by adding margin space to bottom
	axis.title.x=element_text(margin=margin(10,0,0,0)),  #moves x axis title by adding margin space to top
	# plot.title = element_text(size=32, face="bold", hjust = -0.14), #can provide "A","B", by ggtitle, but used plot_grid wch can shift more left
	plot.subtitle = element_text(size=14, face="plain", hjust = 0.5, margin=margin(0,0,13,0)) #hjust shifts right
	)

gg_color_hue <- function(n) {
  hues = seq(15, 375, length = n + 1)
  hcl(h = hues, l = 65, c = 100)[1:n]
}

size_hline <- 0.1


# balloon_scale <- 5 # inflation factor for significant points	
# size_point <- 0.1*(1 + balloon_scale*(logP$log10p_g_avg/max(logP$log10p_g_avg))) # scale significant points


# P < 0.05 horizontal line
p_line <- -log10(0.05)


#-------------dld1_fisher_ovlap_graph (1)------------


# petal.txt is from Moffat supp data file mmc3-1.xlsx

petal <- read.table("petal.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
petal <- petal[,c("Gene", "BF_hct116", "BF_hela", "BF_gbm", "BF_rpe1", "BF_dld1")] # omit 1st gen crispr BF_a375_GeCKo
g_unique <- read.delim("growth_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
petal$RH <- numeric(nrow(petal))
petal[petal$Gene %in% g_unique$geneSymbol,"RH"] <- 1



petal_dld1_RH_overlap <- data.frame(
BF_dld1_thres = numeric(), 	#col 1
ptl_rh=numeric(), 				#col 2
noptl_rh=numeric(), 			#col 3
ptl_norh=numeric(), 			#col 4
noptl_norh=numeric(), 			#col 5
obs=numeric(), 					#col 6
exp=numeric(), 					#col 7
chi_sq=numeric(),				#col 8
chi_df=numeric(),				#col 9
P_chi=numeric(),				#col 10
fish_OR=numeric(),				#col 11
fish_conf_1=numeric(),			#col 12
fish_conf_2=numeric(),			#col 13
P_fish=numeric()				#col 14
)


BF_dld1_max <- petal[which.max(petal$BF_dld1),]$BF_dld1
BF_dld1_min <- petal[which.min(petal$BF_dld1),]$BF_dld1

vec <- seq(BF_dld1_min, BF_dld1_max,(BF_dld1_max-BF_dld1_min)/100)


for(i in 1:101) {

petal_dld1_RH_overlap[i,1] <- vec[i]
petal_dld1_RH_overlap[i,2] <- dim(petal[petal$BF_dld1 > vec[i] & !is.na(petal$BF_dld1) & petal$RH == 1,])[1]
petal_dld1_RH_overlap[i,3] <- dim(petal[petal$BF_dld1 < vec[i] & !is.na(petal$BF_dld1) & petal$RH == 1,])[1]
petal_dld1_RH_overlap[i,4] <- dim(petal[petal$BF_dld1 > vec[i] & !is.na(petal$BF_dld1) & petal$RH == 0,])[1]
petal_dld1_RH_overlap[i,5] <- dim(petal[petal$BF_dld1 < vec[i] & !is.na(petal$BF_dld1) & petal$RH == 0,])[1]

chi <- chisq.test(matrix(c(petal_dld1_RH_overlap[i,2],petal_dld1_RH_overlap[i,3],petal_dld1_RH_overlap[i,4], petal_dld1_RH_overlap[i,5]),2,2,byrow=TRUE))
fish <- fisher.test(matrix(c(petal_dld1_RH_overlap[i,2],petal_dld1_RH_overlap[i,3],petal_dld1_RH_overlap[i,4], petal_dld1_RH_overlap[i,5]),2,2,byrow=TRUE))

petal_dld1_RH_overlap[i,6] <- chi$observed[1,1]
petal_dld1_RH_overlap[i,7] <- chi$expected[1,1]
petal_dld1_RH_overlap[i,8] <- chi$statistic
petal_dld1_RH_overlap[i,9] <- chi$parameter[[1]]
petal_dld1_RH_overlap[i,10] <- chi$p.value
petal_dld1_RH_overlap[i,11] <- fish$estimate[[1]]
petal_dld1_RH_overlap[i,12] <- fish$conf.int[[1]]
petal_dld1_RH_overlap[i,13] <- fish$conf.int[[2]]
petal_dld1_RH_overlap[i,14] <- fish$p.value

}

petal_dld1_RH_overlap$q_fish <- p.adjust(petal_dld1_RH_overlap$P_fish, method = "BH")
h_line_1 <- max(petal_dld1_RH_overlap[petal_dld1_RH_overlap$q_fish < 0.05,]$P_fish)


# https://stackoverflow.com/questions/50293125/r-change-ggplot-legend-names-with-scale-linetype-manual

p1 <- ggplot() + 
		theme2 + 
		theme(legend.key=element_blank()) +
		geom_line(
			data= petal_dld1_RH_overlap, 
			lwd=0.2,
			colour="black",
			show.legend=FALSE,
			aes(
				x= BF_dld1_thres, 
				y= -log10(petal_dld1_RH_overlap$P_fish)
				)
			) +
		geom_hline(
			color = "red", 
			size=size_hline,
			aes(
				yintercept = -log10(h_line_1), 
				linetype = "a"
				)
			) +
		geom_hline(
			color = "blue",
			size=size_hline,
			aes(
				yintercept = p_line, 
				linetype = "b"
				)
			) +
		scale_linetype_manual(
			name = NULL, 
			labels = c(expression(FDR==0.05),expression(italic(P)==0.05)),
			values = c("solid","dashed"), 
			guide = guide_legend(
						override.aes = list(
											color = c("red","blue"),
											size=c(size_hline, size_hline)
											)
							)
			) +
		theme(
		 	legend.position = c(0.8,0.9), 
			legend.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.box.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.key.height = unit(0.3, "cm"),
			legend.key.width = unit(0.4, "cm"),
		 	legend.spacing.y = unit(0.3, 'cm'),
		 	legend.spacing.x = unit(0.2, 'cm'),
		 	legend.title = element_text(size = 11),  
		 	legend.text = element_text(size = 10),
	 		legend.title.align=0.7,
	 		legend.text.align=0
 			) +
		labs(subtitle="DLD-1") +
		xlab("BF") + 
		# scale_x_continuous(breaks = c(0,1,2,3,4,6), labels = c(0,1,2,3,4,6)) + 
		ylab(expression(-log[10]*italic('P'))) 
print(p1)




#-------------gbm_fisher_ovlap_graph (2)------------


# petal.txt is from Moffat supp data file mmc3-1.xlsx

petal <- read.table("petal.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
petal <- petal[,c("Gene", "BF_hct116", "BF_hela", "BF_gbm", "BF_rpe1", "BF_dld1")] # omit 1st gen crispr BF_a375_GeCKo
g_unique <- read.delim("growth_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
petal$RH <- numeric(nrow(petal))
petal[petal$Gene %in% g_unique$geneSymbol,"RH"] <- 1



petal_gbm_RH_overlap <- data.frame(
BF_gbm_thres = numeric(), 	#col 1
ptl_rh=numeric(), 				#col 2
noptl_rh=numeric(), 			#col 3
ptl_norh=numeric(), 			#col 4
noptl_norh=numeric(), 			#col 5
obs=numeric(), 					#col 6
exp=numeric(), 					#col 7
chi_sq=numeric(),				#col 8
chi_df=numeric(),				#col 9
P_chi=numeric(),				#col 10
fish_OR=numeric(),				#col 11
fish_conf_1=numeric(),			#col 12
fish_conf_2=numeric(),			#col 13
P_fish=numeric()				#col 14
)


BF_gbm_max <- petal[which.max(petal$BF_gbm),]$BF_gbm
BF_gbm_min <- petal[which.min(petal$BF_gbm),]$BF_gbm

vec <- seq(BF_gbm_min, BF_gbm_max,(BF_gbm_max-BF_gbm_min)/100)


for(i in 1:101) {

petal_gbm_RH_overlap[i,1] <- vec[i]
petal_gbm_RH_overlap[i,2] <- dim(petal[petal$BF_gbm > vec[i] & !is.na(petal$BF_gbm) & petal$RH == 1,])[1]
petal_gbm_RH_overlap[i,3] <- dim(petal[petal$BF_gbm < vec[i] & !is.na(petal$BF_gbm) & petal$RH == 1,])[1]
petal_gbm_RH_overlap[i,4] <- dim(petal[petal$BF_gbm > vec[i] & !is.na(petal$BF_gbm) & petal$RH == 0,])[1]
petal_gbm_RH_overlap[i,5] <- dim(petal[petal$BF_gbm < vec[i] & !is.na(petal$BF_gbm) & petal$RH == 0,])[1]

chi <- chisq.test(matrix(c(petal_gbm_RH_overlap[i,2],petal_gbm_RH_overlap[i,3],petal_gbm_RH_overlap[i,4], petal_gbm_RH_overlap[i,5]),2,2,byrow=TRUE))
fish <- fisher.test(matrix(c(petal_gbm_RH_overlap[i,2],petal_gbm_RH_overlap[i,3],petal_gbm_RH_overlap[i,4], petal_gbm_RH_overlap[i,5]),2,2,byrow=TRUE))

petal_gbm_RH_overlap[i,6] <- chi$observed[1,1]
petal_gbm_RH_overlap[i,7] <- chi$expected[1,1]
petal_gbm_RH_overlap[i,8] <- chi$statistic
petal_gbm_RH_overlap[i,9] <- chi$parameter[[1]]
petal_gbm_RH_overlap[i,10] <- chi$p.value
petal_gbm_RH_overlap[i,11] <- fish$estimate[[1]]
petal_gbm_RH_overlap[i,12] <- fish$conf.int[[1]]
petal_gbm_RH_overlap[i,13] <- fish$conf.int[[2]]
petal_gbm_RH_overlap[i,14] <- fish$p.value

}

petal_gbm_RH_overlap$q_fish <- p.adjust(petal_gbm_RH_overlap$P_fish, method = "BH")
h_line_2 <- max(petal_gbm_RH_overlap[petal_gbm_RH_overlap$q_fish < 0.05,]$P_fish)

p2 <- ggplot() + 
		theme2 + 
		theme(legend.key=element_blank()) +
		geom_line(
			data= petal_gbm_RH_overlap, 
			lwd=0.2,
			colour="black",
			show.legend=FALSE,
			aes(
				x= BF_gbm_thres, 
				y= -log10(petal_gbm_RH_overlap$P_fish)
				)
			) +
		geom_hline(
			color = "red", 
			size=size_hline,
			aes(
				yintercept = -log10(h_line_2), 
				linetype = "a"
				)
			) +
		geom_hline(
			color = "blue",
			size=size_hline,
			aes(
				yintercept = p_line, 
				linetype = "b"
				)
			) +
		scale_linetype_manual(
			name = NULL, 
			labels = c(expression(FDR==0.05),expression(italic(P)==0.05)),
			values = c("solid","dashed"),  
			guide = guide_legend(
						override.aes = list(
											color = c("red","blue"),
											size=c(size_hline, size_hline)
											)
							)
			) +
		theme(
		 	legend.position = c(0.8,0.9), 
			legend.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.box.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.key.height = unit(0.3, "cm"),
			legend.key.width = unit(0.4, "cm"),
		 	legend.spacing.y = unit(0.3, 'cm'),
		 	legend.spacing.x = unit(0.2, 'cm'),
		 	legend.title = element_text(size = 11),  
		 	legend.text = element_text(size = 10),
	 		legend.title.align=0.7,
	 		legend.text.align=0
 			) +
		labs(subtitle="GBM") +
		xlab("BF") + 
		# scale_x_continuous(breaks = c(0,1,2,3,4,6), labels = c(0,1,2,3,4,6)) + 
		ylab(expression(-log[10]*italic('P'))) 
print(p2)




#-------------rpe1_fisher_ovlap_graph (3)------------


# petal.txt is from Moffat supp data file mmc3-1.xlsx

petal <- read.table("petal.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
petal <- petal[,c("Gene", "BF_hct116", "BF_hela", "BF_gbm", "BF_rpe1", "BF_dld1")] # omit 1st gen crispr BF_a375_GeCKo
g_unique <- read.delim("growth_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
petal$RH <- numeric(nrow(petal))
petal[petal$Gene %in% g_unique$geneSymbol,"RH"] <- 1



petal_rpe1_RH_overlap <- data.frame(
BF_rpe1_thres = numeric(), 	#col 1
ptl_rh=numeric(), 				#col 2
noptl_rh=numeric(), 			#col 3
ptl_norh=numeric(), 			#col 4
noptl_norh=numeric(), 			#col 5
obs=numeric(), 					#col 6
exp=numeric(), 					#col 7
chi_sq=numeric(),				#col 8
chi_df=numeric(),				#col 9
P_chi=numeric(),				#col 10
fish_OR=numeric(),				#col 11
fish_conf_1=numeric(),			#col 12
fish_conf_2=numeric(),			#col 13
P_fish=numeric()				#col 14
)


BF_rpe1_max <- petal[which.max(petal$BF_rpe1),]$BF_rpe1
BF_rpe1_min <- petal[which.min(petal$BF_rpe1),]$BF_rpe1

vec <- seq(BF_rpe1_min, BF_rpe1_max,(BF_rpe1_max-BF_rpe1_min)/100)


for(i in 1:101) {

petal_rpe1_RH_overlap[i,1] <- vec[i]
petal_rpe1_RH_overlap[i,2] <- dim(petal[petal$BF_rpe1 > vec[i] & !is.na(petal$BF_rpe1) & petal$RH == 1,])[1]
petal_rpe1_RH_overlap[i,3] <- dim(petal[petal$BF_rpe1 < vec[i] & !is.na(petal$BF_rpe1) & petal$RH == 1,])[1]
petal_rpe1_RH_overlap[i,4] <- dim(petal[petal$BF_rpe1 > vec[i] & !is.na(petal$BF_rpe1) & petal$RH == 0,])[1]
petal_rpe1_RH_overlap[i,5] <- dim(petal[petal$BF_rpe1 < vec[i] & !is.na(petal$BF_rpe1) & petal$RH == 0,])[1]

chi <- chisq.test(matrix(c(petal_rpe1_RH_overlap[i,2],petal_rpe1_RH_overlap[i,3],petal_rpe1_RH_overlap[i,4], petal_rpe1_RH_overlap[i,5]),2,2,byrow=TRUE))
fish <- fisher.test(matrix(c(petal_rpe1_RH_overlap[i,2],petal_rpe1_RH_overlap[i,3],petal_rpe1_RH_overlap[i,4], petal_rpe1_RH_overlap[i,5]),2,2,byrow=TRUE))

petal_rpe1_RH_overlap[i,6] <- chi$observed[1,1]
petal_rpe1_RH_overlap[i,7] <- chi$expected[1,1]
petal_rpe1_RH_overlap[i,8] <- chi$statistic
petal_rpe1_RH_overlap[i,9] <- chi$parameter[[1]]
petal_rpe1_RH_overlap[i,10] <- chi$p.value
petal_rpe1_RH_overlap[i,11] <- fish$estimate[[1]]
petal_rpe1_RH_overlap[i,12] <- fish$conf.int[[1]]
petal_rpe1_RH_overlap[i,13] <- fish$conf.int[[2]]
petal_rpe1_RH_overlap[i,14] <- fish$p.value

}

petal_rpe1_RH_overlap$q_fish <- p.adjust(petal_rpe1_RH_overlap$P_fish, method = "BH")
h_line_3 <- max(petal_rpe1_RH_overlap[petal_rpe1_RH_overlap$q_fish < 0.05,]$P_fish)

p3 <- ggplot() + 
		theme2 + 
		theme(legend.key=element_blank()) +
		geom_line(
			data= petal_rpe1_RH_overlap, 
			lwd=0.2,
			colour="black",
			show.legend=FALSE,
			aes(
				x= BF_rpe1_thres, 
				y= -log10(petal_rpe1_RH_overlap$P_fish)
				)
			) +
		geom_hline(
			color = "red", 
			size=size_hline,
			aes(
				yintercept = -log10(h_line_3), 
				linetype = "a"
				)
			) +
		geom_hline(
			color = "blue",
			size=size_hline,
			aes(
				yintercept = p_line, 
				linetype = "b"
				)
			) +
		scale_linetype_manual(
			name = NULL, 
			labels = c(expression(FDR==0.05),expression(italic(P)==0.05)),
			values = c("solid","dashed"), 
			guide = guide_legend(
						override.aes = list(
											color = c("red","blue"),
											size=c(size_hline, size_hline)
											)
							)
			) +
		theme(
		 	legend.position = c(0.8,0.9), 
			legend.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.box.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.key.height = unit(0.3, "cm"),
			legend.key.width = unit(0.4, "cm"),
		 	legend.spacing.y = unit(0.3, 'cm'),
		 	legend.spacing.x = unit(0.2, 'cm'),
		 	legend.title = element_text(size = 11),  
		 	legend.text = element_text(size = 10),
	 		legend.title.align=0.7,
	 		legend.text.align=0
 			) +
		labs(subtitle="RPE-1") +
		xlab("BF") + 
		# scale_x_continuous(breaks = c(0,1,2,3,4,6), labels = c(0,1,2,3,4,6)) + 
		ylab(expression(-log[10]*italic('P'))) 
print(p3)




#-------------hela_fisher_ovlap_graph (4)------------


# petal.txt is from Moffat supp data file mmc3-1.xlsx

petal <- read.table("petal.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
petal <- petal[,c("Gene", "BF_hct116", "BF_hela", "BF_gbm", "BF_rpe1", "BF_dld1")] # omit 1st gen crispr BF_a375_GeCKo
g_unique <- read.delim("growth_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
petal$RH <- numeric(nrow(petal))
petal[petal$Gene %in% g_unique$geneSymbol,"RH"] <- 1



petal_hela_RH_overlap <- data.frame(
BF_hela_thres = numeric(), 	#col 1
ptl_rh=numeric(), 				#col 2
noptl_rh=numeric(), 			#col 3
ptl_norh=numeric(), 			#col 4
noptl_norh=numeric(), 			#col 5
obs=numeric(), 					#col 6
exp=numeric(), 					#col 7
chi_sq=numeric(),				#col 8
chi_df=numeric(),				#col 9
P_chi=numeric(),				#col 10
fish_OR=numeric(),				#col 11
fish_conf_1=numeric(),			#col 12
fish_conf_2=numeric(),			#col 13
P_fish=numeric()				#col 14
)


BF_hela_max <- petal[which.max(petal$BF_hela),]$BF_hela
BF_hela_min <- petal[which.min(petal$BF_hela),]$BF_hela

vec <- seq(BF_hela_min, BF_hela_max,(BF_hela_max-BF_hela_min)/100)


for(i in 1:101) {

petal_hela_RH_overlap[i,1] <- vec[i]
petal_hela_RH_overlap[i,2] <- dim(petal[petal$BF_hela > vec[i] & !is.na(petal$BF_hela) & petal$RH == 1,])[1]
petal_hela_RH_overlap[i,3] <- dim(petal[petal$BF_hela < vec[i] & !is.na(petal$BF_hela) & petal$RH == 1,])[1]
petal_hela_RH_overlap[i,4] <- dim(petal[petal$BF_hela > vec[i] & !is.na(petal$BF_hela) & petal$RH == 0,])[1]
petal_hela_RH_overlap[i,5] <- dim(petal[petal$BF_hela < vec[i] & !is.na(petal$BF_hela) & petal$RH == 0,])[1]

chi <- chisq.test(matrix(c(petal_hela_RH_overlap[i,2],petal_hela_RH_overlap[i,3],petal_hela_RH_overlap[i,4], petal_hela_RH_overlap[i,5]),2,2,byrow=TRUE))
fish <- fisher.test(matrix(c(petal_hela_RH_overlap[i,2],petal_hela_RH_overlap[i,3],petal_hela_RH_overlap[i,4], petal_hela_RH_overlap[i,5]),2,2,byrow=TRUE))

petal_hela_RH_overlap[i,6] <- chi$observed[1,1]
petal_hela_RH_overlap[i,7] <- chi$expected[1,1]
petal_hela_RH_overlap[i,8] <- chi$statistic
petal_hela_RH_overlap[i,9] <- chi$parameter[[1]]
petal_hela_RH_overlap[i,10] <- chi$p.value
petal_hela_RH_overlap[i,11] <- fish$estimate[[1]]
petal_hela_RH_overlap[i,12] <- fish$conf.int[[1]]
petal_hela_RH_overlap[i,13] <- fish$conf.int[[2]]
petal_hela_RH_overlap[i,14] <- fish$p.value

}

petal_hela_RH_overlap$q_fish <- p.adjust(petal_hela_RH_overlap$P_fish, method = "BH")
h_line_4 <- max(petal_hela_RH_overlap[petal_hela_RH_overlap$q_fish < 0.05,]$P_fish)

p4 <- ggplot() + 
		theme2 + 
		theme(legend.key=element_blank()) +
		geom_line(
			data= petal_hela_RH_overlap, 
			lwd=0.2,
			colour="black",
			show.legend=FALSE,
			aes(
				x= BF_hela_thres, 
				y= -log10(petal_hela_RH_overlap$P_fish)
				)
			) +
		geom_hline(
			color = "red", 
			size=size_hline,
			aes(
				yintercept = -log10(h_line_4), 
				linetype = "a"
				)
			) +
		geom_hline(
			color = "blue",
			size=size_hline,
			aes(
				yintercept = p_line, 
				linetype = "b"
				)
			) +
		scale_linetype_manual(
			name = NULL, 
			labels = c(expression(FDR==0.05),expression(italic(P)==0.05)),
			values = c("solid","dashed"),  
			guide = guide_legend(
						override.aes = list(
											color = c("red","blue"),
											size=c(size_hline, size_hline)
											)
							)
			) +
		theme(
		 	legend.position = c(0.8,0.9), 
			legend.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.box.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.key.height = unit(0.3, "cm"),
			legend.key.width = unit(0.4, "cm"),
		 	legend.spacing.y = unit(0.3, 'cm'),
		 	legend.spacing.x = unit(0.2, 'cm'),
		 	legend.title = element_text(size = 11),  
		 	legend.text = element_text(size = 10),
	 		legend.title.align=0.7,
	 		legend.text.align=0
 			) +
		labs(subtitle="HeLa") +
		xlab("BF") + 
		# scale_x_continuous(breaks = c(0,1,2,3,4,6), labels = c(0,1,2,3,4,6)) + 
		ylab(expression(-log[10]*italic('P'))) 
print(p4)




#-------------hct116_fisher_ovlap_graph (5)------------


# petal.txt is from Moffat supp data file mmc3-1.xlsx

petal <- read.table("petal.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
petal <- petal[,c("Gene", "BF_hct116", "BF_hela", "BF_gbm", "BF_rpe1", "BF_dld1")] # omit 1st gen crispr BF_a375_GeCKo
g_unique <- read.delim("growth_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
petal$RH <- numeric(nrow(petal))
petal[petal$Gene %in% g_unique$geneSymbol,"RH"] <- 1



petal_hct116_RH_overlap <- data.frame(
BF_hct116_thres = numeric(), 	#col 1
ptl_rh=numeric(), 				#col 2
noptl_rh=numeric(), 			#col 3
ptl_norh=numeric(), 			#col 4
noptl_norh=numeric(), 			#col 5
obs=numeric(), 					#col 6
exp=numeric(), 					#col 7
chi_sq=numeric(),				#col 8
chi_df=numeric(),				#col 9
P_chi=numeric(),				#col 10
fish_OR=numeric(),				#col 11
fish_conf_1=numeric(),			#col 12
fish_conf_2=numeric(),			#col 13
P_fish=numeric()				#col 14
)


BF_hct116_max <- petal[which.max(petal$BF_hct116),]$BF_hct116
BF_hct116_min <- petal[which.min(petal$BF_hct116),]$BF_hct116

vec <- seq(BF_hct116_min, BF_hct116_max,(BF_hct116_max-BF_hct116_min)/100)


for(i in 1:101) {

petal_hct116_RH_overlap[i,1] <- vec[i]
petal_hct116_RH_overlap[i,2] <- dim(petal[petal$BF_hct116 > vec[i] & !is.na(petal$BF_hct116) & petal$RH == 1,])[1]
petal_hct116_RH_overlap[i,3] <- dim(petal[petal$BF_hct116 < vec[i] & !is.na(petal$BF_hct116) & petal$RH == 1,])[1]
petal_hct116_RH_overlap[i,4] <- dim(petal[petal$BF_hct116 > vec[i] & !is.na(petal$BF_hct116) & petal$RH == 0,])[1]
petal_hct116_RH_overlap[i,5] <- dim(petal[petal$BF_hct116 < vec[i] & !is.na(petal$BF_hct116) & petal$RH == 0,])[1]

chi <- chisq.test(matrix(c(petal_hct116_RH_overlap[i,2],petal_hct116_RH_overlap[i,3],petal_hct116_RH_overlap[i,4], petal_hct116_RH_overlap[i,5]),2,2,byrow=TRUE))
fish <- fisher.test(matrix(c(petal_hct116_RH_overlap[i,2],petal_hct116_RH_overlap[i,3],petal_hct116_RH_overlap[i,4], petal_hct116_RH_overlap[i,5]),2,2,byrow=TRUE))

petal_hct116_RH_overlap[i,6] <- chi$observed[1,1]
petal_hct116_RH_overlap[i,7] <- chi$expected[1,1]
petal_hct116_RH_overlap[i,8] <- chi$statistic
petal_hct116_RH_overlap[i,9] <- chi$parameter[[1]]
petal_hct116_RH_overlap[i,10] <- chi$p.value
petal_hct116_RH_overlap[i,11] <- fish$estimate[[1]]
petal_hct116_RH_overlap[i,12] <- fish$conf.int[[1]]
petal_hct116_RH_overlap[i,13] <- fish$conf.int[[2]]
petal_hct116_RH_overlap[i,14] <- fish$p.value

}

petal_hct116_RH_overlap$q_fish <- p.adjust(petal_hct116_RH_overlap$P_fish, method = "BH")
h_line_5 <- max(petal_hct116_RH_overlap[petal_hct116_RH_overlap$q_fish < 0.05,]$P_fish)

p5 <- ggplot() + 
		theme2 + 
		theme(legend.key=element_blank()) +
		geom_line(
			data= petal_hct116_RH_overlap, 
			lwd=0.2,
			colour="black",
			show.legend=FALSE,
			aes(
				x= BF_hct116_thres, 
				y= -log10(petal_hct116_RH_overlap$P_fish)
				)
			) +
		geom_hline(
			color = "red", 
			size=size_hline,
			aes(
				yintercept = -log10(h_line_5), 
				linetype = "a"
				)
			) +
		geom_hline(
			color = "blue",
			size=size_hline,
			aes(
				yintercept = p_line, 
				linetype = "b"
				)
			) +
		scale_linetype_manual(
			name = NULL, 
			labels = c(expression(FDR==0.05),expression(italic(P)==0.05)),
			values = c("solid","dashed"),  
			guide = guide_legend(
						override.aes = list(
											color = c("red","blue"),
											size=c(size_hline, size_hline)
											)
							)
			) +
		theme(
		 	legend.position = c(0.8,0.9), 
			legend.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.box.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.key.height = unit(0.3, "cm"),
			legend.key.width = unit(0.4, "cm"),
		 	legend.spacing.y = unit(0.3, 'cm'),
		 	legend.spacing.x = unit(0.2, 'cm'),
		 	legend.title = element_text(size = 11),  
		 	legend.text = element_text(size = 10),
	 		legend.title.align=0.7,
	 		legend.text.align=0
 			) +
		labs(subtitle="HCT116") +
		xlab("BF") + 
		# scale_x_continuous(breaks = c(0,1,2,3,4,6), labels = c(0,1,2,3,4,6)) + 
		ylab(expression(-log[10]*italic('P'))) 
print(p5)



#-------------numTKOHits_fisher_ovlap_bargraph (6) ------------


# petal.txt is from Moffat supp data file mmc3-1.xlsx

petal <- read.table("petal.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
petal <- petal[,c("Gene","numTKOHits")]
g_unique <- read.delim("growth_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
petal$RH <- numeric(nrow(petal))
petal[petal$Gene %in% g_unique$geneSymbol,"RH"] <- 1


petal_numTKOHits_RH_overlap <- data.frame(
numTKOHits_thres = numeric(), 	#col 1
ptl_rh=numeric(), 				#col 2
noptl_rh=numeric(), 			#col 3
ptl_norh=numeric(), 			#col 4
noptl_norh=numeric(), 			#col 5
obs=numeric(), 					#col 6
exp=numeric(), 					#col 7
chi_sq=numeric(),				#col 8
chi_df=numeric(),				#col 9
P_chi=numeric(),				#col 10
fish_OR=numeric(),				#col 11
fish_conf_1=numeric(),			#col 12
fish_conf_2=numeric(),			#col 13
P_fish=numeric()				#col 14
)


numTKOHits_max <- petal[which.max(petal$numTKOHits),]$numTKOHits
numTKOHits_min <- petal[which.min(petal$numTKOHits),]$numTKOHits

vec <- c(0:5)


for(i in 1:6) {

petal_numTKOHits_RH_overlap[i,1] <- vec[i]
petal_numTKOHits_RH_overlap[i,2] <- dim(petal[petal$numTKOHits > vec[i] & !is.na(petal$numTKOHits) & petal$RH == 1,])[1]
petal_numTKOHits_RH_overlap[i,3] <- dim(petal[petal$numTKOHits < vec[i] & !is.na(petal$numTKOHits) & petal$RH == 1,])[1]
petal_numTKOHits_RH_overlap[i,4] <- dim(petal[petal$numTKOHits > vec[i] & !is.na(petal$numTKOHits) & petal$RH == 0,])[1]
petal_numTKOHits_RH_overlap[i,5] <- dim(petal[petal$numTKOHits < vec[i] & !is.na(petal$numTKOHits) & petal$RH == 0,])[1]

chi <- chisq.test(matrix(c(petal_numTKOHits_RH_overlap[i,2],petal_numTKOHits_RH_overlap[i,3],petal_numTKOHits_RH_overlap[i,4], petal_numTKOHits_RH_overlap[i,5]),2,2,byrow=TRUE))
fish <- fisher.test(matrix(c(petal_numTKOHits_RH_overlap[i,2],petal_numTKOHits_RH_overlap[i,3],petal_numTKOHits_RH_overlap[i,4], petal_numTKOHits_RH_overlap[i,5]),2,2,byrow=TRUE))

petal_numTKOHits_RH_overlap[i,6] <- chi$observed[1,1]
petal_numTKOHits_RH_overlap[i,7] <- chi$expected[1,1]
petal_numTKOHits_RH_overlap[i,8] <- chi$statistic
petal_numTKOHits_RH_overlap[i,9] <- chi$parameter[[1]]
petal_numTKOHits_RH_overlap[i,10] <- chi$p.value
petal_numTKOHits_RH_overlap[i,11] <- fish$estimate[[1]]
petal_numTKOHits_RH_overlap[i,12] <- fish$conf.int[[1]]
petal_numTKOHits_RH_overlap[i,13] <- fish$conf.int[[2]]
petal_numTKOHits_RH_overlap[i,14] <- fish$p.value

}

petal_numTKOHits_RH_overlap$q_fish <- p.adjust(petal_numTKOHits_RH_overlap$P_fish, method = "BH")

# Because few points, difficult to find exact P == q < 0.05, so simply plot q and use q == 0.05 as threshold
h_line_6 <- 0.05



# barplot
p6 <-	ggplot() + 
		theme2 + 
		theme(legend.key=element_blank()) +
		geom_bar(
			data = petal_numTKOHits_RH_overlap, 
			aes(
					x = numTKOHits_thres, 
					y = -log10(q_fish)
					),
			stat="identity",
			width=0.7, 
			fill = "grey80",
			colour="black",
			lwd=0.1
				) +
		geom_hline(
			color = "red", 
			size=size_hline,
			aes(
				yintercept = -log10(h_line_6), 
				linetype = "a"
				)
			) +
		scale_linetype_manual(
			name = NULL, 
			labels = c(expression(FDR==0.05)),
			values = c("solid"),  
			guide = guide_legend(
						override.aes = list(
											color = c("red"),
											size=size_hline
											)
							)
			) +
		theme(
		 	legend.position = c(0.8,0.9), 
			legend.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.box.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	legend.key.height = unit(0.3, "cm"),
			legend.key.width = unit(0.4, "cm"),
		 	legend.spacing.y = unit(0.3, 'cm'),
		 	legend.spacing.x = unit(0.2, 'cm'),
		 	legend.title = element_text(size = 11),  
		 	legend.text = element_text(size = 10),
	 		legend.title.align=0.7,
	 		legend.text.align=0
 			) +
		labs(subtitle="Hits") +
		xlab("Number") + 
		scale_x_continuous(breaks = c(0:5), labels = c(0:5)) + 
		ylab(expression(-log[10](FDR))) 
print(p6)





# #-------------hct116_shRNA_fisher_ovlap_graph (7)------------

# petal <- read.table("petal.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
# petal <- petal[,c("Gene","BF_hct116_shRNA")]
# g_unique <- read.delim("growth_loci_unique.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
# petal$RH <- numeric(nrow(petal))
# petal[petal$Gene %in% g_unique$geneSymbol,"RH"] <- 1



# petal_hct116_shRNA_RH_overlap <- data.frame(
# BF_hct116_shRNA_thres = numeric(), 	#col 1
# ptl_rh=numeric(), 				#col 2
# noptl_rh=numeric(), 			#col 3
# ptl_norh=numeric(), 			#col 4
# noptl_norh=numeric(), 			#col 5
# obs=numeric(), 					#col 6
# exp=numeric(), 					#col 7
# chi_sq=numeric(),				#col 8
# chi_df=numeric(),				#col 9
# P_chi=numeric(),				#col 10
# fish_OR=numeric(),				#col 11
# fish_conf_1=numeric(),			#col 12
# fish_conf_2=numeric(),			#col 13
# P_fish=numeric()				#col 14
# )


# BF_hct116_shRNA_max <- petal[which.max(petal$BF_hct116_shRNA),]$BF_hct116_shRNA
# BF_hct116_shRNA_min <- petal[which.min(petal$BF_hct116_shRNA),]$BF_hct116_shRNA


# vec <- seq(BF_hct116_shRNA_min, BF_hct116_shRNA_max,(BF_hct116_shRNA_max-BF_hct116_shRNA_min)/100)


# for(i in 1:101) {

# petal_hct116_shRNA_RH_overlap[i,1] <- vec[i]
# petal_hct116_shRNA_RH_overlap[i,2] <- dim(petal[petal$BF_hct116_shRNA > vec[i] & !is.na(petal$BF_hct116_shRNA) & petal$RH == 1,])[1]
# petal_hct116_shRNA_RH_overlap[i,3] <- dim(petal[petal$BF_hct116_shRNA < vec[i] & !is.na(petal$BF_hct116_shRNA) & petal$RH == 1,])[1]
# petal_hct116_shRNA_RH_overlap[i,4] <- dim(petal[petal$BF_hct116_shRNA > vec[i] & !is.na(petal$BF_hct116_shRNA) & petal$RH == 0,])[1]
# petal_hct116_shRNA_RH_overlap[i,5] <- dim(petal[petal$BF_hct116_shRNA < vec[i] & !is.na(petal$BF_hct116_shRNA) & petal$RH == 0,])[1]

# chi <- chisq.test(matrix(c(petal_hct116_shRNA_RH_overlap[i,2],petal_hct116_shRNA_RH_overlap[i,3],petal_hct116_shRNA_RH_overlap[i,4], petal_hct116_shRNA_RH_overlap[i,5]),2,2,byrow=TRUE))
# fish <- fisher.test(matrix(c(petal_hct116_shRNA_RH_overlap[i,2],petal_hct116_shRNA_RH_overlap[i,3],petal_hct116_shRNA_RH_overlap[i,4], petal_hct116_shRNA_RH_overlap[i,5]),2,2,byrow=TRUE))

# petal_hct116_shRNA_RH_overlap[i,6] <- chi$observed[1,1]
# petal_hct116_shRNA_RH_overlap[i,7] <- chi$expected[1,1]
# petal_hct116_shRNA_RH_overlap[i,8] <- chi$statistic
# petal_hct116_shRNA_RH_overlap[i,9] <- chi$parameter[[1]]
# petal_hct116_shRNA_RH_overlap[i,10] <- chi$p.value
# petal_hct116_shRNA_RH_overlap[i,11] <- fish$estimate[[1]]
# petal_hct116_shRNA_RH_overlap[i,12] <- fish$conf.int[[1]]
# petal_hct116_shRNA_RH_overlap[i,13] <- fish$conf.int[[2]]
# petal_hct116_shRNA_RH_overlap[i,14] <- fish$p.value

# }

# petal_hct116_shRNA_RH_overlap$q_fish <- p.adjust(petal_hct116_shRNA_RH_overlap$P_fish, method = "BH")

# # no q_fish < 0.05
# h_line_7 <- max(petal_hct116_shRNA_RH_overlap[petal_hct116_shRNA_RH_overlap$q_fish < 0.05,]$P_fish)

# p7 <- ggplot() + 
		# theme2 + 
		# theme(legend.key=element_blank()) +
		# geom_line(
			# data= petal_hct116_shRNA_RH_overlap, 
			# lwd=0.2,
			# colour="black",
			# show.legend=FALSE,
			# aes(
				# x= BF_hct116_shRNA_thres, 
				# y= -log10(P_fish)
				# )
			# ) +
		# geom_hline(
			# color = "red", 
			# size=size_hline,
			# aes(
				# yintercept = -log10(h_line_7), 
				# linetype = "FDR = 0.05"
				# )
			# ) +
		# scale_linetype_manual(
			# name = NULL, 
			# values = c(1), 
			# guide = guide_legend(
						# override.aes = list(
											# color = c("red"),
											# size=size_hline
											# )
							# )
			# ) +
		# theme(
	 		# legend.position = c(0.7,0.9), 
			# legend.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	# legend.box.margin=margin(t=0,r=0,b=0,l=0,unit = "pt"),
		 	# legend.key.height = unit(0.6, "cm"),
			# legend.key.width = unit(0.2, "cm"),
		 	# legend.spacing.y = unit(0.6, 'cm'),
		 	# legend.spacing.x = unit(0.2, 'cm'),
		 	# legend.title = element_text(size = 11),  
		 	# legend.text = element_text(size = 10),
	 		# legend.title.align=0.7
 			# ) +
		# labs(subtitle="HCT116 shRNA") +
		# xlab("BF") + 
		# # scale_x_continuous(breaks = c(0,1,2,3,4,6), labels = c(0,1,2,3,4,6)) + 
		# ylab(expression(-log[10]*italic('P'))) 
# print(p7)



#------------------Make file --------------------------


(petal_ovlap_fish_2 <- plot_grid(p1, p2, p3, p4, p5, p6, labels=LETTERS[1:6], ncol = 2, nrow = 3, label_size = 16))


pdf("petal_ovlap_fish_2.pdf",width=7.5,height=7.5,useDingbats=FALSE)
petal_ovlap_fish_2
dev.off()





