# These plots can be saved as pdfs and imported into cowplot using magick.
# Before used sweave and latex, but magick is a better solution. 

# ------- Run in R if latex solution desired-------------------------

# Use sweave and latex. Code below transferred to g_d_comb_overlap_fig_1.Rnw. Then following commands in R. 
# Note important to have Sweave.sty in same folder. 
# Sweave gave better results than generating each pdf separately in R and then directly combining in latex using subfigure.
# Tried tikz, but did not work with chart.Correlation for some reason, though did work with corrplot

# Sys.setenv(PATH=paste(Sys.getenv("PATH"),"/Library/TeX/texbin",sep=":"))
# Sweave("g_d_comb_overlap_fig_1.Rnw")
# tools::texi2pdf("g_d_comb_overlap_fig_1.tex")

# # # equivalent:
# # tools::texi2dvi("g_d_comb_overlap_fig_1.tex",pdf=TRUE)

# # or in unix terminal:
# # pdflatex g_d_comb_overlap_fig_1.tex


# ------------------ Code chunks for g_d_overlap_1.Rnw follow if latex desired ----------------------
# Otherwise use directly in R

library(corrplot)
library(PerformanceAnalytics)
library(ggplot2)
library(magick)
library(cowplot)
library(RColorBrewer)


# slightly modify PerformanceAnalytics::chart.Correlation for more pleasing results

chart.Corr <- function (R, histogram = TRUE, method = c("pearson", "kendall", "spearman"), ticksize=0.1, tickthick=0.1,  ...) 
{
    x = checkData(R, method = "matrix")
    if (missing(method)) 
        method = method[1]
    panel.cor <- function(x, y, digits = 2, prefix = "", use = "pairwise.complete.obs", 
        method = "pearson", cex.cor, ...) {
        usr <- par("usr")
        on.exit(par(usr))
        par(usr = c(0, 1, 0, 1))
        r <- cor(x, y, use = use, method = method)
        txt <- format(c(r, 0.123456789), digits = digits)[1]
        txt <- paste(prefix, txt, sep = "")
        if (missing(cex.cor)) 
            cex <- 0.8/strwidth(txt)
        test <- cor.test(as.numeric(x), as.numeric(y), method = method)
        Signif <- symnum(test$p.value, corr = FALSE, na = FALSE, 
            cutpoints = c(0, 0.001, 0.01, 0.05, 0.1, 1), symbols = c("***", 
                "**", "*", ".", " "))
        text(0.5, 0.5, txt, cex = cex * (abs(r) + 0.3)/1.3)
        text(0.7, 0.8, Signif, cex = cex, col = 2)
    }
    f <- function(t) {
        dnorm(t, mean = mean(x), sd = sd.xts(x))
    }
    dotargs <- list(...)
    dotargs$method <- NULL
    rm(method)
    hist.panel = function(x, ... = NULL) {
        par(new = TRUE)
        hist(x, col = "light gray", probability = TRUE, axes = FALSE, 
            main = "", breaks = "FD")
        lines(density(x, na.rm = TRUE), col = "red", lwd = 1)
        rug(x, ticksize=ticksize,lwd=tickthick)
    }
    if (histogram) 
        pairs(x, gap = 0, lower.panel = panel.smooth, upper.panel = panel.cor,
            diag.panel = hist.panel)
    else pairs(x, gap = 0, lower.panel = panel.smooth, upper.panel = panel.cor)
}




logP <-  read.table("log10P_human.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE)
colnames(logP)[c(5:16)] <- c("0 nM","8 nM","25 nM","75 nM","g avg", "wk 1", "wk 2", "wk 3", "wk 4", "wk 6","d avg", "Ix")

g <- read.delim("growth_loci.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
d <- read.delim("paclitaxel_loci.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)
Ix <- read.delim("Ix_loci.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE,check.names=FALSE)



#Unfortunately layout does not workwith chart.Correlation, so print each panel pdf separately and put together with magick.
# pdf(file='g_d_overlap_1.pdf', width = 7.5,  height = 6.67)

# layout(
# matrix(c(rep(1,50), rep(2,50), 
		# rep(3,50), rep(4,50)
# ), 
# 2, 100, byrow = TRUE))

#--------------------- g_d_comb_dataframe -----------------



g_bind <- g
d_bind <- d
Ix_bind <- Ix

g_bind[g_bind$conc == 0,]$conc <- "g_0nM"
g_bind[g_bind$conc == 8,]$conc <- "g_8nM"
g_bind[g_bind$conc == 25,]$conc <- "g_25nM"
g_bind[g_bind$conc == 75,]$conc <- "g_75nM"
g_bind[g_bind$conc == "avg",]$conc <- "g_avg"


d_bind[d_bind$wk == 2,]$wk <- "d_w2"
d_bind[d_bind$wk == 3,]$wk <- "d_w3"
d_bind[d_bind$wk == 4,]$wk <- "d_w4"
d_bind[d_bind$wk == 6,]$wk <- "d_w6"
d_bind[d_bind$wk == "avg",]$wk <- "d_avg"


# not necessary, makes no change. Included for clarity.
Ix[Ix$wk_conc == "Ix",]$wk_conc <- "Ix"



colnames(g_bind)[5] <- "conc_wk"
colnames(d_bind)[5] <- "conc_wk"
colnames(Ix_bind)[5] <- "conc_wk"

g_and_d <- rbind(g_bind,d_bind)
g_and_d <- rbind(g_and_d,Ix_bind)


#--------------------- (1) g_and_d_P_vals_cor -----------------

# includes Ix

pdf(file='g_and_d_overlap_1A.pdf', width = 10,  height = 10, useDingbats = FALSE)
chart.Corr(
		logP[seq(1,nrow(logP),by=100),c(5:16)],
                 method="pearson",
                 histogram=TRUE,
                 ticksize=0.05,
                 tickthick=0.01,
                 par(
                 	lwd=0.4, 
                 	pch="."
					)
			)

# mtext("A",side=3,line=2.5, 
             # # at=par("usr")[1]-.45*diff(par("usr")[1:2]),
             # # cex=1.2,font=2)
dev.off()


#--------------------- (2) g_and_d_loci_overlap -----------------

# no d loci w1, but includes Ix

g_and_d_overlap_frac <- data.frame("g 0nM"=numeric(), "g 8nM"=numeric(), "g 25nM"=numeric(), "g 75nM"=numeric(), "g avg"=numeric(), "d w2"=numeric(), "d w3"=numeric(), "d w4"=numeric(), "d w6"=numeric(), "d avg"=numeric(), "Ix"=numeric(), check.names=FALSE)

k <- as.character(c("g_0nM","g_8nM","g_25nM","g_75nM","g_avg", "d_w2", "d_w3","d_w4","d_w6","d_avg","Ix"))

for(i in 1:11) 
{
	for(j in 1:11) 
	{
		g_and_d_overlap_frac[i,j] <- dim(g_and_d[g_and_d$conc_wk==k[i],][with(g_and_d[g_and_d$conc_wk==k[i],], paste(Chromosome, ensembl_gene_id, sep = "\r")) %in% with(g_and_d[g_and_d$conc_wk==k[j],], paste(Chromosome, ensembl_gene_id, sep="\r")), ])[1]
	}
}

row.names(g_and_d_overlap_frac) <- c(colnames(g_and_d_overlap_frac))

g_and_d_overlap_dec <- g_and_d_overlap_frac
for(i in 1:11) {
	g_and_d_overlap_dec[i,] <- g_and_d_overlap_dec[i,]/g_and_d_overlap_dec[i,i]
}

# write.table(g_and_d_overlap_frac,"g_and_d_overlap_frac.txt",sep="\t",row.names=TRUE)
# write.table(g_and_d_overlap_dec,"g_and_d_overlap_dec.txt",sep="\t",row.names= TRUE)


pal <- colorRampPalette(brewer.pal(3, "Blues"))


pdf(file='g_and_d_overlap_1B.pdf', width = 10,  height = 10)
#Using corrplot to give heatmap, hence one color and use of cl.lim = c(0,1):


corrplot(as.matrix(g_and_d_overlap_dec),is.corr=FALSE,method="pie", addCoefasPercent=FALSE, col=pal(200), tl.col="black", addCoef.col ="black", cl.pos="r",cl.lim=c(0,1),cl.length=3,cl.ratio=0.25, cl.align.text="l", tl.cex=1.5, cl.cex=1.5, number.cex=1.25, oma = c(0,0,0,0), mar=c(0,0,0,1))


dev.off()


# --------------- Combine plots -----------------------------


p1 <- ggdraw() + draw_image(magick::image_read_pdf("g_and_d_overlap_1A.pdf", density = 300),scale=0.9) + draw_label("A", fontface='bold', size = 16, x=0.12, y=0.95)
p2 <- ggdraw() + draw_image(magick::image_read_pdf("g_and_d_overlap_1B.pdf", density = 300),scale=1.0) + draw_label("B", fontface='bold', size = 16, x=0.12,y=0.9)

pdf("g_d_comb_overlap_1.pdf", width=7.5, height=10, useDingbats = FALSE)
plot_grid(p1, p2, ncol = 1, nrow = 2)
dev.off()






# p1 <- ggdraw() + draw_image(magick::image_read_pdf("g_and_d_overlap_1A.pdf", density = 300),scale=1.0) #+ draw_label("A", fontface='bold',x=0.05,y=0.9)
# p2 <- ggdraw() + draw_image(magick::image_read_pdf("g_and_d_overlap_1B.pdf", density = 300),scale=1.0) #+ draw_label("B", fontface='bold',x=0.05,y=0.9)

# pdf("g_d_comb_overlap_1.pdf", width=7.5, height=10, useDingbats = FALSE)
# plot_grid(p1, p2, labels=c("A", "B"), ncol = 1, nrow = 2, label_size = 14)
# dev.off()



# ------------ hi res ---------------


p1 <- ggdraw() + draw_image(magick::image_read_pdf("g_and_d_overlap_1A.pdf", density = 1200),scale=0.9) + draw_label("A", fontface='bold', size = 16, x=0.12, y=0.95)
p2 <- ggdraw() + draw_image(magick::image_read_pdf("g_and_d_overlap_1B.pdf", density = 1200),scale=1.0) + draw_label("B", fontface='bold', size = 16, x=0.12,y=0.9)

pdf("g_d_comb_overlap_hi_res_1.pdf", width=7.5, height=10, useDingbats = FALSE)
plot_grid(p1, p2, ncol = 1, nrow = 2)
dev.off()




























