## Align hamster cnvs and qtls


#install.packages("ggplot2")
library(ggplot2)
library(cowplot) #used with plot_grid 
library(gridExtra)

# --------------- color -------------------------------

gg_color_hue <- function(n) {
  hues = seq(15, 375, length = n + 1)
  hcl(h = hues, l = 65, c = 100)[1:n]
}



n = 2
colores_1 = gg_color_hue(n)
names(colores_1) <- c("copy_num","logP")




#----------------Aesthetics ---------------------------


theme2 <- theme(
	plot.margin = unit(c(t=1.2,r=0.4,b=1.2,l=0.4), "cm"),
	panel.grid.major = element_blank(), 
	panel.grid.minor = element_blank(), 
	panel.background = element_blank(), 
	legend.position="none", 
	axis.line.x = element_line(colour = "black", size = 0.1), 
	axis.line.y = element_line(colour = "black", size = 0.1), 
	axis.ticks = element_line(colour = "black", size = 0.1),
	axis.text=element_text(size=12), #numbers on tick marks of x and y axes
	axis.title=element_text(size=14), #titles of x and y axes
	axis.title.y=element_text(margin=margin(0,13,0,0)), #moves y axis title by adding margin space to bottom
	axis.title.x=element_text(margin=margin(10,0,0,0)),  #moves x axis title by adding margin space to top
	plot.title = element_text(size=32, face="bold", hjust = -0.14), #can provide "A","B", by ggtitle, but used plot_grid wch can shift more left
	plot.subtitle = element_text(size=14, face="plain", hjust = 0.5) #hjust shifts right
	)




# darkest two hues from 3-class PuBuGn in color brewer
# cb1<-rep(c("#1c9099", "#a6bddb"), 12)

# # darkest two hues from 3-class PuBu in color brewer
# cb1<-rep(c("#2b8cbe", "#a6bddb"), 12)


# #attractive pinks, greys
# cb1<-c("#999999", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7","#999999", "#E69F00", "#56B4E9", "#E69F00", "#009E73", "#F0E442", "#0072B2", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7","#999999", "#D55E00", "#CC79A7")

# cb1_rev <- c("#CC79A7", "#D55E00", "#0072B2", "#F0E442", "#009E73", "#56B4E9", "#E69F00","#999999", "#CC79A7", "#D55E00", "#0072B2", "#D55E00", "#F0E442", "#009E73", "#56B4E9", "#0072B2", "#F0E442", "#009E73", "#56B4E9", "#E69F00","#999999", "#CC79A7", "#E69F00","#999999")

# #'4-class RdBu'
# cb2 <- c('#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#f4a582','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#92c5de','#0571b0')

# #'4-class RdYlBu'
# cb3 <- c('#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#fdae61','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#abd9e9','#2c7bb6')
	
	
size_point <- 0.3
size_hline <- 0.1

# If desired, modify balloon code. Probably not a good idea in this context, though.
# balloon_scale <- 0.8 # inflation factor for significant points	
# # scale significant points beginning wiht 0.8 pt
# size_point <- 0.8*(1 + balloon_scale*(bleed$A23_T_HUM_ratio_norm/max(bleed$A23_T_HUM_ratio_norm, na.rm=TRUE)))





#----------------- prepare HAMSTER retain mean RH pools ---------------------


RH_hamster <- read.table("RH_hamster_gseq.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)

# Get rows at beginning of each chromosome:
RH_hamster_start <- RH_hamster[RH_hamster$posS == 0 & RH_hamster$posE == 1e6,]

# Get rid of ramp ups and ramp downs (though note that hamster has ramp downs, not ramp ups):
RH_hamster <- RH_hamster[c(0,diff(RH_hamster$pos)) == 1e4,]

# combine RH_hamster without ramps and RH_hamster_start:
RH_hamster <- rbind(RH_hamster_start,RH_hamster)


# # get rid of contigs with only one entry. Has no action, since RH_hamster_gseq.txt already has smallest 5% of contigs removed. cf Create_RH_hamster_gseq.R
# RH_hamster <- RH_hamster[!(RH_hamster$Contig_ID %in% aggregate(pos ~ Contig_ID, 
          # data = RH_hamster, 
          # FUN = function(x){NROW(x)})[aggregate(pos ~ Contig_ID, 
          # data = RH_hamster, 
          # FUN = function(x){NROW(x)})$pos==1,"Contig_ID"]),]

# Sort:
chrOrder<-paste("chr",c(1:10,"X"),sep="")
RH_hamster$Chromosome <-factor(RH_hamster$Chromosome, levels=chrOrder)
RH_hamster <- RH_hamster[order(RH_hamster$Chromosome, RH_hamster$pos), ]
RH_hamster$Chromosome <- as.character(RH_hamster$Chromosome)


# Transform reads into mean ratios for RH pools only
RH_hamster$read_ratio <- rowMeans(apply(RH_hamster[,c(grep("_w0_d0$",colnames(RH_hamster)))],2,FUN=function(x) {x/mean(x)}))


dim(RH_hamster)
# [1] 204259    121

#----------------- Prepare logP_hamster ---------------------


logP_hamster <- read.table("log10P_hamster.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
hamster_thresh_95 <- read.table("hamster_thresh_95.txt",header=FALSE,sep="\t",stringsAsFactors=FALSE,row.names=1,col.names=c("","thresh"))



# discard logP_hamster rows that correspond to ramp up and ramp downs in logP_hamster, so that exact correspondence between two dataframes.

# Get rows at beginning of each chromosome:
logP_hamster_start <- logP_hamster[logP_hamster$posS == 0 & logP_hamster$posE == 1e6,]

# Get rid of ramp ups and ramp downs (though note that hamster has ramp downs, not ramp ups):
logP_hamster <- logP_hamster[c(0,diff(logP_hamster$pos)) == 1e4,]

# combine logP_hamster without ramps and logP_hamster_start:
logP_hamster <- rbind(logP_hamster_start,logP_hamster)


# # get rid of contigs with only one entry. Has no action, since logP_hamster.txt already has smallest 5% of contigs removed. cf Create_RH_hamster_gseq.R
# logP_hamster <- logP_hamster[!(logP_hamster$Contig_ID %in% aggregate(pos ~ Contig_ID, 
          # data = logP_hamster, 
          # FUN = function(x){NROW(x)})[aggregate(pos ~ Contig_ID, 
          # data = logP_hamster, 
          # FUN = function(x){NROW(x)})$pos==1,"Contig_ID"]),]

# Sort:
chrOrder<-paste("chr",c(1:10,"X"),sep="")
logP_hamster$Chromosome <-factor(logP_hamster$Chromosome, levels=chrOrder)
logP_hamster <- logP_hamster[order(logP_hamster$Chromosome, logP_hamster$pos), ]
logP_hamster$Chromosome <- as.character(logP_hamster$Chromosome)


dim(logP_hamster)
# [1] 204259     29


# standard black color scheme
cb1<-rep(c("black", "black"), 6)


labels <- as.character(c(1:8,"","","X"))

# ---------- colors and labels for ggplot ---------------------


# # attractive grey and skyblue color scheme
# cb1<-c(rep(c("grey", "skyblue"), 5),"grey")

# standard black color scheme
cb1<-rep(c("black", "black"), 6)


labels <- as.character(c(1:8,"","","X"))


# ------------------------- Margins for logP and copy num plots -----------------------------------------

logP_margin = unit(c(t=1,r=1,b=0.25,l=1), "cm")
copy_num_margin = unit(c(t=0.25,r=1,b=1,l=1), "cm")



# -------------------------- (1) Growth loci, 0 nM paclitaxel, chromosome 1 -------------------------------


# choose chr number
i <- 1



balloon_scale <- 1.0 # inflation factor for significant points	
size_point_1 <- 0.2*(1 + balloon_scale*(logP_hamster[logP_hamster$Chromosome==paste0("chr",i),"log10p_g_0nM"]/max(logP_hamster[logP_hamster$Chromosome==paste0("chr",i),"log10p_g_0nM"]))) # scale significant points



p1a <- ggplot() + 
		geom_point(
			data = logP_hamster[logP_hamster$Chromosome==paste0("chr",i),],
			size= size_point_1,
			colour = colores_1["logP"],
			stroke=0,
				aes(
					x = pos/1e6, 
					y = log10p_g_0nM
					)
				) +
		# scale_color_manual(values=cb1) +
		theme2 +
		theme(
				plot.margin = logP_margin,
				axis.line.x=element_blank(),
				axis.title.x=element_blank(),
		        axis.text.x=element_blank(),
		        axis.ticks.x=element_blank()
	        ) +
        # scale_x_continuous(breaks = breaks, labels = labels) +
		scale_x_continuous(limits=c(320,358), expand = expand_scale(mult = 0.02)) + # forced to use limits rather than coord_cartesian, because also want to use expand
		# xlab(paste0("Chromosome ", i, " (Mb)")) + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_g_0nM",], linetype="solid", color = "grey", size=size_hline) +
		labs(subtitle="Growth (0 nM)") +
		scale_y_continuous(breaks=c(0,4,8,12),labels=c(0,4,8,12)) #+
		# coord_cartesian(xlim=c(320,358))
print(p1a)




p1b <- ggplot() + 
			geom_point(
				data = RH_hamster[RH_hamster$Chromosome==paste0("chr",i),], 
				colour = colores_1["copy_num"],
				aes(
					x = pos/1e6, 
					y = read_ratio
				),
				size= 0.3,
				stroke=0
				) +
			scale_color_manual(values=cb1) +
			theme2 +
			theme(
				plot.margin = copy_num_margin,
				axis.title.y=element_text(margin=margin(0,23,0,0)) #moves y axis title by adding margin space to bottom
				) + 
			# scale_x_continuous(breaks = breaks, labels = labels) +
			scale_x_continuous(limits=c(320,358), expand = expand_scale(mult = 0.02)) + # forced to use limits rather than coord_cartesian, because also want to use expand
			xlab(paste0("Chromosome ", i, " (Mb)")) + 
			ylab("Copy") + 
			# labs(subtitle="Hamster genome in RH pools") +
			scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2)) #+
			# coord_cartesian(xlim=c(320,358))
print(p1b)




p1 <- grid.arrange(p1a, p1b, ncol = 1, heights = c(1.5, 1))




# -------------------------- (2) Growth loci, 8 nM paclitaxel, chromosome 3 -------------------------------


j <- 3


balloon_scale <- 1.0 # inflation factor for significant points	
size_point_2 <- 0.2*(1 + balloon_scale*(logP_hamster[logP_hamster$Chromosome==paste0("chr",j),"log10p_g_8nM"]/max(logP_hamster[logP_hamster$Chromosome==paste0("chr",j),"log10p_g_8nM"]))) # scale significant points




p2a <-  ggplot() + 
		geom_point(
			data = logP_hamster[logP_hamster$Chromosome==paste0("chr",j),],
			size= size_point_2,
			stroke=0,
			colour = colores_1["logP"],
				aes(
					x = pos/1e6, 
					y = log10p_g_8nM
					)
				) +
		# scale_color_manual(values=cb1) +
		theme2 +
		theme(
				plot.margin = logP_margin,
				axis.line.x=element_blank(),
				axis.title.x=element_blank(),
		        axis.text.x=element_blank(),
		        axis.ticks.x=element_blank()
	        ) +
        # scale_x_continuous(breaks = breaks, labels = labels) +
		scale_x_continuous(limits=c(120,180), expand = expand_scale(mult = 0.02)) + # forced to use limits rather than coord_cartesian, because also want to use expand
		# xlab(paste0("Chromosome ", j, " (Mb)")) + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_g_8nM",], linetype="solid", color = "grey", size=size_hline) +
		labs(subtitle="Growth (8 nM)") +
		scale_y_continuous(breaks=c(0,5,10,15),labels=c(0,5,10,15)) #+
		# coord_cartesian(xlim=c(120,180))
print(p2a)


i <- 3


p2b <- ggplot() + 
			geom_point(
				data = RH_hamster[RH_hamster$Chromosome==paste0("chr",j),], 
				colour = colores_1["copy_num"],
				aes(
					x = pos/1e6, 
					y = read_ratio
				),
				size= 0.3,
				stroke=0
				) +
			# scale_color_manual(values=cb1) +
			theme2 +
			theme(
				plot.margin = copy_num_margin,
				axis.title.y=element_text(margin=margin(0,23,0,0)) #moves y axis title by adding margin space to bottom
				) + 
			# scale_x_continuous(breaks = breaks, labels = labels) +
			scale_x_continuous(limits=c(120,180), expand = expand_scale(mult = 0.02)) + # forced to use limits rather than coord_cartesian, because also want to use expand
			xlab(paste0("Chromosome ", j, " (Mb)")) + 
			ylab("Copy") + 
			# labs(subtitle="Hamster genome in RH pools") +
			scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2)) #+
			# coord_cartesian(xlim=c(120,180))
print(p2b)

p2 <- grid.arrange(p2a, p2b, ncol = 1, heights = c(1.5, 1))




# ----------------- (3) Hamster paclitaxel logP (6 wks) chromosome 1 ---------------------

# choose chr number

k <- 1


balloon_scale <- 1.0 # inflation factor for significant points	
size_point_3 <- 0.2*(1 + balloon_scale*(logP_hamster[logP_hamster$Chromosome==paste0("chr",k),"log10p_d_w6"]/max(logP_hamster[logP_hamster$Chromosome==paste0("chr",k),"log10p_d_w6"]))) # scale significant points




p3a <- ggplot() + 
		geom_point(
			data = logP_hamster[logP_hamster$Chromosome==paste0("chr",k),],
			size= size_point_3,
			stroke=0,
			colour = colores_1["logP"],
				aes(
					x = pos/1e6, 
					y = log10p_d_w6
					)
				) +
		# scale_color_manual(values=cb1) +
		theme2 +
		theme(
				plot.margin = logP_margin,
				axis.line.x=element_blank(),
				axis.title.x=element_blank(),
		       axis.text.x=element_blank(),
		       axis.ticks.x=element_blank()
	        ) +
        # scale_x_continuous(breaks = breaks, labels = labels) +
		scale_x_continuous(limits=c(260,285), expand = expand_scale(mult = 0.02)) + # forced to use limits rather than coord_cartesian, because also want to use expand
		# xlab(paste0("Chromosome ", k, " (Mb)")) + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_d_w6",], linetype="solid", color = "grey", size=size_hline) +
		labs(subtitle="Paclitaxel (6 wks)") +
		scale_y_continuous(breaks=c(0,5,10,15,20,25),labels=c(0,5,10,15,20,25)) #+
		# coord_cartesian(xlim=c(260,285))
print(p3a)




	
p3b <- ggplot() + 
			geom_point(
				data = RH_hamster[RH_hamster$Chromosome==paste0("chr",k),], 
				colour = colores_1["copy_num"],
				aes(
					x = pos/1e6, 
					y = read_ratio, 
					color=as.factor(Chromosome)),
					size= 0.3,
					stroke=0
				) +
			# scale_color_manual(values=cb1) +
			theme2 +
			theme(
				plot.margin = copy_num_margin,
				axis.title.y=element_text(margin=margin(0,23,0,0)) #moves y axis title by adding margin space to bottom
			) + 
			# scale_x_continuous(breaks = breaks, labels = labels) +
			scale_x_continuous(limits=c(260,285), expand = expand_scale(mult = 0.02)) + # forced to use limits rather than coord_cartesian, because also want to use expand
			xlab(paste0("Chromosome ", k, " (Mb)")) + 
			ylab("Copy") + 
			# labs(subtitle="Hamster genome in RH pools") +
			scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2)) #+
			# coord_cartesian(xlim=c(260,285))
print(p3b)


p3 <- grid.arrange(p3a, p3b, ncol = 1, heights = c(1.5, 1))
	
	
			



# ----------------- (4) Hamster paclitaxel logP (4 wks) chromosome X ---------------------


		
# choose chr number
			
l <- "X"



balloon_scale <- 1.0 # inflation factor for significant points	
size_point_4 <- 0.2*(1 + balloon_scale*(logP_hamster[logP_hamster$Chromosome==paste0("chr",l),"log10p_d_w4"]/max(logP_hamster[logP_hamster$Chromosome==paste0("chr",l),"log10p_d_w4"]))) # scale significant points



p4a <- ggplot() + 
		geom_point(
			data = logP_hamster[logP_hamster$Chromosome==paste0("chr",l),],
			size= size_point_4,
			stroke=0,
			colour = colores_1["logP"],
				aes(
					x = pos/1e6, 
					y = log10p_d_w4
					)
				) +
		# scale_color_manual(values=cb1) +
		theme2 +
		theme(
				plot.margin = logP_margin,
				axis.line.x=element_blank(),
				axis.title.x=element_blank(),
		        axis.text.x=element_blank(),
		        axis.ticks.x=element_blank()
	        ) +
        # scale_x_continuous(breaks = breaks, labels = labels) +
		scale_x_continuous(limits=c(60, 106068507/1e6), expand = expand_scale(mult = 0.02)) + # forced to use limits rather than coord_cartesian, because also want to use expand
		# xlab(paste0("Chromosome ", l, " (Mb)")) + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_d_w4",], linetype="solid", color = "grey", size=size_hline) +
		labs(subtitle="Paclitaxel (4 wks)") #+
		# scale_y_continuous(breaks=c(0,5,10,15),labels=c(0,5,10,15)) #+
		# coord_cartesian(xlim=c(60, 106068507/1e6))
print(p4a)



p4b <- ggplot() + 
			geom_point(
				data = RH_hamster[RH_hamster$Chromosome==paste0("chr",l),], 
				colour = colores_1["copy_num"],
				aes(
					x = pos/1e6, 
					y = read_ratio, 
					color=as.factor(Chromosome)),
					size= 0.3,
					stroke=0
				) +
			# scale_color_manual(values=cb1) +
			theme2 +
			theme(
				plot.margin = copy_num_margin,
				axis.title.y=element_text(margin=margin(0,23,0,0)) #moves y axis title by adding margin space to bottom
				) +
			# scale_x_continuous(breaks = breaks, labels = labels) +
			scale_x_continuous(limits=c(60, 106068507/1e6), expand = expand_scale(mult = 0.02)) + # forced to use limits rather than coord_cartesian, because also want to use expand
			xlab(paste0("Chromosome ", l, " (Mb)")) + 
			ylab("Copy") + 
			# labs(subtitle="Hamster genome in RH pools") +
			scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2)) #+
			# coord_cartesian(xlim=c(60, 106068507/1e6))
print(p4b)


p4 <- grid.arrange(p4a, p4b, ncol = 1, heights = c(1.5, 1))



# --------------- Combine panels ---------------------


# File size ~ 1.4 Mb
pdf("Hamster_qtls_cnvs_1.pdf", width=7.5, height=7.5, useDingbats = FALSE)
plot_grid(p1, p2, p3, p4, ncol = 2, nrow = 2, labels=c("A", "B", "C", "D"), label_size = 16, align="h")
dev.off()



tiff("Hamster_qtls_cnvs_1.tif", width=7.5, height=7.5,units="in",res=300)
plot_grid(p1, p2, p3, p4, ncol = 2, nrow = 2, labels=c("A", "B", "C", "D"), label_size = 16, align="h")
dev.off()



# if smaller file size required:
# File size ~0.4 Mb
png("Hamster_qtls_cnvs_1.png",width=7.5,height=7.5,units="in",res=300)
plot_grid(p1, p2, p3, p4, ncol = 2, nrow = 2, labels=c("A", "B", "C", "D"), label_size = 16, align="h")
dev.off()




png("Hamster_qtls_cnvs_hi_res_1.png",width=7.5,height=7.5,units="in",res=1200)
plot_grid(p1, p2, p3, p4, ncol = 2, nrow = 2, labels=c("A", "B", "C", "D"), label_size = 16, align="h")
dev.off()















































































