# Manhattan qtl plot of average conditional effects for growth and paclitaxel

#install.packages("ggplot2")
library(ggplot2)
library(cowplot) #used with plot_grid 

#----------------Aesthetics ---------------------------


theme2 <- theme(
	plot.margin = unit(c(t=1.2,r=0.4,b=1.2,l=0.4), "cm"),
	panel.grid.major = element_blank(), 
	panel.grid.minor = element_blank(), 
	panel.background = element_blank(), 
	legend.position="none", 
	axis.line.x = element_line(colour = "black", size = 0.1), 
	axis.line.y = element_line(colour = "black", size = 0.1), 
	axis.ticks = element_line(colour = "black", size = 0.1),
	axis.text=element_text(size=12), #numbers on tick marks of x and y axes
	axis.title=element_text(size=14), #titles of x and y axes
	axis.title.y=element_text(margin=margin(0,13,0,0)), #moves y axis title by adding margin space to bottom
	axis.title.x=element_text(margin=margin(10,0,0,0)),  #moves x axis title by adding margin space to top
	plot.title = element_text(size=32, face="bold", hjust = -0.14), #can provide "A","B", by ggtitle, but used plot_grid wch can shift more left
	plot.subtitle = element_text(size=14, face="plain", hjust = 0.5) #hjust shifts right
	)






# darkest two hues from 3-class PuBuGn in color brewer
# cb1<-rep(c("#1c9099", "#a6bddb"), 12)

# # darkest two hues from 3-class PuBu in color brewer
# cb1<-rep(c("#2b8cbe", "#a6bddb"), 12)


# #attractive pinks, greys
# cb1<-c("#999999", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7","#999999", "#E69F00", "#56B4E9", "#E69F00", "#009E73", "#F0E442", "#0072B2", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7","#999999", "#D55E00", "#CC79A7")

# cb1_rev <- c("#CC79A7", "#D55E00", "#0072B2", "#F0E442", "#009E73", "#56B4E9", "#E69F00","#999999", "#CC79A7", "#D55E00", "#0072B2", "#D55E00", "#F0E442", "#009E73", "#56B4E9", "#0072B2", "#F0E442", "#009E73", "#56B4E9", "#E69F00","#999999", "#CC79A7", "#E69F00","#999999")

# #'4-class RdBu'
# cb2 <- c('#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#f4a582','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#92c5de','#0571b0')

# #'4-class RdYlBu'
# cb3 <- c('#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#fdae61','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#abd9e9','#2c7bb6')
	
	
# size_point <- 0.3
# size_hline <- 0.1



#----------------- Prepare hamster logP_hamster ---------------------


logP_hamster <- read.table("log10P_hamster.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
hamster_thresh_95 <- read.table("hamster_thresh_95.txt",header=FALSE,sep="\t",stringsAsFactors=FALSE,row.names=1,col.names=c("","thresh"))



# Sort:
chrOrder<-paste("chr",c(1:10,"X"),sep="")
logP_hamster$Chromosome <- factor(logP_hamster$Chromosome, levels=chrOrder)
logP_hamster <- logP_hamster[order(logP_hamster$Chromosome, logP_hamster$pos), ]
logP_hamster$Chromosome <- as.character(logP_hamster$Chromosome)



# Transform chr1 etc. to numbers
logP_hamster$Chromosome <- gsub('chr', '', logP_hamster$Chromosome)
logP_hamster[logP_hamster$Chromosome == "X","Chromosome"] <- 11
chrOrder<-c(1:11)
logP_hamster$Chromosome <- factor(logP_hamster$Chromosome, levels=chrOrder)
logP_hamster <- logP_hamster[order(logP_hamster$Chromosome, logP_hamster$pos), ]
logP_hamster$Chromosome <- as.numeric(logP_hamster$Chromosome)

# Compute chromosome size
gen_coord <- aggregate(pos~Chromosome,FUN=max,data=logP_hamster)
colnames(gen_coord)[2] <- "chr_size"
gen_coord$Chromosome <-factor(gen_coord$Chromosome, levels=chrOrder)
gen_coord <- gen_coord[order(gen_coord$Chromosome), ]
gen_coord$Chromosome <- as.numeric(gen_coord$Chromosome)

# Use cumsum to make genome coordinates
gen_coord$coord <- c(0,cumsum(gen_coord$chr_size)[-11])

# merge genome coordinates with logP_hamster
logP_hamster <- merge(logP_hamster,gen_coord[,c("Chromosome","coord")])
logP_hamster$Chromosome <-factor(logP_hamster$Chromosome, levels=chrOrder)
logP_hamster <- logP_hamster[order(logP_hamster$Chromosome, logP_hamster$pos), ]
logP_hamster$Chromosome <- as.numeric(logP_hamster$Chromosome)

logP_hamster$coord <- logP_hamster$pos + logP_hamster$coord


# find midpoints of chromosomes for breaks in ggplot
mid <- function(x) {(max(x)+min(x))/2}
chr_mid <- aggregate(coord~Chromosome,FUN = mid,data=logP_hamster)
colnames(chr_mid)[2] <- "mid"
chr_mid$Chromosome <-factor(chr_mid$Chromosome, levels=chrOrder)
chr_mid <- chr_mid[order(chr_mid$Chromosome), ]
chr_mid$Chromosome <- as.numeric(chr_mid$Chromosome)

# Define breaks as mid-points chromosomes
breaks <- chr_mid$mid



# attractive grey and skyblue color scheme
cb1<-c(rep(c("grey", "skyblue"), 5),"grey")

labels <- as.character(c(1:8,"","","X"))



#----------------- hamster paclitaxel (wk 1) ---------------------


balloon_scale <- 5 # inflation factor for significant points	
size_point <- 0.1*(1 + balloon_scale*(logP_hamster$log10p_d_w1/max(logP_hamster$log10p_d_w1))) # scale significant points



p1 <- ggplot() + 
		geom_point(
			data = logP_hamster, 
			size= size_point,
			stroke=0, 
				aes(
					x = coord, 
					y = log10p_d_w1, 
					color=as.factor(Chromosome)
					)
				) +
		scale_color_manual(values=cb1) +
		theme2 +
		scale_x_continuous(breaks = breaks, labels = labels) +
		xlab("Chromosome") + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_d_w1",], linetype="dotted", color = "red", size=0.2) +
		labs(subtitle="Paclitaxel (wk 1)") #+
		# scale_y_continuous(breaks=seq(0,120,20),limit = c(0, 120))
print(p1)


# ~~~~~~~~~ test other color/alpha schemes ~~~~~~~~~~~~~~~~~~


# # # Select on alternate chromosomes (col) and > or < thresh (col)

# logP_hamster[logP_hamster$log10p_g_avg > hamster_thresh_95["log10p_g_avg",],"thresh"] <- "b"
# logP_hamster[logP_hamster$log10p_g_avg < hamster_thresh_95["log10p_g_avg",],"thresh"] <- "a"

# cb1<-rep(c("grey51", "skyblue4","grey", "skyblue"), 12)

# p1 <- ggplot(
 		# data = logP_hamster, 
 		# aes(
 			# x = coord, 
 			# y = log10p_g_avg, 
 			# color=interaction(as.factor(logP_hamster$Chromosome%%2),as.factor(logP_hamster$thresh))
 			# )
 		# ) + 
 		# geom_point(size= size_point,stroke=0) +
 		# scale_color_manual(values=cb1) +
 		# theme2 +
 		# scale_x_continuous(breaks = breaks, labels = labels) +
 		# xlab("Chromosome") + 
 		# ylab(expression('-log'[10]*italic('P'))) +
 		# geom_hline(yintercept= hamster_thresh_95["log10p_g_avg",], linetype="dotted", color = "red", size=0.4) +
 		# labs(subtitle="Growth") +
 		# scale_y_continuous(breaks=seq(0,120,20),limit = c(0, 120))
# print(p1)



# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

# # Select on alternate chromosomes (col) and > or < thresh (alpha)

# logP_hamster[logP_hamster$log10p_g_avg > hamster_thresh_95["log10p_g_avg",],"alpha"] <- "b"
# logP_hamster[logP_hamster$log10p_g_avg < hamster_thresh_95["log10p_g_avg",],"alpha"] <- "a"

# # attractive grey and skyblue color scheme
# cb1<-rep(c("grey", "skyblue"), 12)


# p1 <- ggplot(
 		# data = logP_hamster, 
 		# aes(
 			# x = coord, 
 			# y = log10p_g_avg, 
 			# color=as.factor(Chromosome),
 			# alpha=as.factor(alpha)
 			# )
 		# ) + 
 		# geom_point(size= size_point,stroke=0) +
 		# scale_color_manual(values=cb1) +
 		# scale_alpha_discrete(range = c(0.3, 1)) + 
 		# theme2 +
 		# scale_x_continuous(breaks = breaks, labels = labels) +
 		# xlab("Chromosome") + 
 		# ylab(expression('-log'[10]*italic('P'))) +
 		# geom_hline(yintercept= hamster_thresh_95["log10p_g_avg",], linetype="dotted", color = "red", size=0.4) +
 		# labs(subtitle="Growth") +
 		# scale_y_continuous(breaks=seq(0,120,20),limit = c(0, 120))
# print(p1)


#----------------- hamster paclitaxel (wk 2) ---------------------


balloon_scale <- 5 # inflation factor for significant points	
size_point <- 0.1*(1 + balloon_scale*(logP_hamster$log10p_d_w2/max(logP_hamster$log10p_d_w2))) # scale significant points



p2 <- ggplot() + 
		geom_point(
			data = logP_hamster, 
			size= size_point,
			stroke=0, 
				aes(
					x = coord, 
					y = log10p_d_w2, 
					color=as.factor(Chromosome)
					)
				) +
		scale_color_manual(values=cb1) +
		theme2 +
		scale_x_continuous(breaks = breaks, labels = labels) +
		xlab("Chromosome") + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_d_w2",], linetype="dotted", color = "red", size=0.2) +
		labs(subtitle="Paclitaxel (wk 2)") #+
		# scale_y_continuous(breaks=seq(0,120,20),limit = c(0, 120))
print(p2)


#----------------- hamster paclitaxel (wk 3) ---------------------


balloon_scale <- 5 # inflation factor for significant points	
size_point <- 0.1*(1 + balloon_scale*(logP_hamster$log10p_d_w3/max(logP_hamster$log10p_d_w3))) # scale significant points



p3 <- ggplot() + 
		geom_point(
			data = logP_hamster, 
			size= size_point,
			stroke=0, 
				aes(
					x = coord, 
					y = log10p_d_w3, 
					color=as.factor(Chromosome)
					)
				) +
		scale_color_manual(values=cb1) +
		theme2 +
		scale_x_continuous(breaks = breaks, labels = labels) +
		xlab("Chromosome") + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_d_w3",], linetype="dotted", color = "red", size=0.2) +
		labs(subtitle="Paclitaxel (wk 3)") #+
		# scale_y_continuous(breaks=seq(0,120,20),limit = c(0, 120))
print(p3)



#----------------- hamster paclitaxel (wk 4) ---------------------


balloon_scale <- 5 # inflation factor for significant points	
size_point <- 0.1*(1 + balloon_scale*(logP_hamster$log10p_d_w4/max(logP_hamster$log10p_d_w4))) # scale significant points



p4 <- ggplot() + 
		geom_point(
			data = logP_hamster, 
			size= size_point,
			stroke=0, 
				aes(
					x = coord, 
					y = log10p_d_w4, 
					color=as.factor(Chromosome)
					)
				) +
		scale_color_manual(values=cb1) +
		theme2 +
		scale_x_continuous(breaks = breaks, labels = labels) +
		xlab("Chromosome") + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_d_w4",], linetype="dotted", color = "red", size=0.2) +
		labs(subtitle="Paclitaxel (wk 4)") #+
		# scale_y_continuous(breaks=seq(0,120,20),limit = c(0, 120))
print(p4)




#----------------- hamster paclitaxel (wk 6) ---------------------


balloon_scale <- 5 # inflation factor for significant points	
size_point <- 0.1*(1 + balloon_scale*(logP_hamster$log10p_d_w6/max(logP_hamster$log10p_d_w6))) # scale significant points



p5 <- ggplot() + 
		geom_point(
			data = logP_hamster, 
			size= size_point,
			stroke=0, 
				aes(
					x = coord, 
					y = log10p_d_w6, 
					color=as.factor(Chromosome)
					)
				) +
		scale_color_manual(values=cb1) +
		theme2 +
		scale_x_continuous(breaks = breaks, labels = labels) +
		xlab("Chromosome") + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_d_w6",], linetype="dotted", color = "red", size=0.2) +
		labs(subtitle="Paclitaxel (wk 6)") #+
		# scale_y_continuous(breaks=seq(0,120,20),limit = c(0, 120))
print(p5)



#----------------- hamster paclitaxel (avg) ---------------------


balloon_scale <- 5 # inflation factor for significant points	
size_point <- 0.1*(1 + balloon_scale*(logP_hamster$log10p_g_d_Ix/max(logP_hamster$log10p_g_d_Ix))) # scale significant points



p6 <- ggplot() + 
		geom_point(
			data = logP_hamster, 
			size= size_point,
			stroke=0, 
				aes(
					x = coord, 
					y = log10p_g_avg, 
					color=as.factor(Chromosome)
					)
				) +
		scale_color_manual(values=cb1) +
		theme2 +
		scale_x_continuous(breaks = breaks, labels = labels) +
		xlab("Chromosome") + 
		ylab(expression('-log'[10]*italic('P'))) +
		geom_hline(yintercept= hamster_thresh_95["log10p_g_avg",], linetype="dotted", color = "red", size=0.2) +
		labs(subtitle="Paclitaxel (avg)") #+
		# scale_y_continuous(breaks=seq(0,120,20),limit = c(0, 120))
print(p6)





#------------------Make file --------------------------


pdf("Drug_loci_hamster_1.pdf", width=7.5, height=10, useDingbats=FALSE)
plot_grid(p1, p2, p3, p4, p5, p6, labels=c("A", "B", "C", "D", "E","F"), ncol = 2, nrow = 3, label_size = 16)
dev.off()



tiff("Drug_loci_hamster_1.tif", width=7.5, height=10,units="in",res=300)
plot_grid(p1, p2, p3, p4, p5, p6, labels=c("A", "B", "C", "D", "E","F"), ncol = 2, nrow = 3, label_size = 16)
dev.off()



# ~900 kb
png("Drug_loci_hamster_1.png", width=7.5, height=10,units="in",res=300)
plot_grid(p1, p2, p3, p4, p5, p6, labels=c("A", "B", "C", "D", "E","F"), ncol = 2, nrow = 3, label_size = 16)
dev.off()



png("Drug_loci_hamster_hi_res_1.png", width=7.5, height=10,units="in",res=1200)
plot_grid(p1, p2, p3, p4, p5, p6, labels=c("A", "B", "C", "D", "E","F"), ncol = 2, nrow = 3, label_size = 16)
dev.off()



















