# Myco_raw_reads_des.txt from Arshad

myco <- read.table("Myco_raw_reads_des.txt", header=TRUE, sep="\t", stringsAsFactors=FALSE)
cell <- read.table("cell_label_info.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE)

# get rid of dummy last row:
myco <- myco[-nrow(myco),]

dim(myco)
# [1] 115   2


head(myco)
        # ID myco_reads
# 1      RH1         19
# 2 RH1_0_w1         19
# 3 RH1_0_w2         23
# 4 RH1_0_w3         10
# 5 RH1_0_w4         29
# 6 RH1_0_w6         31


colnames(myco) <- c("RH_ID","myco_ferm_reads")

myco$RH_ID <- gsub("^RH1$","RH1_w0_d0", myco$RH_ID)
myco$RH_ID <- gsub("^RH2$","RH2_w0_d0", myco$RH_ID)
myco$RH_ID <- gsub("^RH3$","RH3_w0_d0", myco$RH_ID)
myco$RH_ID <- gsub("^RH4$","RH4_w0_d0", myco$RH_ID)
myco$RH_ID <- gsub("^RH5$","RH5_w0_d0", myco$RH_ID)
myco$RH_ID <- gsub("^RH6$","RH6_w0_d0", myco$RH_ID)

myco$RH_ID <- gsub("_0_w1$","_w1_d0", myco$RH_ID)
myco$RH_ID <- gsub("_8_w1$","_w1_d8", myco$RH_ID)
myco$RH_ID <- gsub("_25_w1$","_w1_d25", myco$RH_ID)
myco$RH_ID <- gsub("_75_w1$","_w1_d75", myco$RH_ID)

myco$RH_ID <- gsub("_0_w2$","_w2_d0", myco$RH_ID)
myco$RH_ID <- gsub("_8_w2$","_w2_d8", myco$RH_ID)
myco$RH_ID <- gsub("_25_w2$","_w2_d25", myco$RH_ID)
myco$RH_ID <- gsub("_75_w2$","_w2_d75", myco$RH_ID)

myco$RH_ID <- gsub("_0_w3$","_w3_d0", myco$RH_ID)
myco$RH_ID <- gsub("_8_w3$","_w3_d8", myco$RH_ID)
myco$RH_ID <- gsub("_25_w3$","_w3_d25", myco$RH_ID)
myco$RH_ID <- gsub("_75_w3$","_w3_d75", myco$RH_ID)

myco$RH_ID <- gsub("_0_w4$","_w4_d0", myco$RH_ID)
myco$RH_ID <- gsub("_8_w4$","_w4_d8", myco$RH_ID)
myco$RH_ID <- gsub("_25_w4$","_w4_d25", myco$RH_ID)
myco$RH_ID <- gsub("_75_w4$","_w4_d75", myco$RH_ID)

myco$RH_ID <- gsub("_0_w6$","_w6_d0", myco$RH_ID)
myco$RH_ID <- gsub("_8_w6$","_w6_d8", myco$RH_ID)
myco$RH_ID <- gsub("_25_w6$","_w6_d25", myco$RH_ID)
myco$RH_ID <- gsub("_75_w6$","_w6_d75", myco$RH_ID)





myco$week <- 0
myco[grepl("_w0_",myco$RH_ID),]$week <- 0
myco[grepl("_w1_",myco$RH_ID),]$week <- 1
myco[grepl("_w2_",myco$RH_ID),]$week <- 2
myco[grepl("_w3_",myco$RH_ID),]$week <- 3
myco[grepl("_w4_",myco$RH_ID),]$week <- 4
myco[grepl("_w6_",myco$RH_ID),]$week <- 6

myco$conc <- 0
myco[grepl("_d0",myco$RH_ID),]$conc <- 0
myco[grepl("_d8",myco$RH_ID),]$conc <- 8
myco[grepl("_d25",myco$RH_ID),]$conc <- 25
myco[grepl("_d75",myco$RH_ID),]$conc <- 75

myco$pool <- 0
myco[grepl("RH1_",myco$RH_ID),]$pool <- 1
myco[grepl("RH2_",myco$RH_ID),]$pool <- 2
myco[grepl("RH3_",myco$RH_ID),]$pool <- 3
myco[grepl("RH4_",myco$RH_ID),]$pool <- 4
myco[grepl("RH5_",myco$RH_ID),]$pool <- 5
myco[grepl("RH6_",myco$RH_ID),]$pool <- 6

myco <- merge(myco,cell)
myco <- myco[,c("RH_ID","pool",	"conc",	"week", "cell","myco_ferm_reads")]


write.table(myco,"myco_ferm_gseq.txt",quote=FALSE,sep="\t",row.names=FALSE)


























