# Make data frame with human mitochondrial reads



# ------------------ Read in and prepare ancillary tables -------------------------------

cell <- read.table("cell_label_info.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE)



# -------------- Add human mito reads -------------------


# RH_human_reads.txt saved from "RH_pool against_hg38_fixed-11_24_18.xlsx"
# Unlike RH_human_gseq.txt, RH_human_reads.txt has chrM

RH_human <- read.table("RH_human_reads.txt", header=TRUE, sep="\t", stringsAsFactors=FALSE)


dim(RH_human)
# [1] 323560    118

# Include mitochondria (NB takes 2 lines, only one valid)
RH_human[RH_human$Chromosome == "chrM",1:10]
       # Chromosome Start   End RH1_w0_0 RH1_w1_0 RH1_w1_8 RH1_w1_25 RH1_w1_75 RH1_w2_0 RH1_w2_8
# 323024       chrM     0 16569       16       70       31        24        49        1        0
# 323025       chrM 10000 16569        7        1        2         0         2        0        0


# select correct line
human_mito_reads <- RH_human[RH_human$Chromosome == "chrM",][1,]


colnames(human_mito_reads)[2:3] <- c("posS","posE")
human_mito_reads$pos <- round(rowMeans(human_mito_reads[,c("posS","posE")]))
human_mito_reads <- human_mito_reads[,c(1:3,ncol(human_mito_reads),4:(ncol(human_mito_reads)-1))]



# Rename columns
colnames(human_mito_reads) <- gsub("_0$","_d0",colnames(human_mito_reads))
colnames(human_mito_reads) <- gsub("_8$","_d8",colnames(human_mito_reads))
colnames(human_mito_reads) <- gsub("_25$","_d25",colnames(human_mito_reads))
colnames(human_mito_reads) <- gsub("_75$","_d75",colnames(human_mito_reads))




human_mito_reads_l <- reshape(human_mito_reads, 
  varying = c(colnames(human_mito_reads[c(5:ncol(human_mito_reads))])), 
  v.names = "human_mito_reads",
  timevar = "RH_ID", 
  times = c(colnames(human_mito_reads[c(5:ncol(human_mito_reads))])), 
  new.row.names = 1:1e6,
  direction = "long")
  
human_mito_reads_l$week <- 0
human_mito_reads_l[grepl("_w0_",human_mito_reads_l$RH_ID),]$week <- 0
human_mito_reads_l[grepl("_w1_",human_mito_reads_l$RH_ID),]$week <- 1
human_mito_reads_l[grepl("_w2_",human_mito_reads_l$RH_ID),]$week <- 2
human_mito_reads_l[grepl("_w3_",human_mito_reads_l$RH_ID),]$week <- 3
human_mito_reads_l[grepl("_w4_",human_mito_reads_l$RH_ID),]$week <- 4
human_mito_reads_l[grepl("_w6_",human_mito_reads_l$RH_ID),]$week <- 6

human_mito_reads_l$conc <- 0
human_mito_reads_l[grepl("_d0",human_mito_reads_l$RH_ID),]$conc <- 0
human_mito_reads_l[grepl("_d8",human_mito_reads_l$RH_ID),]$conc <- 8
human_mito_reads_l[grepl("_d25",human_mito_reads_l$RH_ID),]$conc <- 25
human_mito_reads_l[grepl("_d75",human_mito_reads_l$RH_ID),]$conc <- 75

human_mito_reads_l$pool <- 0
human_mito_reads_l[grepl("RH1_",human_mito_reads_l$RH_ID),]$pool <- 1
human_mito_reads_l[grepl("RH2_",human_mito_reads_l$RH_ID),]$pool <- 2
human_mito_reads_l[grepl("RH3_",human_mito_reads_l$RH_ID),]$pool <- 3
human_mito_reads_l[grepl("RH4_",human_mito_reads_l$RH_ID),]$pool <- 4
human_mito_reads_l[grepl("RH5_",human_mito_reads_l$RH_ID),]$pool <- 5
human_mito_reads_l[grepl("RH6_",human_mito_reads_l$RH_ID),]$pool <- 6


human_mito_reads_l <- merge(human_mito_reads_l,cell)

human_mito_reads_l <- human_mito_reads_l[,c("RH_ID","Chromosome","posS","posE","pos","pool","conc","week","cell","human_mito_reads")]

write.table(human_mito_reads_l,"human_mito_gseq.txt",quote=FALSE,sep="\t",row.names=FALSE)

























