# Make data frame with hamster mitochondrial reads



# ------------------ Read in and prepare ancillary tables -------------------------------

cell <- read.table("cell_label_info.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE)



# -------------- Add hamster mito reads -------------------


# RH_hamster_reads.txt saved from "RH_PICR_RAW_ordered_fixed_11_29_18.xlsx"
# Unlike RH_hamster_gseq.txt, RH_hamster_reads.txt has chrM

RH_hamster <- read.table("RH_hamster_reads.txt", header=TRUE, sep="\t", stringsAsFactors=FALSE)


dim(RH_hamster)
# [1] 237825    119

hamster_mito_reads <- RH_hamster[RH_hamster$Chromosome == "chromosomeM",][1,]


colnames(hamster_mito_reads)[3:4] <- c("posS","posE")
hamster_mito_reads$pos <- round(rowMeans(hamster_mito_reads[,c("posS","posE")]))
hamster_mito_reads <- hamster_mito_reads[,c(1:4,ncol(hamster_mito_reads),5:(ncol(hamster_mito_reads)-1))]



# Rename columns
colnames(hamster_mito_reads) <- gsub("_0$","_d0",colnames(hamster_mito_reads))
colnames(hamster_mito_reads) <- gsub("_8$","_d8",colnames(hamster_mito_reads))
colnames(hamster_mito_reads) <- gsub("_25$","_d25",colnames(hamster_mito_reads))
colnames(hamster_mito_reads) <- gsub("_75$","_d75",colnames(hamster_mito_reads))

# get rid of Contig_id
hamster_mito_reads <- hamster_mito_reads[2:length(hamster_mito_reads)]

hamster_mito_reads["Chromosome"] <- "chrM"


hamster_mito_reads_l <- reshape(hamster_mito_reads, 
  varying = c(colnames(hamster_mito_reads[c(5:ncol(hamster_mito_reads))])), 
  v.names = "hamster_mito_reads",
  timevar = "RH_ID", 
  times = c(colnames(hamster_mito_reads[c(5:ncol(hamster_mito_reads))])), 
  new.row.names = 1:1e6,
  direction = "long")
  
hamster_mito_reads_l$week <- 0
hamster_mito_reads_l[grepl("_w0_",hamster_mito_reads_l$RH_ID),]$week <- 0
hamster_mito_reads_l[grepl("_w1_",hamster_mito_reads_l$RH_ID),]$week <- 1
hamster_mito_reads_l[grepl("_w2_",hamster_mito_reads_l$RH_ID),]$week <- 2
hamster_mito_reads_l[grepl("_w3_",hamster_mito_reads_l$RH_ID),]$week <- 3
hamster_mito_reads_l[grepl("_w4_",hamster_mito_reads_l$RH_ID),]$week <- 4
hamster_mito_reads_l[grepl("_w6_",hamster_mito_reads_l$RH_ID),]$week <- 6

hamster_mito_reads_l$conc <- 0
hamster_mito_reads_l[grepl("_d0",hamster_mito_reads_l$RH_ID),]$conc <- 0
hamster_mito_reads_l[grepl("_d8",hamster_mito_reads_l$RH_ID),]$conc <- 8
hamster_mito_reads_l[grepl("_d25",hamster_mito_reads_l$RH_ID),]$conc <- 25
hamster_mito_reads_l[grepl("_d75",hamster_mito_reads_l$RH_ID),]$conc <- 75

hamster_mito_reads_l$pool <- 0
hamster_mito_reads_l[grepl("RH1_",hamster_mito_reads_l$RH_ID),]$pool <- 1
hamster_mito_reads_l[grepl("RH2_",hamster_mito_reads_l$RH_ID),]$pool <- 2
hamster_mito_reads_l[grepl("RH3_",hamster_mito_reads_l$RH_ID),]$pool <- 3
hamster_mito_reads_l[grepl("RH4_",hamster_mito_reads_l$RH_ID),]$pool <- 4
hamster_mito_reads_l[grepl("RH5_",hamster_mito_reads_l$RH_ID),]$pool <- 5
hamster_mito_reads_l[grepl("RH6_",hamster_mito_reads_l$RH_ID),]$pool <- 6


hamster_mito_reads_l <- merge(hamster_mito_reads_l,cell)

hamster_mito_reads_l <- hamster_mito_reads_l[,c("RH_ID","Chromosome","posS","posE","pos","pool","conc","week","cell","hamster_mito_reads")]

write.table(hamster_mito_reads_l,"hamster_mito_gseq.txt",quote=FALSE,sep="\t",row.names=FALSE)

























