# Retention of hamster DNNA in the six RH pools

#install.packages("ggplot2")
library(ggplot2)
library(cowplot) #used with plot_grid 

#----------------Aesthetics ---------------------------


theme2 <- theme(
	plot.margin = unit(c(t=1.2,r=0.4,b=1.2,l=0.4), "cm"),
	panel.grid.major = element_blank(), 
	panel.grid.minor = element_blank(), 
	panel.background = element_blank(), 
	legend.position="none", 
	axis.line.x = element_line(colour = "black", size = 0.1), 
	axis.line.y = element_line(colour = "black", size = 0.1), 
	axis.ticks = element_line(colour = "black", size = 0.1),
	axis.text=element_text(size=12), #numbers on tick marks of x and y axes
	axis.title=element_text(size=14), #titles of x and y axes
	axis.title.y=element_text(margin=margin(0,13,0,0)), #moves y axis title by adding margin space to bottom
	axis.title.x=element_text(margin=margin(10,0,0,0)),  #moves x axis title by adding margin space to top
	plot.title = element_text(size=32, face="bold", hjust = -0.14), #can provide "A","B", by ggtitle, but used plot_grid wch can shift more left
	plot.subtitle = element_text(size=14, face="plain", hjust = 0.5) #hjust shifts right
	)




# darkest two hues from 3-class PuBuGn in color brewer
# cb1<-rep(c("#1c9099", "#a6bddb"), 12)

# # darkest two hues from 3-class PuBu in color brewer
# cb1<-rep(c("#2b8cbe", "#a6bddb"), 12)


# #attractive pinks, greys
# cb1<-c("#999999", "#E69F00", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7","#999999", "#E69F00", "#56B4E9", "#E69F00", "#009E73", "#F0E442", "#0072B2", "#56B4E9", "#009E73", "#F0E442", "#0072B2", "#D55E00", "#CC79A7","#999999", "#D55E00", "#CC79A7")

# cb1_rev <- c("#CC79A7", "#D55E00", "#0072B2", "#F0E442", "#009E73", "#56B4E9", "#E69F00","#999999", "#CC79A7", "#D55E00", "#0072B2", "#D55E00", "#F0E442", "#009E73", "#56B4E9", "#0072B2", "#F0E442", "#009E73", "#56B4E9", "#E69F00","#999999", "#CC79A7", "#E69F00","#999999")

# #'4-class RdBu'
# cb2 <- c('#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#f4a582','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#f4a582','#92c5de','#0571b0','#ca0020','#92c5de','#0571b0')

# #'4-class RdYlBu'
# cb3 <- c('#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#fdae61','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#fdae61','#abd9e9','#2c7bb6','#d7191c','#abd9e9','#2c7bb6')
	
	
size_point <- 0.3
size_hline <- 0.1

# If desired, modify balloon code. Probably not a good idea in this context, though.
# balloon_scale <- 0.8 # inflation factor for significant points	
# # scale significant points beginning wiht 0.8 pt
# size_point <- 0.8*(1 + balloon_scale*(bleed$A23_T_HUM_ratio_norm/max(bleed$A23_T_HUM_ratio_norm, na.rm=TRUE)))



#----------------- Prepare HAMSTER retain RH pools ---------------------


RH_hamster <- read.table("RH_hamster_gseq.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)

# Get rows at beginning of each chromosome:
RH_hamster_start <- RH_hamster[RH_hamster$posS == 0 & RH_hamster$posE == 1e6,]

# Get rid of ramp ups and ramp downs (though note that hamster has ramp downs, not ramp ups):
RH_hamster <- RH_hamster[c(0,diff(RH_hamster$pos)) == 1e4,]

# combine RH_hamster without ramps and RH_hamster_start:
RH_hamster <- rbind(RH_hamster_start,RH_hamster)


# # get rid of contigs with only one entry:
# RH_hamster <- RH_hamster[!(RH_hamster$Contig_ID %in% aggregate(pos ~ Contig_ID, 
          # data = RH_hamster, 
          # FUN = function(x){NROW(x)})[aggregate(pos ~ Contig_ID, 
          # data = RH_hamster, 
          # FUN = function(x){NROW(x)})$pos==1,"Contig_ID"]),]


# Sort:
chrOrder<-paste("chr",c(1:10,"X"),sep="")
RH_hamster$Chromosome <-factor(RH_hamster$Chromosome, levels=chrOrder)
RH_hamster <- RH_hamster[order(RH_hamster$Chromosome, RH_hamster$pos), ]
RH_hamster$Chromosome <- as.character(RH_hamster$Chromosome)


# Transform chr1 etc. to numbers
RH_hamster$Chromosome <- gsub('chr', '', RH_hamster$Chromosome)
RH_hamster[RH_hamster$Chromosome == "X","Chromosome"] <- 11
chrOrder<-c(1:11)
RH_hamster$Chromosome <-factor(RH_hamster$Chromosome, levels=chrOrder)
RH_hamster <- RH_hamster[order(RH_hamster$Chromosome, RH_hamster$pos), ]
RH_hamster$Chromosome <- as.numeric(RH_hamster$Chromosome)

# Compute chromosome size
gen_coord <- aggregate(pos~Chromosome,FUN=max,data=RH_hamster)
colnames(gen_coord)[2] <- "chr_size"
gen_coord$Chromosome <-factor(gen_coord$Chromosome, levels=chrOrder)
gen_coord <- gen_coord[order(gen_coord$Chromosome), ]
gen_coord$Chromosome <- as.numeric(gen_coord$Chromosome)

# Use cumsum to make genome coordinates
gen_coord$coord <- c(0,cumsum(gen_coord$chr_size)[-11])

# merge genome coordinates with RH_hamster
RH_hamster <- merge(RH_hamster,gen_coord[,c("Chromosome","coord")])
RH_hamster$Chromosome <-factor(RH_hamster$Chromosome, levels=chrOrder)
RH_hamster <- RH_hamster[order(RH_hamster$Chromosome, RH_hamster$pos), ]
RH_hamster$Chromosome <- as.numeric(RH_hamster$Chromosome)

RH_hamster$coord <- RH_hamster$pos + RH_hamster$coord

# find midpoints of chromosomes for breaks in ggplot
mid <- function(x) {(max(x)+min(x))/2}
chr_mid <- aggregate(coord~Chromosome,FUN = mid,data=RH_hamster)
colnames(chr_mid)[2] <- "mid"
chr_mid$Chromosome <-factor(chr_mid$Chromosome, levels=chrOrder)
chr_mid <- chr_mid[order(chr_mid$Chromosome), ]
chr_mid$Chromosome <- as.numeric(chr_mid$Chromosome)

# Define breaks as mid-points chromosomes
breaks <- chr_mid$mid


# attractive grey and skyblue color scheme
cb1<-c(rep(c("grey", "skyblue"), 5),"grey")

labels <- as.character(c(1:8,"","","X"))

#----------------- HAMSTER retain RH pool 1 ---------------------

# Transform reads into mean ratios for RH pool 1
RH_hamster$read_ratio <- RH_hamster[,c(grep("RH1_w0_d0$",colnames(RH_hamster)))]/mean(RH_hamster[,c(grep("RH1_w0_d0$",colnames(RH_hamster)))])


p1 <- ggplot(data = RH_hamster, aes(x = coord, y = read_ratio, color=as.factor(Chromosome))) + 
	geom_point(size= size_point,stroke=0) +
	scale_color_manual(values=cb1) +
	theme2 +
	scale_x_continuous(breaks = breaks, labels = labels) +
	# ggtitle("") + 
	xlab("Chromosome") + 
	ylab("Copy") + 
	labs(subtitle="RH pool 1")+
	scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2))
print(p1)

#----------------- HAMSTER retain RH pool 2 ---------------------


# Transform reads into mean ratios for RH pool 2
RH_hamster$read_ratio <- RH_hamster[,c(grep("RH2_w0_d0$",colnames(RH_hamster)))]/mean(RH_hamster[,c(grep("RH2_w0_d0$",colnames(RH_hamster)))])


p2 <- ggplot(data = RH_hamster, aes(x = coord, y = read_ratio, color=as.factor(Chromosome))) + 
	geom_point(size= size_point,stroke=0) +
	scale_color_manual(values=cb1) +
	theme2 +
	scale_x_continuous(breaks = breaks, labels = labels) +
	# ggtitle("") + 
	xlab("Chromosome") + 
	ylab("Copy") + 
	labs(subtitle="RH pool 2")+
	scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2))
print(p2)


#----------------- HAMSTER retain RH pool 3 ---------------------


# Transform reads into mean ratios for RH pool 3
RH_hamster$read_ratio <- RH_hamster[,c(grep("RH3_w0_d0$",colnames(RH_hamster)))]/mean(RH_hamster[,c(grep("RH3_w0_d0$",colnames(RH_hamster)))])


p3 <- ggplot(data = RH_hamster, aes(x = coord, y = read_ratio, color=as.factor(Chromosome))) + 
	geom_point(size= size_point,stroke=0) +
	scale_color_manual(values=cb1) +
	theme2 +
	scale_x_continuous(breaks = breaks, labels = labels) +
	# ggtitle("") + 
	xlab("Chromosome") + 
	ylab("Copy") + 
	labs(subtitle="RH pool 3")+
	scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2))
print(p3)

#----------------- HAMSTER retain RH pool 4 ---------------------


# Transform reads into mean ratios for RH pool 4
RH_hamster$read_ratio <- RH_hamster[,c(grep("RH4_w0_d0$",colnames(RH_hamster)))]/mean(RH_hamster[,c(grep("RH4_w0_d0$",colnames(RH_hamster)))])


p4 <- ggplot(data = RH_hamster, aes(x = coord, y = read_ratio, color=as.factor(Chromosome))) + 
	geom_point(size= size_point,stroke=0) +
	scale_color_manual(values=cb1) +
	theme2 +
	scale_x_continuous(breaks = breaks, labels = labels) +
	# ggtitle("") + 
	xlab("Chromosome") + 
	ylab("Copy") + 
	labs(subtitle="RH pool 4")+
	scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2))
print(p4)


#----------------- HAMSTER retain RH pool 5 ---------------------


# Transform reads into mean ratios for RH pool 5
RH_hamster$read_ratio <- RH_hamster[,c(grep("RH5_w0_d0$",colnames(RH_hamster)))]/mean(RH_hamster[,c(grep("RH5_w0_d0$",colnames(RH_hamster)))])


p5 <- ggplot(data = RH_hamster, aes(x = coord, y = read_ratio, color=as.factor(Chromosome))) + 
	geom_point(size= size_point,stroke=0) +
	scale_color_manual(values=cb1) +
	theme2 +
	scale_x_continuous(breaks = breaks, labels = labels) +
	# ggtitle("") + 
	xlab("Chromosome") + 
	ylab("Copy") + 
	labs(subtitle="RH pool 5")+
	scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2))
print(p5)


#----------------- HAMSTER retain RH pool 6 ---------------------


# Transform reads into mean ratios for RH pool 6
RH_hamster$read_ratio <- RH_hamster[,c(grep("RH6_w0_d0$",colnames(RH_hamster)))]/mean(RH_hamster[,c(grep("RH6_w0_d0$",colnames(RH_hamster)))])


p6 <- ggplot(data = RH_hamster, aes(x = coord, y = read_ratio, color=as.factor(Chromosome))) + 
	geom_point(size= size_point,stroke=0) +
	scale_color_manual(values=cb1) +
	theme2 +
	scale_x_continuous(breaks = breaks, labels = labels) +
	# ggtitle("") + 
	xlab("Chromosome") + 
	ylab("Copy") + 
	labs(subtitle="RH pool 6")+
	scale_y_continuous(breaks=c(0,1,2),limit = c(0, 2))
print(p6)



#------------------Make file --------------------------



pdf("Ham_seq_cov_montage_1.pdf", width=7.5, height=10, useDingbats = FALSE)
plot_grid(p1, p2,p3,p4,p5,p6, labels=c("A", "B","C","D","E","F"), ncol = 2, nrow = 3, label_size = 16)
dev.off()




tiff("Ham_seq_cov_montage_1.tif",width=7.5,height= 10,units="in",res=300)
plot_grid(p1, p2,p3,p4,p5,p6, labels=c("A", "B","C","D","E","F"), ncol = 2, nrow = 3, label_size = 16)
dev.off()





png("Ham_seq_cov_montage_1.png",width=7.5,height=10,units="in",res=300)
plot_grid(p1, p2,p3,p4,p5,p6, labels=c("A", "B","C","D","E","F"), ncol = 2, nrow = 3, label_size = 16)
dev.off()



png("Ham_seq_cov_montage_hi_res_1.png",width=7.5,height=10,units="in",res=1200)
plot_grid(p1, p2,p3,p4,p5,p6, labels=c("A", "B","C","D","E","F"), ncol = 2, nrow = 3, label_size = 16)
dev.off()




















