# log10P_human_plus_human_mito.txt constructed on Hoffman, cf folder "log10P_human_plus_human_mito"

logP <- read.table("log10P_human.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
hum_mito <- read.table("log10P_human_plus_human_mito.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)


# ---------- sem -------------------

sem <- function(x) {sqrt(var(x,na.rm=TRUE)/sum(!is.na(x)))}


# ------------ Correlations of logP vals before and after addition of human mito --------------

human_cor_logP <- data.frame(
								test = character(),
								R = numeric(),
								t = numeric(),
								df = numeric(),
								P = numeric(),
								stringsAsFactors=FALSE
								)

for(i in c(5:16)) {
	
	cor_ans <- cor.test(logP[seq(1,nrow(logP),1e2),i],hum_mito[seq(1,nrow(hum_mito),1e2),i])
	
	human_cor_logP[i-4,"test"] <- colnames(logP)[i]
	human_cor_logP[i-4,"R"] <- cor_ans$estimate
	human_cor_logP[i-4,"t"] <- cor_ans$statistic
	human_cor_logP[i-4,"df"] <- cor_ans$parameter
	human_cor_logP[i-4,"P"] <- cor_ans$p.value
	
	}


human_cor_logP
            # test         R         t   df P
# 1   log10p_g_0nM 0.9988183 1135.3517 3052 0
# 2   log10p_g_8nM 0.9992755 1450.4715 3052 0
# 3  log10p_g_25nM 0.9996925 2227.2253 3052 0
# 4  log10p_g_75nM 0.9975102  781.4218 3052 0
# 5   log10p_g_avg 0.9996755 2167.9000 3052 0
# 6    log10p_d_w1 0.9947748  538.2930 3052 0 <<<<<<<<<<<< use in paper
# 7    log10p_d_w2 0.9994551 1672.7356 3052 0
# 8    log10p_d_w3 0.9987710 1113.2675 3052 0
# 9    log10p_d_w4 0.9981107  897.4625 3052 0
# 10   log10p_d_w6 0.9973066  751.1843 3052 0
# 11  log10p_d_avg 0.9986011 1043.3423 3052 0
# 12 log10p_g_d_Ix 0.9949414  547.1560 3052 0




mean(human_cor_logP$R)
# [1] 0.9980777 <<<<<<<<<<<< use in paper

sem(human_cor_logP$R)
# [1] 0.0004881804 <<<<<<<<<<<< use in paper


hum_mito$log10q_human_mito <- -log10(p.adjust(10^-hum_mito$log10p_human_mito))


# use identify() to count number of loci in following plot:

plot(hum_mito$log10q_human_mito,cex=0.1)
abline(h=-log10(0.05),col="red",lwd=0.5)

identify(hum_mito$log10q_human_mito,cex=0.1)
# [1]   50888


# A total of 1 locus.
# Coef is > 0, ie increased human mito copy num is positively correlated with increased human copy number in critical region
# This is opposite to vast majority of significant growth loci! (Though may reflect more stringent significance threshold.)

hum_mito[c(50888),c("Chromosome","posS","posE","pos","log10p_human_mito","coef_human_mito","log10q_human_mito")]
      # Chromosome     posS     posE      pos log10p_human_mito coef_human_mito log10q_human_mito
# 50888       chr3 14740000 15740000 15240000          8.574216      0.00162057           3.08936  CAPN7/SH3BP5 <<<<<<<<<<<< use in paper. FDR = 10^-3.08936 = 0.0008140292




# Distance between 3' end of SH3BP5 and human mito qtl:
15240000-15254853
# [1] -14853

# Distance between human mito qtl and 5' end SH3BP5-AS1:
15240000-15254184
# [1] -14184


































