# log10P_human_plus_hamster_mito.txt constructed on Hoffman, cf folder "log10P_human_plus_hamster_mito"

logP <- read.table("log10P_human.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)
ham_mito <- read.table("log10P_human_plus_hamster_mito.txt",header=TRUE,sep="\t",stringsAsFactors=FALSE)


# ---------- sem -------------------

sem <- function(x) {sqrt(var(x,na.rm=TRUE)/sum(!is.na(x)))}


# ------------ Correlations of logP vals before and after addition of hamster mito --------------

human_hamster_cor_logP <- data.frame(
								test = character(),
								R = numeric(),
								t = numeric(),
								df = numeric(),
								P = numeric(),
								stringsAsFactors=FALSE
								)

for(i in c(5:16)) {
	
	cor_ans <- cor.test(logP[seq(1,nrow(logP),1e2),i],ham_mito[seq(1,nrow(ham_mito),1e2),i])
	
	human_hamster_cor_logP[i-4,"test"] <- colnames(logP)[i]
	human_hamster_cor_logP[i-4,"R"] <- cor_ans$estimate
	human_hamster_cor_logP[i-4,"t"] <- cor_ans$statistic
	human_hamster_cor_logP[i-4,"df"] <- cor_ans$parameter
	human_hamster_cor_logP[i-4,"P"] <- cor_ans$p.value
	
	}


human_hamster_cor_logP
            # test         R          t   df P
# 1   log10p_g_0nM 0.9980749  889.03974 3052 0
# 2   log10p_g_8nM 0.9987901 1122.02821 3052 0
# 3  log10p_g_25nM 0.9981988  919.19531 3052 0
# 4  log10p_g_75nM 0.9931651  470.08359 3052 0
# 5   log10p_g_avg 0.9980049  873.26160 3052 0
# 6    log10p_d_w1 0.8430366   86.59095 3052 0   <<<<<<<<<<<< use in paper
# 7    log10p_d_w2 0.8697219   97.35281 3052 0
# 8    log10p_d_w3 0.9403243  152.66314 3052 0   
# 9    log10p_d_w4 0.9628864  197.08493 3052 0
# 10   log10p_d_w6 0.9776259  256.75569 3052 0
# 11  log10p_d_avg 0.9468944  162.68691 3052 0
# 12 log10p_g_d_Ix 0.9891036  371.16305 3052 0


mean(human_hamster_cor_logP$R)
# [1] 0.9596522 <<<<<<<<< use in paper

sem(human_hamster_cor_logP$R)
# [1] 0.01520363 <<<<<<<<< use in paper




































