# Chose to normalize based on total sequence alignments because better evaluation of total read alignments and less worry about right skewed distribution, unlike retained human DNA.
# cf A23_HEK_mito_copy_num_0.R for code based on medians


# ~~~~~~~~~~ A23 mito copy number ~~~~~~~~~~

# Hamster mito is 16283 bp from RH_PICR_RAW_ordered_fixed_11_29_18.xlsx (this is the actual mito sequence used for alignment, not the updated version on https://www.ncbi.nlm.nih.gov/nuccore/CM010855.1, which is, nicely, also 16283 bp.)

# Hamster genome excluding mitochondria is 2368906908 bp from https://www.ncbi.nlm.nih.gov/assembly/GCA_003668045.1/

# From "Mito_reads_from_A23_HEK.xlsx" (see also "A23_HEK_map_info_10_29_18.xlsx"), mito reads = 95975

# From "A23_HEK_map_info_10_29_18.xlsx", aligned hamster genome reads = 33234329

# Assuming A23 is diploid and mito is haploid, mito copy number is:


2*((95975/16283)/((33234329-95975)/2368906908)) # {which is == 2*(95975/(33234329-95975))*(2368906908/16283)}
# [1] 842.6957 <<<<<<<<<< use in paper


# ~~~~~~~ HEK mito copy number ~~~~~~~~~~~~~~~~~~

# Human mito is 16569 bp from "RH_pool against_hg38_fixed-11_24_18.xlsx" (this is the actual mito sequence used for alignment, not the updated version on https://mitomap.org//bin/view.pl/MITOMAP/HumanMitoSeq, which is, nicely, also 16569 bp.)

# Human genome excluding mitochondrion is 3088269832 bp from human_chr_lengths_1.R

# From "Mito_reads_from_A23_HEK.xlsx" (see also "A23_HEK_map_info_10_29_18.xlsx"), mito reads = 153367

# From "A23_HEK_map_info_10_29_18.xlsx", aligned total genome reads = 40128368

# Assuming HEK293 is pseudotriploid (DOI: 10.1038/ncomms5767) and mito is haploid, mito copy number is:


3*((153367/16569)/((40128368-153367)/3088269832)) # {which is == 3*(153367/(40128368-153367))*(3088269832/16569)}
# [1] 2145.278 <<<<<<<<<< use in paper