sem <- function(x) {sqrt(var(x,na.rm=TRUE)/sum(!is.na(x)))}

clone <- read.table("clone.txt",header=TRUE,stringsAsFactors=FALSE,sep="\t")

clone
   # Pool gamma dil colonies reverts RH_clones
# 1     1  3000   5   545.00      95    450.00
# 2     1  3000  10  1045.00     260    785.00
# 3     1 10000   5   536.25     135    401.25
# 4     1 10000  10   770.00     210    560.00
# 5     2  3000   5   842.50     145    697.50
# 6     2  3000  10  2042.50     380   1662.50
# 7     2 10000   5   615.00     160    455.00
# 8     2 10000  10  1361.25     252   1109.25
# 9     3  3000   5   327.50      90    237.50
# 10    3  3000  10  1027.50     240    787.50
# 11    3 10000   5   262.50      80    182.50
# 12    3 10000  10   722.50     190    532.50
# 13    4  3000   5   348.75     115    233.75
# 14    4  3000  10   665.00     210    455.00
# 15    4 10000   5   255.00      70    185.00
# 16    4 10000  10   470.00     120    350.00
# 17    5  3000   5   680.00     185    495.00
# 18    5  3000  10  1510.00     420   1090.00
# 19    5 10000   5   498.75     160    338.75
# 20    5 10000  10  1422.50     380   1042.50
# 21    6  3000   5   627.50     180    447.50
# 22    6  3000  10  2062.50     640   1422.50
# 23    6 10000   5   498.75     310    188.75
# 24    6 10000  10  2157.50     540   1617.50



# ----------- Total colonies ------------------

# Combined colonies sem
sem(clone$colonies)
# [1] 117.7951 <<<<<<<<<< use in paper

aggregate(colonies~Pool,data=clone,FUN=sum)
  # Pool colonies
# 1    1  2896.25
# 2    2  4861.25
# 3    3  2340.00
# 4    4  1738.75
# 5    5  4111.25
# 6    6  5346.25



# Mean colonies per fusion
mean(aggregate(colonies~Pool,data=clone,FUN=sum)[,2])
# [1] 3548.958 <<<<<<<<<< use in paper

# colonies sem per fusion
sem(aggregate(colonies~Pool,data=clone,FUN=sum)[,2])
# [1] 589.7175 <<<<<<<<<< use in paper


# ---------------- Revertants --------------------------------

# Combined revertant sem
sem(clone$reverts)
# [1] 30.0156 <<<<<<<<<<< use in paper


aggregate(reverts~Pool,data=clone,FUN=sum)
  # Pool reverts
# 1    1     700
# 2    2     937
# 3    3     600
# 4    4     515
# 5    5    1145
# 6    6    1670



# Mean reverts per fusion
mean(aggregate(reverts~Pool,data=clone,FUN=sum)[,2])
# [1] 927.8333 <<<<<<<<<< use in paper


# reverts sem per fusion
sem(aggregate(reverts~Pool,data=clone,FUN=sum)[,2])
# [1] 175.8665 <<<<<<<<<< use in paper


# --------------- percent reverts --------------------

# Combined revertant percent sem
sem(clone$reverts/clone$colonies)
# [1] 0.01756118 <<<<<<< use in paper

cbind(clone,ratio_revert=(clone$reverts/clone$colonies))
   # Pool gamma dil colonies reverts RH_clones ratio_revert
# 1     1  3000   5   545.00      95    450.00    0.1743119
# 2     1  3000  10  1045.00     260    785.00    0.2488038
# 3     1 10000   5   536.25     135    401.25    0.2517483
# 4     1 10000  10   770.00     210    560.00    0.2727273
# 5     2  3000   5   842.50     145    697.50    0.1721068
# 6     2  3000  10  2042.50     380   1662.50    0.1860465
# 7     2 10000   5   615.00     160    455.00    0.2601626
# 8     2 10000  10  1361.25     252   1109.25    0.1851240
# 9     3  3000   5   327.50      90    237.50    0.2748092
# 10    3  3000  10  1027.50     240    787.50    0.2335766
# 11    3 10000   5   262.50      80    182.50    0.3047619
# 12    3 10000  10   722.50     190    532.50    0.2629758
# 13    4  3000   5   348.75     115    233.75    0.3297491
# 14    4  3000  10   665.00     210    455.00    0.3157895
# 15    4 10000   5   255.00      70    185.00    0.2745098
# 16    4 10000  10   470.00     120    350.00    0.2553191
# 17    5  3000   5   680.00     185    495.00    0.2720588
# 18    5  3000  10  1510.00     420   1090.00    0.2781457
# 19    5 10000   5   498.75     160    338.75    0.3208020
# 20    5 10000  10  1422.50     380   1042.50    0.2671353
# 21    6  3000   5   627.50     180    447.50    0.2868526
# 22    6  3000  10  2062.50     640   1422.50    0.3103030
# 23    6 10000   5   498.75     310    188.75    0.6215539
# 24    6 10000  10  2157.50     540   1617.50    0.2502897


cbind(Pool=unique(clone$Pool),revert_ratio=merge(aggregate(colonies~Pool,data=clone,FUN=sum),aggregate(reverts~Pool,data=clone,FUN=sum))$reverts/merge(aggregate(colonies~Pool,data=clone,FUN=sum),aggregate(reverts~Pool,data=clone,FUN=sum))$colonies)
     # Pool revert_ratio
# [1,]    1    0.2416918
# [2,]    2    0.1927488
# [3,]    3    0.2564103
# [4,]    4    0.2961898
# [5,]    5    0.2785041
# [6,]    6    0.3123685


# mean revert percent
mean(merge(aggregate(colonies~Pool,data=clone,FUN=sum),aggregate(reverts~Pool,data=clone,FUN=sum))$reverts/merge(aggregate(colonies~Pool,data=clone,FUN=sum),aggregate(reverts~Pool,data=clone,FUN=sum))$colonies)
# [1] 0.2629855 <<<<<<< use in paper

# revert percent sem
sem(merge(aggregate(colonies~Pool,data=clone,FUN=sum),aggregate(reverts~Pool,data=clone,FUN=sum))$reverts/merge(aggregate(colonies~Pool,data=clone,FUN=sum),aggregate(reverts~Pool,data=clone,FUN=sum))$colonies)
# [1] 0.01752321 <<<<<<< use in paper


# ------------ RH clones ------------------

# Combined RH clone sem
sem(clone$RH_clones)
# [1] 91.26672 <<<<<<<<<< use in paper

aggregate(RH_clones~Pool,data=clone,FUN=sum)
  # Pool RH_clones
# 1    1   2196.25
# 2    2   3924.25
# 3    3   1740.00
# 4    4   1223.75
# 5    5   2966.25
# 6    6   3676.25

# Mean RH clones per fusion
mean(aggregate(RH_clones~Pool,data=clone,FUN=sum)[,2])
# [1] 2621.125 <<<<<<<<<< use in paper

# RH clones sem per fusion
sem(aggregate(RH_clones~Pool,data=clone,FUN=sum)[,2])
# [1] 441.2139 <<<<<<<<<< use in paper








































