# Because very complicated using mgcv to get ICC (cf clone_count_3.R), decided to use glmmTMB, even though this approach was also not without a few complications.
# Radiation dose in rad = 0.01 Gy


# used dev version of glmmTMB which gives p vals at zero values cf https://stackoverflow.com/questions/51316991/glmmtmb-post-hoc-testing-and-glht
library(glmmTMB) 
library(multcomp)
library(performance)
library(sjstats)
library(insight)
library(emmeans)



# ----------- Enable glht with glmmTMB cf https://stackoverflow.com/questions/51886334/planned-contrasts-on-glmmtmb -------------

glht_glmmTMB <- function (model, ..., component="cond") {
    glht(model, ...,
         coef. = function(x) fixef(x)[[component]],
         vcov. = function(x) vcov(x)[[component]],
         df = NULL)
}
modelparm.glmmTMB <- function (model, coef. = function(x) fixef(x)[[component]],
                               vcov. = function(x) vcov(x)[[component]],
                               df = NULL, component="cond", ...) {
    multcomp:::modelparm.default(model, coef. = coef., vcov. = vcov.,
                        df = df, ...)
}




# ---------- Create usable version clone.txt -------------------

# clone <- read.table("clone.txt",header=TRUE,stringsAsFactors=FALSE,sep="\t")


# dim(clone)
# # [1] 24  9

# head(clone)
  # # Pool gamma dil  clones revs colonies reverts RH_clones ID
# # 1    1  3000   5  545.00   95   545.00      95    450.00  a
# # 2    1  3000  10 1045.00  260  1045.00     260    785.00  b
# # 3    1 10000   5  536.25  135   536.25     135    401.25  c
# # 4    1 10000  10  770.00  210   770.00     210    560.00  d
# # 5    2  3000   5  842.50  145   842.50     145    697.50  a
# # 6    2  3000  10 2042.50  380  2042.50     380   1662.50  b

# clone <- clone[,c(1,2,3,6,7,8)]

# dim(clone)
# # [1] 24  6


# head(clone)
  # # Pool gamma dil colonies reverts RH_clones
# # 1    1  3000   5   545.00      95    450.00
# # 2    1  3000  10  1045.00     260    785.00
# # 3    1 10000   5   536.25     135    401.25
# # 4    1 10000  10   770.00     210    560.00
# # 5    2  3000   5   842.50     145    697.50
# # 6    2  3000  10  2042.50     380   1662.50

# # write.table(clone,"clone.txt",row.names=FALSE,sep="\t")



# --------------------------------------------------------------------
# -------- Start here with clone.txt ---------------------------------
# --------------------------------------------------------------------


clone <- read.table("clone.txt",header=TRUE,stringsAsFactors=FALSE,sep="\t")
clone$Pool <- as.factor(clone$Pool)



# ----------------------------------------------------------------------------------------------------
# -------- Show data is overdispersed by comparing Poisson and neg binom, thus requires nb -----------
# -----------------------------------------------------------------------------------------------------


# Function cf https://bbolker.github.io/mixedmodels-misc/glmmFAQ.html#testing-for-overdispersioncomputing-overdispersion-factor

overdisp_fun <- function(model) {
    rdf <- df.residual(model)
    rp <- residuals(model,type="pearson")
    Pearson.chisq <- sum(rp^2)
    prat <- Pearson.chisq/rdf
    pval <- pchisq(Pearson.chisq, df=rdf, lower.tail=FALSE)
    c(chisq=Pearson.chisq,ratio=prat,rdf=rdf,p=pval)
}


# --------------- RH clones overdisp and random effects ----------------


# Because of averaging, RH_clones not whole nos, as should be for Poiss and neg binom. However, glmmTMB seemed to cope ok, so did not use round().

m1_Poiss <- glmmTMB(RH_clones ~ gamma * dil + (1|Pool), data = clone, family = poisson, REML=TRUE)
m1_neg_binom <- glmmTMB(RH_clones ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE)
m1_neg_binom_no_re <- glmmTMB(RH_clones ~ gamma * dil, data = clone, family = nbinom2, REML=TRUE)


# Get same answers, but with fewer parameters (no p value), from msme function. Also ratio in Ben Bolker function is same as dispersion. So Ben Bolker function is superior. cf https://stats.stackexchange.com/questions/66586/is-there-a-test-to-determine-whether-glm-overdispersion-is-significant


# negative binomial clearly fits better:

overdisp_fun(m1_Poiss)
        # chisq         ratio           rdf             p 
 # 5.702397e+02  2.479303e+01  2.300000e+01 7.807708e-106 <<<<<<<<<<<<<<<<< use in paper


overdisp_fun(m1_neg_binom)
     # chisq      ratio        rdf          p 
# 15.3518399  0.6978109 22.0000000  0.8467015  <<<<<<<<<<<<<<<<<< use in paper


# Random effects improve fit:

AIC(m1_neg_binom)
# [1] 378.4097 <<<<<<<<<<<<<<<<<< use in paper



AIC(m1_neg_binom_no_re)
# [1] 387.3411  <<<<<<<<<<<<<<<<<< use in paper




# repeated below

anova(m1_neg_binom, m1_neg_binom_no_re,test="Chisq")
# Data: clone
# Models:
# m1_neg_binom_no_re: RH_clones ~ gamma * dil, zi=~0, disp=~1
# m1_neg_binom: RH_clones ~ gamma * dil + (1 | Pool), zi=~0, disp=~1
                   # Df    AIC    BIC  logLik deviance  Chisq Chi Df Pr(>Chisq)    
# m1_neg_binom_no_re  5 387.34 393.23 -188.67   377.34                             
# m1_neg_binom        6 378.41 385.48 -183.21   366.41 10.931      1  0.0009455 ***  <<<<<<<<<<<<<<<<<< use in paper
# ---
# Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1


# --------------- RH colonies overdisp and random effects -------------------------------


# Because of averaging, colonies not whole nos, as should be for Poiss and neg binom. However, glmmTMB seemed to cope ok, so did not use round().

m1_colonies_Poiss <- glmmTMB(colonies ~ gamma * dil + (1|Pool), data = clone, family = poisson, REML=TRUE)
m1_colonies_neg_binom <- glmmTMB(colonies ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE)
m1_colonies_neg_binom_no_re <- glmmTMB(colonies ~ gamma * dil, data = clone, family = nbinom2, REML=TRUE)


# Get same answers, but with fewer parameters (no p value), from msme function. Also ratio in Ben Bolker function is same as dispersion. So Ben Bolker function is superior. cf https://stats.stackexchange.com/questions/66586/is-there-a-test-to-determine-whether-glm-overdispersion-is-significant


# negative binomial clearly fits better:

overdisp_fun(m1_colonies_Poiss)
       # chisq        ratio          rdf            p 
# 4.668655e+02 2.029850e+01 2.300000e+01 2.700884e-84  <<<<<<<<<<<<<<<<< use in paper


overdisp_fun(m1_colonies_neg_binom)
     # chisq      ratio        rdf          p 
# 15.9145363  0.7233880 22.0000000  0.8201046   <<<<<<<<<<<<<<<<<< use in paper


# Random effects improve fit:

AIC(m1_colonies_neg_binom)
# [1] 383.9406 <<<<<<<<<<<<<<<<<< use in paper



AIC(m1_colonies_neg_binom_no_re)
# [1] 400.1409 <<<<<<<<<<<<<<<<<< use in paper


# repeated below

anova(m1_colonies_neg_binom, m1_colonies_neg_binom_no_re,test="Chisq")
# Data: clone
# Models:
# m1_colonies_neg_binom_no_re: colonies ~ gamma * dil, zi=~0, disp=~1
# m1_colonies_neg_binom: colonies ~ gamma * dil + (1 | Pool), zi=~0, disp=~1
                            # Df    AIC    BIC  logLik deviance Chisq Chi Df Pr(>Chisq)    
# m1_colonies_neg_binom_no_re  5 400.14 406.03 -195.07   390.14                            
# m1_colonies_neg_binom        6 383.94 391.01 -185.97   371.94  18.2      1  1.988e-05 *** <<<<<<<<<<<< use in paper
# ---
# Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1



# --------------- RH revertants overdisp and random effects ------------------------------


# Because of averaging, reverts not whole nos, as should be for Poiss and neg binom. However, glmmTMB seemed to cope ok, so did not use round().

m1_reverts_Poiss <- glmmTMB(reverts ~ gamma * dil + (1|Pool), data = clone, family = poisson, REML=TRUE)
m1_reverts_neg_binom <- glmmTMB(reverts ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE)
m1_reverts_neg_binom_no_re <- glmmTMB(reverts ~ gamma * dil, data = clone, family = nbinom2, REML=TRUE)


# Get same answers, but with fewer parameters (no p value), from msme function. Also ratio in Ben Bolker function is same as dispersion. So Ben Bolker function is superior. cf https://stats.stackexchange.com/questions/66586/is-there-a-test-to-determine-whether-glm-overdispersion-is-significant


# negative binomial clearly fits better:

overdisp_fun(m1_reverts_Poiss)
       # chisq        ratio          rdf            p 
# 8.038657e+01 3.495068e+00 2.300000e+01 2.748674e-08  <<<<<<<<<<<<<<<<< use in paper


overdisp_fun(m1_reverts_neg_binom)
     # chisq      ratio        rdf          p 
# 15.8230352  0.7192289 22.0000000  0.8245705   <<<<<<<<<<<<<<<<<< use in paper


# Random effects improve fit:

AIC(m1_reverts_neg_binom)
# [1] 318.4426 <<<<<<<<<<<<<<<<<< use in paper



AIC(m1_reverts_neg_binom_no_re)
# [1] 339.1226 <<<<<<<<<<<<<<<<<< use in paper



# repeated below

anova(m1_reverts_neg_binom, m1_reverts_neg_binom_no_re,test="Chisq")
# Data: clone
# Models:
# m1_reverts_neg_binom_no_re: reverts ~ gamma * dil, zi=~0, disp=~1
# m1_reverts_neg_binom: reverts ~ gamma * dil + (1 | Pool), zi=~0, disp=~1
                           # Df    AIC    BIC  logLik deviance Chisq Chi Df Pr(>Chisq)    
# m1_reverts_neg_binom_no_re  5 339.12 345.01 -164.56   329.12                            
# m1_reverts_neg_binom        6 318.44 325.51 -153.22   306.44 22.68      1  1.913e-06 ***
# ---
# Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1





# ------------------------------------------------------
# ----------- RH clones fixed effects ----------------
# ---------------------------------------------------------



m1_clones <- glmmTMB(RH_clones ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE)


glht_gamma <- glht(m1_clones, linfct = c("gamma + 7.5*gamma:dil == 0"))
glht_dil <- glht(m1_clones, linfct = c("dil + (6500)*gamma:dil == 0"))
glht_omni <- glht(m1_clones)

gamma_stat <- summary(glht_gamma,test = adjusted("none"))$test$tstat
dil_stat <- summary(glht_dil,test = adjusted("none"))$test$tstat
Ix_stat <- summary(glht_omni,test = adjusted("none"))$test$tstat["gamma:dil"]
gamma_coef <- summary(glht_gamma,test = adjusted("none"))$test$coefficients
dil_coef <- summary(glht_dil,test = adjusted("none"))$test$coefficients
Ix_coef <- summary(glht_omni,test = adjusted("none"))$test$coefficients["gamma:dil"]
 		
	
ans <- c(
 		gamma_coef,
 		dil_coef,
 		Ix_coef,
 		gamma_stat,
 		dil_stat,
 		Ix_stat,
 		2*pnorm(-abs(gamma_stat)),
 		2*pnorm(-abs(dil_stat)),
 		2*pnorm(-abs(Ix_stat))
 		)
 		
names(ans) <- c("gamma_coef","dil_coef","Ix_coef","gamma_Z","dil_Z","Ix_Z","gamma_P","dil_P","Ix_P")

ans
   # gamma_coef      dil_coef       Ix_coef       gamma_Z         dil_Z          Ix_Z       gamma_P         dil_P          Ix_P 
# -3.844067e-05  1.907591e-01  4.388150e-06 -2.422257e+00  8.465588e+00  6.887720e-01  1.542442e-02  2.548643e-17  4.909667e-01  


# emmeans
# R does not provide kenward-roger for glmms (eg neg binom) cf https://bbolker.github.io/mixedmodels-misc/glmmFAQ.html
# And for negative binomial, emmeans does not appear to provide analogous option df.lmer="asymp" (or df.lmer="tukey", df.lmer="kenward-roger", etc), so cannot directly P values using asymptotic df from emmeans with Z score P values above.
# That is, difference in p vals between emmeans and Z tests above are because two sided tests above are Z with (df = Inf), while below are 2 sided t tests (df = finite).
# see also https://stats.stackexchange.com/questions/350152/report-p-values-from-model-fitting-or-glht 

# gamma

summary(contrast(emmeans(m1_clones, specs="gamma", at=list(gamma=c(0,1), dil=7.5)),list(c(-1,1))))
# NOTE: Results may be misleading due to involvement in interactions
 # contrast  estimate       SE df t.ratio p.value
 # c(-1, 1) -3.84e-05 1.59e-05 22 -2.422  0.0241 <<<<<<<<<<< use in paper
 
 
# Alternative using emtrends
test(emtrends(m1_clones, specs="dil", var="gamma",at=list(dil=7.5)))
 # dil gamma.trend       SE df t.ratio p.value
 # 7.5   -3.84e-05 1.59e-05 22 -2.422  0.0241
 
 

# dil
summary(contrast(emmeans(m1_clones, specs="dil", at=list(dil=c(0,1), gamma=6500)),list(c(-1,1))))
# NOTE: Results may be misleading due to involvement in interactions
 # contrast estimate     SE df t.ratio p.value
 # c(-1, 1)    0.191 0.0225 22 8.466   <.0001  <<<<<<<<<<< use in paper

summary(contrast(emmeans(m1_clones, specs="dil", at=list(dil=c(0,1), gamma=6500)),list(c(-1,1))))$p.value
# NOTE: Results may be misleading due to involvement in interactions
# [1] 2.279117e-08 <<<<<<<<<<< use in paper



# Ix
summary(contrast(emmeans(m1_clones, specs=c("gamma","dil"), at=list(gamma=c(0,1),dil=c(0,1))),list(c(1,-1,-1,1))))
 # contrast        estimate       SE df t.ratio p.value
 # c(1, -1, -1, 1) 4.39e-06 6.37e-06 22 0.689   0.4982 <<<<<<<<<<< use in paper

# Results are given on the log (not the response) scale. 

# Alternative Ix using emtrends
summary(contrast(emtrends(m1_clones,specs="dil",var="gamma",at=list(dil=c(0,1))),method=list(c(-1,1))))
 # contrast estimate       SE df t.ratio p.value
 # c(-1, 1) 4.39e-06 6.37e-06 22 0.689   0.4982 







#-------------------------------------------------------------------------------------
#---------------- RH clones random effects -------------------------------------------
#-------------------------------------------------------------------------------------


anova(glmmTMB(RH_clones ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE),glmmTMB(RH_clones ~ gamma * dil, data = clone, family = nbinom2, REML=TRUE))
# Data: clone
# Models:
# glmmTMB(RH_clones ~ gamma * dil, data = clone, family = nbinom2, REML = TRUE): RH_clones ~ gamma * dil, zi=~0, disp=~1
# glmmTMB(RH_clones ~ gamma * dil + (1 | Pool), data = clone, family = nbinom2, REML = TRUE): RH_clones ~ gamma * dil + (1 | Pool), zi=~0, disp=~1
                                                                                           # Df    AIC    BIC  logLik deviance  Chisq Chi Df Pr(>Chisq)    
# glmmTMB(RH_clones ~ gamma * dil, data = clone, family = nbinom2, REML = TRUE)               5 387.34 393.23 -188.67   377.34                             
# glmmTMB(RH_clones ~ gamma * dil + (1 | Pool), data = clone, family = nbinom2, REML = TRUE)  6 378.41 385.48 -183.21   366.41 10.931      1  0.0009455 *** <<<<<<<<<<< use in paper
# ---
# Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1





performance::icc(glmmTMB(RH_clones ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE),adjusted=TRUE)
# # Intraclass Correlation Coefficient

     # Adjusted ICC: 0.691
  # Conditional ICC: 0.325

# Alternate
get_variance(m1_clones)$var.intercept["Pool"]/(get_variance(m1_clones)$var.intercept["Pool"]+get_variance(m1_clones)$var.residual)
     # Pool 
# 0.6912548 <<<<<<<<<<< use in paper

# within pool
1-get_variance(m1_clones)$var.intercept["Pool"]/(get_variance(m1_clones)$var.intercept["Pool"]+get_variance(m1_clones)$var.residual)
 # Pool 
# 0.3087452 <<<<<<<<<<< use in paper



# ------------------------------------------------------
# ----------- RH colonies fixed effects ----------------
# ------------------------------------------------------



m1_colonies <- glmmTMB(colonies ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE)


glht_gamma <- glht(m1_colonies, linfct = c("gamma + 7.5*gamma:dil == 0"))
glht_dil <- glht(m1_colonies, linfct = c("dil + (6500)*gamma:dil == 0"))
glht_omni <- glht(m1_colonies)

gamma_stat <- summary(glht_gamma,test = adjusted("none"))$test$tstat
dil_stat <- summary(glht_dil,test = adjusted("none"))$test$tstat
Ix_stat <- summary(glht_omni,test = adjusted("none"))$test$tstat["gamma:dil"]
gamma_coef <- summary(glht_gamma,test = adjusted("none"))$test$coefficients
dil_coef <- summary(glht_dil,test = adjusted("none"))$test$coefficients
Ix_coef <- summary(glht_omni,test = adjusted("none"))$test$coefficients["gamma:dil"]
 		
	
ans <- c(
 		gamma_coef,
 		dil_coef,
 		Ix_coef,
 		gamma_stat,
 		dil_stat,
 		Ix_stat,
 		2*pnorm(-abs(gamma_stat)),
 		2*pnorm(-abs(dil_stat)),
 		2*pnorm(-abs(Ix_stat))
 		)
 		
names(ans) <- c("gamma_coef","dil_coef","Ix_coef","gamma_Z","dil_Z","Ix_Z","gamma_P","dil_P","Ix_P")

ans
   # gamma_coef      dil_coef       Ix_coef       gamma_Z         dil_Z          Ix_Z       gamma_P         dil_P          Ix_P 
# -3.215416e-05  1.778113e-01  2.552567e-07 -2.819136e+00  1.106067e+01  5.594633e-02  4.815317e-03  1.946394e-28  9.553846e-01 



# emmeans

# gamma

summary(contrast(emmeans(m1_colonies, specs="gamma", at=list(gamma=c(0,1), dil=7.5)),list(c(-1,1))))
# contrast  estimate       SE df t.ratio p.value
 # c(-1, 1) -3.22e-05 1.14e-05 22 -2.819  0.0100  <<<<<<<<<<< use in paper
 
 

# dil
summary(contrast(emmeans(m1_colonies, specs="dil", at=list(dil=c(0,1), gamma=6500)),list(c(-1,1))))
 # contrast estimate     SE df t.ratio p.value
 # c(-1, 1)    0.178 0.0161 22 11.061  <.0001   <<<<<<<<<<< use in paper

summary(contrast(emmeans(m1_colonies, specs="dil", at=list(dil=c(0,1), gamma=6500)),list(c(-1,1))))$p.value
# NOTE: Results may be misleading due to involvement in interactions
# [1] 1.870479e-10 <<<<<<<<<<< use in paper



# Ix
summary(contrast(emmeans(m1_colonies, specs=c("gamma","dil"), at=list(gamma=c(0,1),dil=c(0,1))),list(c(1,-1,-1,1))))
 # contrast        estimate       SE df t.ratio p.value
 # c(1, -1, -1, 1) 2.55e-07 4.56e-06 22 0.056   0.9559  <<<<<<<<<<< use in paper

# Results are given on the log (not the response) scale. 






#-------------------------------------------------------------------------------------
#---------------- RH colonies random effects -------------------------------------------
#-------------------------------------------------------------------------------------


anova(glmmTMB(colonies ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE),glmmTMB(colonies ~ gamma * dil, data = clone, family = nbinom2, REML=TRUE))
# Data: clone
# Models:
# glmmTMB(colonies ~ gamma * dil, data = clone, family = nbinom2, REML = TRUE): colonies ~ gamma * dil, zi=~0, disp=~1
# glmmTMB(colonies ~ gamma * dil + (1 | Pool), data = clone, family = nbinom2, REML = TRUE): colonies ~ gamma * dil + (1 | Pool), zi=~0, disp=~1
                                                                                          # Df    AIC    BIC  logLik deviance Chisq Chi Df Pr(>Chisq)    
# glmmTMB(colonies ~ gamma * dil, data = clone, family = nbinom2, REML = TRUE)               5 400.14 406.03 -195.07   390.14                            
# glmmTMB(colonies ~ gamma * dil + (1 | Pool), data = clone, family = nbinom2, REML = TRUE)  6 383.94 391.01 -185.97   371.94  18.2      1  1.988e-05 *** <<<<<<<<< use in paper
# ---
# Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1


performance::icc(glmmTMB(colonies ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE))

# # Intraclass Correlation Coefficient

     # Adjusted ICC: 0.816
  # Conditional ICC: 0.391


# Alternate
 get_variance(m1_colonies)$var.intercept["Pool"]/(get_variance(m1_colonies)$var.intercept["Pool"]+get_variance(m1_colonies)$var.residual)
     # Pool 
# 0.8159605 <<<<<<<<< use in paper

# Within pools variance
1-get_variance(m1_colonies)$var.intercept["Pool"]/(get_variance(m1_colonies)$var.intercept["Pool"]+get_variance(m1_colonies)$var.residual)
     # Pool 
# 0.1840395 <<<<<<<<< use in paper



# ------------------------------------------------------
# ----------- RH reverts fixed effects ----------------
# ---------------------------------------------------------



m1_reverts <- glmmTMB(reverts ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE)


glht_gamma <- glht(m1_reverts, linfct = c("gamma + 7.5*gamma:dil == 0"))
glht_dil <- glht(m1_reverts, linfct = c("dil + (6500)*gamma:dil == 0"))
glht_omni <- glht(m1_reverts)

gamma_stat <- summary(glht_gamma,test = adjusted("none"))$test$tstat
dil_stat <- summary(glht_dil,test = adjusted("none"))$test$tstat
Ix_stat <- summary(glht_omni,test = adjusted("none"))$test$tstat["gamma:dil"]
gamma_coef <- summary(glht_gamma,test = adjusted("none"))$test$coefficients
dil_coef <- summary(glht_dil,test = adjusted("none"))$test$coefficients
Ix_coef <- summary(glht_omni,test = adjusted("none"))$test$coefficients["gamma:dil"]
 		
	
ans <- c(
 		gamma_coef,
 		dil_coef,
 		Ix_coef,
 		gamma_stat,
 		dil_stat,
 		Ix_stat,
 		2*pnorm(-abs(gamma_stat)),
 		2*pnorm(-abs(dil_stat)),
 		2*pnorm(-abs(Ix_stat))
 		)
 		
names(ans) <- c("gamma_coef","dil_coef","Ix_coef","gamma_Z","dil_Z","Ix_Z","gamma_P","dil_P","Ix_P")

ans
  # gamma_coef      dil_coef       Ix_coef       gamma_Z         dil_Z          Ix_Z       gamma_P         dil_P          Ix_P 
# -1.541001e-05  1.546525e-01 -9.116715e-06 -1.486182e+00  1.069436e+01 -2.204219e+00  1.372311e-01  1.081584e-26  2.750892e-02 




# emmeans

# gamma

summary(contrast(emmeans(m1_reverts, specs="gamma", at=list(gamma=c(0,1), dil=7.5)),list(c(-1,1))))
 # contrast  estimate       SE df t.ratio p.value
 # c(-1, 1) -1.54e-05 1.04e-05 22 -1.486  0.1514  <<<<<<<<<<< use in paper
 
 

# dil
summary(contrast(emmeans(m1_reverts, specs="dil", at=list(dil=c(0,1), gamma=6500)),list(c(-1,1))))
 # contrast estimate     SE df t.ratio p.value
 # c(-1, 1)    0.155 0.0145 22 10.694  <.0001    <<<<<<<<<<< use in paper

summary(contrast(emmeans(m1_reverts, specs="dil", at=list(dil=c(0,1), gamma=6500)),list(c(-1,1))))$p.value
# NOTE: Results may be misleading due to involvement in interactions
# [1] 3.510276e-10 <<<<<<<<<<< use in paper



# Ix
summary(contrast(emmeans(m1_reverts, specs=c("gamma","dil"), at=list(gamma=c(0,1),dil=c(0,1))),list(c(1,-1,-1,1))))
 # contrast         estimate       SE df t.ratio p.value
 # c(1, -1, -1, 1) -9.12e-06 4.14e-06 22 -2.204  0.0383   <<<<<<<<<<< use in paper

# Results are given on the log (not the response) scale. 









#-------------------------------------------------------------------------------------
#---------------- RH reverts random effects -------------------------------------------
#-------------------------------------------------------------------------------------


anova(glmmTMB(reverts ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE),glmmTMB(reverts ~ gamma * dil, data = clone, family = nbinom2, REML=TRUE))

# Data: clone
# Models:
# glmmTMB(reverts ~ gamma * dil, data = clone, family = nbinom2, REML = TRUE): reverts ~ gamma * dil, zi=~0, disp=~1
# glmmTMB(reverts ~ gamma * dil + (1 | Pool), data = clone, family = nbinom2, REML = TRUE): reverts ~ gamma * dil + (1 | Pool), zi=~0, disp=~1
                                                                                         # Df    AIC    BIC  logLik deviance Chisq Chi Df Pr(>Chisq)    
# glmmTMB(reverts ~ gamma * dil, data = clone, family = nbinom2, REML = TRUE)               5 339.12 345.01 -164.56   329.12                            
# glmmTMB(reverts ~ gamma * dil + (1 | Pool), data = clone, family = nbinom2, REML = TRUE)  6 318.44 325.51 -153.22   306.44 22.68      1  1.913e-06 *** <<<<<<< use in paper
# ---
# Signif. codes:  0 ‘***’ 0.001 ‘**’ 0.01 ‘*’ 0.05 ‘.’ 0.1 ‘ ’ 1


performance::icc(glmmTMB(reverts ~ gamma * dil + (1|Pool), data = clone, family = nbinom2, REML=TRUE))

# # Intraclass Correlation Coefficient

     # Adjusted ICC: 0.857
  # Conditional ICC: 0.478


# Alternate
get_variance(m1_reverts)$var.intercept["Pool"]/(get_variance(m1_reverts)$var.intercept["Pool"]+get_variance(m1_reverts)$var.residual)
     # Pool 
# 0.8570146 <<<<<<<<< use in paper


# within pools variance
1-get_variance(m1_reverts)$var.intercept["Pool"]/(get_variance(m1_reverts)$var.intercept["Pool"]+get_variance(m1_reverts)$var.residual)
# Pool 
# 0.1429854 <<<<<<<<< use in paper






# ---------------------------------------------------------------------
#------ fold increase RH clones in dil 10 compared with dil 5 --------
# ---------------------------------------------------------------------

# This approach uses all data as independent and reflects boxplots in paper.

mean(clone[clone$dil == 10,]$RH_clones)/mean(clone[clone$dil == 5,]$RH_clones)
# [1] 2.646783 <<<<<<<<<< use in paper

# Using this paper http://www.stat.cmu.edu/~hseltman/files/ratio.pdf
# sd of ratio is:

meanA <- mean(clone[clone$dil == 10,]$RH_clones)
meanB <- mean(clone[clone$dil == 5,]$RH_clones)
varA <- var(clone[clone$dil == 10,]$RH_clones)
varB <- var(clone[clone$dil == 5,]$RH_clones)
covAB <- cov(clone[clone$dil == 10,]$RH_clones,clone[clone$dil == 5,]$RH_clones)

sd <- sqrt((meanA^2/meanB^2)*((varA)/(meanA^2) - 2* covAB/(meanA*meanB) + (varB)/(meanB^2)))

sd
# [1] 1.15945

sd/sqrt(12)
# [1] 0.3347045 <<<<<<<<<< use in paper





# -------------------------------------------------------------------------------
#----- correlations between total colonies, revertants and rh clones ------------
# -------------------------------------------------------------------------------


cor(clone$colonies,clone$RH_clones)
# [1] 0.9908293 <<<<<< use in paper

cor.test(clone$colonies,clone$RH_clones)

	# Pearson's product-moment correlation <<<<<< use in paper

# data:  clone$colonies and clone$RH_clones
# t = 34.395, df = 22, p-value < 2.2e-16
# alternative hypothesis: true correlation is not equal to 0
# 95 percent confidence interval:
 # 0.9785607 0.9960911
# sample estimates:
      # cor 
# 0.9908293 

cor.test(clone$colonies,clone$RH_clones)$p.value
# [1] 1.274203e-20 <<<<<< use in paper


cor(clone$reverts,clone$RH_clones)
# [1] 0.8478287 <<<<<< use in paper

cor.test(clone$reverts,clone$RH_clones)

	# Pearson's product-moment correlation <<<<<< use in paper

# data:  clone$reverts and clone$RH_clones
# t = 7.4993, df = 22, p-value = 1.697e-07
# alternative hypothesis: true correlation is not equal to 0
# 95 percent confidence interval:
 # 0.6754402 0.9323509
# sample estimates:
      # cor 
# 0.8478287

cor.test(clone$reverts,clone$RH_clones)$p.value
# [1] 1.696652e-07 <<<<<< use in paper





















