# --------- read files --------------

clone <- read.table("clone.txt",sep="\t",stringsAsFactors=FALSE,header=TRUE)

dim(clone)
# [1] 24  6

head(clone)
  # Pool gamma dil colonies reverts RH_clones
# 1    1  3000   5   545.00      95    450.00
# 2    1  3000  10  1045.00     260    785.00
# 3    1 10000   5   536.25     135    401.25
# 4    1 10000  10   770.00     210    560.00
# 5    2  3000   5   842.50     145    697.50
# 6    2  3000  10  2042.50     380   1662.50

#------- start plottng ----------------------

library(ggplot2)
library(cowplot)


# from https://stackoverflow.com/questions/8197559/emulate-ggplot2-default-color-palette
# function for default ggplot2 colors

gg_color_hue <- function(n) {
  hues = seq(15, 375, length = n + 1)
  hcl(h = hues, l = 65, c = 100)[1:n]
}

theme2 <- theme(
	plot.margin = unit(c(t=0.8,r=0.8,b=0.8,l=0.8), "cm"),
	panel.grid.major = element_blank(), 
	panel.grid.minor = element_blank(), 
	panel.background = element_blank(), 
	legend.position="none", 
	legend.key=element_blank(),
	axis.line.x = element_line(colour = "black", size = 0.1), 
	axis.line.y = element_line(colour = "black", size = 0.1), 
	axis.ticks = element_line(colour = "black", size = 0.1),
	axis.text=element_text(size=12), #numbers on tick marks of x and y axes
	axis.title=element_text(size=14), #titles of x and y axes
	axis.title.y=element_text(margin=margin(0,14,0,0)), #moves y axis title by adding margin space to bottom
	axis.title.x=element_text(margin=margin(8,0,0,0)),  #moves x axis title by adding margin space to top
	plot.title = element_text(size=0, face="bold", hjust = -0.14), #can provide "A","B", by ggtitle, but used plot_grid wch can shift more left
	plot.subtitle = element_text(size=0, face="plain", hjust = 0.5) #hjust shifts right
	)
	
	
size_point <- 0.3
size_hline <- 0.1


# ---------- RH clones vs pool -------------

clone_pool <- clone

clone_pool$Pool <- as.numeric(as.factor(clone_pool$Pool))
clone_pool$jitter <- jitter(clone_pool$Pool,0.5)
clone_pool$Pool <- as.factor(clone_pool$Pool)


n <- length(unique(clone_pool$dil))
colores_1 <- gg_color_hue(n)


pA1 <- ggplot() + 
	theme2 +
	geom_boxplot(data=clone_pool, aes(x=Pool, y=RH_clones),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_pool$jitter, 
				y=RH_clones, 
				colour=as.factor(clone_pool$dil),
				shape=as.factor(clone_pool$gamma)
				)
			) +
	scale_color_manual(
		values=colores_1,
		name ="Dil", 
		labels=c(5,10)
		) +
 	scale_shape_manual(
 		values=c(1,2),
		name =expression("Dose \n(Gy)"), 
		labels=c(30,100)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=2,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
 		legend.position = "right", 
 		legend.margin=margin(t=15,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=15,r=-10,b=0,l=-5,unit = "pt"),
 		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
 	scale_x_discrete(breaks = c(1,2,3,4,5,6), labels = c(1,2,3,4,5,6)) +
 	# ggtitle("") + 
	xlab("Pool") + 
	ylab(expression("RH clones")) + 
	labs(subtitle="")
print(pA1)

# ---------- RH clones vs radiation dose -------------

clone_rad <- clone

clone_rad$gamma <- as.numeric(as.factor(clone_rad$gamma))
clone_rad$jitter <- jitter(clone_rad$gamma,0.5)
clone_rad$gamma <- as.factor(clone_rad$gamma)


n <- length(unique(clone_rad$gamma))
colores_2 <- gg_color_hue(n)


pA2 <- ggplot() + 
	theme2 +
	theme(axis.line.y=element_blank(),axis.title.y=element_blank(),axis.text.y=element_blank(), axis.ticks.y=element_blank()) +
	geom_boxplot(data=clone_rad, aes(x=gamma, y=RH_clones),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_rad$jitter, 
				y=RH_clones, 
				colour=as.factor(clone_rad$dil),
				shape=as.factor(clone_rad$Pool)
				)
			) +
	scale_color_manual(
		values=colores_2,
		name ="Dil", 
		labels=c(5,10)
		) +
 	scale_shape_manual(
 		values=c(1,0,2,5,6,3),
		name ="Pool", 
		labels=c(1,2,3,4,5,6)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=6,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
 		legend.position = "right",
 		legend.margin=margin(t=5,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=5,r=-10,b=0,l=-5,unit = "pt"), 
 		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
 	scale_x_discrete(breaks = c(1,2), labels = c(30,100)) +
 	# ggtitle("") + 
	xlab("Radiation dose (Gy)") + 
	ylab(expression("RH clones")) + 
	labs(subtitle="")
print(pA2)

# ---------- RH clones vs dilution -------------

clone_dil <- clone

clone_dil$dil <- as.numeric(as.factor(clone_dil$dil))
clone_dil$jitter <- jitter(clone_dil$dil,0.5)
clone_dil$dil <- as.factor(clone_dil$dil)


n <- length(unique(clone_dil$dil))
colores_3 <- gg_color_hue(n)


pA3 <- ggplot() + 
	theme2 +
	theme(axis.line.y=element_blank(),axis.title.y=element_blank(),axis.text.y=element_blank(), axis.ticks.y=element_blank()) +
	geom_boxplot(data=clone_dil, aes(x=dil, y=RH_clones),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_dil$jitter, 
				y=RH_clones, 
				colour=as.factor(clone_dil$gamma),
				shape=as.factor(clone_dil$Pool)
				)
			) +
	scale_color_manual(
		values=colores_3,
		name =expression("Dose \n(Gy)"), 
		labels=c(30,100)
		) +
 	scale_shape_manual(
 		values=c(1,0,2,5,6,3),
		name ="Pool", 
		labels=c(1,2,3,4,5,6)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=6,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
		legend.position = "right",
		legend.margin=margin(t=5,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=5,r=-10,b=0,l=-5,unit = "pt"),
		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
    scale_x_discrete(breaks = c(1,2), labels = c(5,10)) +
 	# ggtitle("") + 
	xlab("Dilution") + 
	ylab(expression("RH clones")) + 
	labs(subtitle="")
print(pA3)

# ---------- Colonies vs pool -------------

clone_pool_2 <- clone

clone_pool_2$Pool <- as.numeric(as.factor(clone_pool_2$Pool))
clone_pool_2$jitter <- jitter(clone_pool_2$Pool,0.5)
clone_pool_2$Pool <- as.factor(clone_pool_2$Pool)


n <- length(unique(clone_pool_2$dil))
colores_1 <- gg_color_hue(n)


pB1 <- ggplot() + 
	theme2 +
	geom_boxplot(data=clone_pool_2, aes(x=Pool, y=colonies),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_pool_2$jitter, 
				y=colonies, 
				colour=as.factor(clone_pool_2$dil),
				shape=as.factor(clone_pool_2$gamma)
				)
			) +
	scale_color_manual(
		values=colores_1,
		name ="Dil", 
		labels=c(5,10)
		) +
 	scale_shape_manual(
 		values=c(1,2),
		name =expression("Dose \n(Gy)"), 
		labels=c(30,100)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=2,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
 		legend.position = "right", 
 		legend.margin=margin(t=15,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=15,r=-10,b=0,l=-5,unit = "pt"),
 		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
 	scale_x_discrete(breaks = c(1,2,3,4,5,6), labels = c(1,2,3,4,5,6)) +
 	# ggtitle("") + 
	xlab("Pool") + 
	ylab(expression("Colonies")) + 
	labs(subtitle="")
print(pB1)

# ---------- Colonies vs radiation dose -------------

clone_rad_2 <- clone

clone_rad_2$gamma <- as.numeric(as.factor(clone_rad_2$gamma))
clone_rad_2$jitter <- jitter(clone_rad_2$gamma,0.5)
clone_rad_2$gamma <- as.factor(clone_rad_2$gamma)


n <- length(unique(clone_rad_2$gamma))
colores_2 <- gg_color_hue(n)


pB2 <- ggplot() + 
	theme2 +
	theme(axis.line.y=element_blank(),axis.title.y=element_blank(),axis.text.y=element_blank(), axis.ticks.y=element_blank()) +
	geom_boxplot(data=clone_rad_2, aes(x=gamma, y=colonies),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_rad_2$jitter, 
				y=colonies, 
				colour=as.factor(clone_rad_2$dil),
				shape=as.factor(clone_rad_2$Pool)
				)
			) +
	scale_color_manual(
		values=colores_2,
		name ="Dil", 
		labels=c(5,10)
		) +
 	scale_shape_manual(
 		values=c(1,0,2,5,6,3),
		name ="Pool", 
		labels=c(1,2,3,4,5,6)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=6,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
 		legend.position = "right",
 		legend.margin=margin(t=5,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=5,r=-10,b=0,l=-5,unit = "pt"), 
 		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
 	scale_x_discrete(breaks = c(1,2), labels = c(30,100)) +
 	# ggtitle("") + 
	xlab("Radiation dose (Gy)") + 
	ylab(expression("Colonies")) + 
	labs(subtitle="")
print(pB2)

# ---------- Colonies vs dilution -------------

clone_dil_2 <- clone

clone_dil_2$dil <- as.numeric(as.factor(clone_dil_2$dil))
clone_dil_2$jitter <- jitter(clone_dil_2$dil,0.5)
clone_dil_2$dil <- as.factor(clone_dil_2$dil)


n <- length(unique(clone_dil_2$dil))
colores_3 <- gg_color_hue(n)


pB3 <- ggplot() + 
	theme2 +
	theme(axis.line.y=element_blank(),axis.title.y=element_blank(),axis.text.y=element_blank(), axis.ticks.y=element_blank()) +
	geom_boxplot(data=clone_dil_2, aes(x=dil, y=colonies),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_dil_2$jitter, 
				y=colonies, 
				colour=as.factor(clone_dil_2$gamma),
				shape=as.factor(clone_dil_2$Pool)
				)
			) +
	scale_color_manual(
		values=colores_3,
		name =expression("Dose \n(Gy)"), 
		labels=c(30,100)
		) +
 	scale_shape_manual(
 		values=c(1,0,2,5,6,3),
		name ="Pool", 
		labels=c(1,2,3,4,5,6)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=6,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
		legend.position = "right",
		legend.margin=margin(t=5,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=5,r=-10,b=0,l=-5,unit = "pt"),
		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
	scale_x_discrete(breaks = c(1,2), labels = c(5,10)) +
 	# ggtitle("") + 
	xlab("Dilution") + 
	ylab(expression("Colonies")) + 
	labs(subtitle="")
print(pB3)



# ---------- Revertants vs pool -------------

clone_pool_3 <- clone

clone_pool_3$Pool <- as.numeric(as.factor(clone_pool_3$Pool))
clone_pool_3$jitter <- jitter(clone_pool_3$Pool,0.5)
clone_pool_3$Pool <- as.factor(clone_pool_3$Pool)


n <- length(unique(clone_pool_3$dil))
colores_1 <- gg_color_hue(n)


pC1 <- ggplot() + 
	theme2 +
	geom_boxplot(data=clone_pool_3, aes(x=Pool, y=reverts),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_pool_3$jitter, 
				y=reverts, 
				colour=as.factor(clone_pool_3$dil),
				shape=as.factor(clone_pool_3$gamma)
				)
			) +
	scale_color_manual(
		values=colores_1,
		name ="Dil", 
		labels=c(5,10)
		) +
 	scale_shape_manual(
 		values=c(1,2),
		name =expression("Dose \n(Gy)"), 
		labels=c(30,100)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=2,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
 		legend.position = "right", 
 		legend.margin=margin(t=15,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=15,r=-10,b=0,l=-5,unit = "pt"),
 		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
 	scale_x_discrete(breaks = c(1,2,3,4,5,6), labels = c(1,2,3,4,5,6)) +
 	# ggtitle("") + 
	xlab("Pool") + 
	ylab(expression("Revertants")) + 
	labs(subtitle="")
print(pC1)

# ---------- Revertants vs radiation dose -------------

clone_rad_3 <- clone

clone_rad_3$gamma <- as.numeric(as.factor(clone_rad_3$gamma))
clone_rad_3$jitter <- jitter(clone_rad_3$gamma,0.5)
clone_rad_3$gamma <- as.factor(clone_rad_3$gamma)


n <- length(unique(clone_rad_3$gamma))
colores_2 <- gg_color_hue(n)


pC2 <- ggplot() + 
	theme2 +
	theme(axis.line.y=element_blank(),axis.title.y=element_blank(),axis.text.y=element_blank(), axis.ticks.y=element_blank()) +
	geom_boxplot(data=clone_rad_3, aes(x=gamma, y=reverts),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_rad_3$jitter, 
				y=reverts, 
				colour=as.factor(clone_rad_3$dil),
				shape=as.factor(clone_rad_3$Pool)
				)
			) +
	scale_color_manual(
		values=colores_2,
		name ="Dil", 
		labels=c(5,10)
		) +
 	scale_shape_manual(
 		values=c(1,0,2,5,6,3),
		name ="Pool", 
		labels=c(1,2,3,4,5,6)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=6,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
 		legend.position = "right",
 		legend.margin=margin(t=5,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=5,r=-10,b=0,l=-5,unit = "pt"), 
 		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
 	scale_x_discrete(breaks = c(1,2), labels = c(30,100)) +
 	# ggtitle("") + 
	xlab("Radiation dose (Gy)") + 
	ylab(expression("Revertants")) + 
	labs(subtitle="")
print(pC2)

# ---------- Revertants vs dilution -------------

clone_dil_3 <- clone

clone_dil_3$dil <- as.numeric(as.factor(clone_dil_3$dil))
clone_dil_3$jitter <- jitter(clone_dil_3$dil,0.5)
clone_dil_3$dil <- as.factor(clone_dil_3$dil)


n <- length(unique(clone_dil_3$dil))
colores_3 <- gg_color_hue(n)


pC3 <- ggplot() + 
	theme2 +
	theme(axis.line.y=element_blank(),axis.title.y=element_blank(),axis.text.y=element_blank(), axis.ticks.y=element_blank()) +
	geom_boxplot(data=clone_dil_3, aes(x=dil, y=reverts),width=0.5,notch=FALSE,lwd=0.1,fatten = 4,outlier.shape=NA) +
	geom_point(
		size=1.0,
		stroke=0.4,
		data = clone, 
			aes(
				x=clone_dil_3$jitter, 
				y=reverts, 
				colour=as.factor(clone_dil_3$gamma),
				shape=as.factor(clone_dil_3$Pool)
				)
			) +
	scale_color_manual(
		values=colores_3,
		name =expression("Dose \n(Gy)"), 
		labels=c(30,100)
		) +
 	scale_shape_manual(
 		values=c(1,0,2,5,6,3),
		name ="Pool", 
		labels=c(1,2,3,4,5,6)
		) +
 	guides(
 		colour = guide_legend(override.aes = list(fill=NA,shape=1,size=1),nrow=2,ncol=1,byrow=TRUE,order=1,title.position = "top", title.vjust = 1),
 		shape = guide_legend(override.aes = list(fill=NA,size=1,colour="grey40"),nrow=6,ncol=1,byrow=TRUE,order=2,title.position = "top", title.vjust = 1)
 		) +
	theme(
		legend.position = "right",
		legend.margin=margin(t=5,r=0,b=0,l=-5,unit = "pt"),
 		legend.box.margin=margin(t=5,r=-10,b=0,l=-5,unit = "pt"),
		legend.key.height = unit(0.1, "cm"),
		legend.key.width = unit(0.3, "cm"),
 		legend.spacing.y = unit(0.1, 'cm'),
 		legend.spacing.x = unit(0.1, 'cm'),
 		legend.title = element_text(size = 11), 
 		legend.text = element_text(size = 10),
 		legend.title.align=0.0
 		) +
	  scale_x_discrete(breaks = c(1,2), labels = c(5,10)) +
 	# ggtitle("") + 
	xlab("Dilution") + 
	ylab(expression("Revertants")) + 
	labs(subtitle="")
print(pC3)

#------------------Make file --------------------------


prow <- plot_grid(
			pA1, 
			pA2,
			pA3, 
			pB1, 
			pB2,
			pB3, 
			pC1, 
			pC2,
			pC3, 
			labels=c("A", "","","B", "","","C", "",""), 
			ncol = 3, 
			nrow = 3, 
			label_size = 16, 
			rel_widths = c(2, 1, 1)
			)
			
pdf("Clone_nos_3.pdf",width=7.5,height= 10)
prow
dev.off()





# prow <- plot_grid(
			# pA1+theme(legend.position="none"), 
			# pA2+theme(legend.position="none"),
			# pA3+theme(legend.position="none"), 
			# pA1+theme(legend.position="none"), 
			# pA2+theme(legend.position="none"),
			# pA3+theme(legend.position="none"), 
			# pA1+theme(legend.position="none"), 
			# pA2+theme(legend.position="none"),
			# pA3+theme(legend.position="none"), 
			# labels=c("A", "B","C","D", "E","F","G", "H","I"), 
			# ncol = 3, 
			# nrow = 3, 
			# label_size = 12, 
			# rel_widths = c(2.45, 1, 1)
			# )
			
# pdf("Clone_nos_3.pdf",width=7.5,height= 10)
# prow
# dev.off()

# legend_a <- get_legend(pA1+theme(legend.position="bottom"))	
# legend_b <- get_legend(pA2+theme(legend.position="bottom"))	
# legend_c <- get_legend(pA3+theme(legend.position="bottom"))	

# legend_row <- plot_grid(
				# legend_a,
				# legend_b,
				# legend_c,
				# rel_widths = c(2.5, 1, 1)
			# )


# p <- plot_grid(prow,legend_row,ncol=1,rel_heights=c(1,0.05))		
			
# pdf("Clone_nos_3.pdf",width=7.5,height= 10)
# p
# dev.off()

#-------------------------------------------------------






























