require(BayesMendel)
modified_brcapro <- function (family, counselee.id = 1, race = "Unknown", germline.testing = NULL, 
                              marker.testing = NULL, oophorectomy = NULL, mastectomy = NULL, 
                              params = brcaparams(), print = FALSE, imputeAges = FALSE, imputeRelatives = FALSE, 
                              mrate1, mrate2, f_index, m_index, gene, mod) 
  # mrate1: de novo mutation rate of BRCA1, mrate2: de novo mutation rate of BRCA2; f_index: index of the counselee's father; m_index: index of the counselee's mother; gene: {1,2}, 1 = BRCA1, 2 = BRCA2; mod: {0,1,2}, 0 = no modification; 1: modify the likelihood of BRCA1, 2: BRCA2(2); fout: name of output file 
{
  warnmsg = ""
  if (imputeRelatives == TRUE & imputeAges == FALSE) {
    imputeAges = TRUE
    warnmsg = paste(warnmsg, "Warning: imputeAges was input as false, but has been set to TRUE.  If imputeRelatives=TRUE then by default imputeAges must also be TRUE.")
  }
  if (nchar(warnmsg) > 0) {
    print(warnmsg)
  }
  family <- CheckFamStructure("brcapro", family, counselee.id, 
                              germline.testing, marker.testing, oophorectomy, mastectomy, 
                              imputeAges, imputeRelatives, params)
  if (is.character(family)) {
    return(family)
  }
  if (sum(family$Twins) > 0) {
    inputfamily <- family
    if (!is.null(germline.testing)) {
      inputfamily <- data.frame(inputfamily, germline.testing)
    }
    if (!is.null(marker.testing)) {
      inputfamily <- data.frame(inputfamily, marker.testing)
    }
    if (!is.null(oophorectomy)) {
      inputfamily <- data.frame(inputfamily, oophorectomy)
    }
    if (!is.null(mastectomy)) {
      inputfamily <- data.frame(inputfamily, mastectomy)
    }
  }
  originalcounselee.id <- counselee.id
  if (family$Twins[family$ID == counselee.id] > 0) {
    twins <- family[family$Twins == family$Twins[family$ID == 
                                                   counselee.id], ]
    counselee.id <- twins$ID[1]
  }
  proband.current.age <- max(family[which(family$ID == counselee.id), 
                                    c("AgeBreast", "AgeOvary", "AgeBreastContralateral")])
  nonAJ <- list(c(1 - 0.0005829, 0.0005829), c(1 - 0.000676, 
                                               0.000676))
  AJ <- list(c(1 - 0.00609756097560976, 0.00609756097560976), 
             c(1 - 0.00679723502304147, 0.00679723502304147))
  Italian <- list(c(1 - 0.001673779, 0.001673779), c(1 - 0.00132622, 
                                                     0.00132622))
  Other <- params$allef
  allef <- list()
  if (any(family$ethnic == "AJ" & !is.na(family$ethnic))) 
    allef["AJ"] <- list(AJ)
  if (any(family$ethnic == "nonAJ" & !is.na(family$ethnic))) 
    allef["nonAJ"] <- list(nonAJ)
  if (any(family$ethnic == "Italian" & !is.na(family$ethnic))) 
    allef["Italian"] <- list(Italian)
  if (any(family$ethnic == "Other" & !is.na(family$ethnic))) 
    allef["Other"] <- list(Other)
  if (race == "Unknown") {
    params$penetrance <- params$penetrance
  }
  else {
    if (ethnic == "AJ") {
      params$penetrance$fFX[, "B00"] <-BRCApenet.AJ.2001.2008$fFX[, 
                                                                  "B00"]
      params$penetrance$fFY[, "B00"] <- BRCApenet.AJ.2001.2008$fFY[, 
                                                                   "B00"]
      params$penetrance$fMX[, "B00"] <- BRCApenet.AJ.2001.2008$fMX[, 
                                                                   "B00"]
      params$penetrance$fMY[, "B00"] <- BRCApenet.AJ.2001.2008$fMY[, 
                                                                   "B00"]
    }
    else {
      if (race == "nonAJ") {
        params$penetrance$fFX[, "B00"] <- BRCApenet.nonAJ.2001.2008$fFX[, 
                                                                        "B00"]
        params$penetrance$fFY[, "B00"] <- BRCApenet.nonAJ.2001.2008$fFY[, 
                                                                        "B00"]
        params$penetrance$fMX[, "B00"] <- BRCApenet.nonAJ.2001.2008$fMX[, 
                                                                        "B00"]
        params$penetrance$fMY[, "B00"] <- BRCApenet.nonAJ.2001.2008$fMY[, 
                                                                        "B00"]
      }
      else {
        if (race == "Hispanic") {
          params$penetrance$fFX[, "B00"] <- BRCAbaseline.race.2008$fFX[, 
                                                                       "Hispanic"]
          params$penetrance$fFY[, "B00"] <- BRCAbaseline.race.2008$fFY[, 
                                                                       "Hispanic"]
          params$penetrance$fMX[, "B00"] <- BRCAbaseline.race.2008$fMX[, 
                                                                       "Hispanic"]
          params$penetrance$fMY[, "B00"] <- BRCAbaseline.race.2008$fMY[, 
                                                                       "Hispanic"]
        }
        else {
          if (race == "NativeAmerican") {
            params$penetrance$fFX[, "B00"] <- BRCAbaseline.race.2008$fFX[, 
                                                                         "NativeAmerican"]
            params$penetrance$fFY[, "B00"] <- BRCAbaseline.race.2008$fFY[, 
                                                                         "NativeAmerican"]
            params$penetrance$fMX[, "B00"] <- BRCAbaseline.race.2008$fMX[, 
                                                                         "NativeAmerican"]
            params$penetrance$fMY[, "B00"] <- BRCAbaseline.race.2008$fMY[, 
                                                                         "NativeAmerican"]
          }
          else {
            if (race == "White") {
              params$penetrance$fFX[, "B00"] <- BRCAbaseline.race.2008$fFX[, 
                                                                           "White"]
              params$penetrance$fFY[, "B00"] <- BRCAbaseline.race.2008$fFY[, 
                                                                           "White"]
              params$penetrance$fMX[, "B00"] <- BRCAbaseline.race.2008$fMX[, 
                                                                           "White"]
              params$penetrance$fMY[, "B00"] <- BRCAbaseline.race.2008$fMY[, 
                                                                           "White"]
            }
          }
        }
      }
    }
  }
  psize <- dim(family)[1]
  nloci <- 2
  ngen <- 3^nloci
  maxages <- apply(family[, c("AgeBreast", "AgeOvary", "AgeBreastContralateral")], 
                   1, max)
  sex <- family$Gender
  currfamily <- family
  if (sum(family$Twins) > 0) {
    currfamily <- inputfamily
  }
  femaleproband <- ifelse(family$Gender[family$ID == counselee.id] == 
                            0, 1, 0)
  if (family$AffectedBreast[family$ID == counselee.id] > 0) {
    firstdx.under40 <- ifelse(family$AgeBreast[family$ID == 
                                                 counselee.id] < 40, 1, 0)
    agedx <- family$AgeBreast[family$ID == counselee.id]
    if (femaleproband == 1 & firstdx.under40 == 1) {
      Breast <- params$CBCpenetrance$fFX.Under40
      Ovarian <- params$penetrance$fFY
    }
    if (femaleproband == 1 & firstdx.under40 == 0) {
      Breast <- params$CBCpenetrance$fFX.Over40
      Ovarian <- params$penetrance$fFY
    }
    if (femaleproband == 0 & firstdx.under40 == 1) {
      Breast <- params$CBCpenetrance$fMX.Under40
      Ovarian <- params$penetrance$fMY
    }
    if (femaleproband == 0 & firstdx.under40 == 0) {
      Breast <- params$CBCpenetrance$fMX.Over40
      Ovarian <- params$penetrance$fMY
    }
    CBC <- matrix(0, nrow = 110, ncol = 9)
    for (cccc in 1:ncol(Breast)) {
      CBC[agedx:110, cccc] <- Breast[1:length(agedx:110), 
                                     cccc]
    }
  }
  else {
    if (femaleproband == 1) {
      CBC <- params$penetrance$fFX
      Ovarian <- params$penetrance$fFY
    }
    if (femaleproband == 0) {
      CBC <- params$penetrance$fMX
      Ovarian <- params$penetrance$fMY
    }
  }
  CBRCApenet <- list(CBC, Ovarian)
  names(CBRCApenet) <- c("fX", "fY")
  colnames(CBRCApenet$fX) <- colnames(CBRCApenet$fY) <- colnames(params$penetrance$fFX)
  if (ncol(params$penetrance[[1]]) == 9) {
    params$penetrance <- MakePenetPostIntervention(params$penetrance, 
                                                   params$PostOophorectomyHR, params$PostMastectomyHR, 
                                                   contralateral = FALSE)
  }
  else {
    if (ncol(params$penetrance[[1]]) != 27) {
      stop("Penetrance matrices must have 9 columns, or 27 if they include interventions")
    }
  }
  if (ncol(params$CBCpenetrance[[1]]) == 9) {
    params$CBCpenetrance <- MakePenetPostIntervention(params$CBCpenetrance, 
                                                      params$PostOophorectomyHR, params$PostMastectomyHR, 
                                                      contralateral = TRUE)
  }
  else {
    if (ncol(params$CBCpenetrance[[1]]) != 27) {
      stop("Penetrance matrices must have 9 columns, or 18 if they include interventions")
    }
  }
  missingage = any(family$AgeBreast == 1 | family$AgeOvary == 
                     1 | (family$AgeBreastContralateral == 1 & family$AffectedBreast == 
                            2))
  if (missingage & imputeAges == FALSE) {
    agewarning = "Warning: Age imputation has been turned off, but there are unknown ages of some unaffected family members. You may want to get more information about family member ages and re-run the calculation, or set imputeAges=TRUE."
    post = runPeeling(family = family, params = params, ngen = ngen, 
                      oophorectomy = oophorectomy, mastectomy = mastectomy, 
                      germline.testing = germline.testing, marker.testing = marker.testing, 
                      psize = psize, counselee.id = counselee.id, allef = allef,mod=mod,gene=gene,nloci=nloci,mrate1=mrate1,
                      mrate2=mrate2, f_index=f_index,m_index=m_index)
  }
  if (missingage & imputeAges == TRUE) {
    agewarning = "Warning: Unknown ages of some unaffected and affected family members have been imputed.  You may want to get more information about family member ages and re-run the calculation."
    ifamily = ImputeAge(fff = family, params = params, model = "brcapro")
    postList = NULL
    nIter = params$nIter
    if (length(ifamily$mem_bc) > 0 | length(ifamily$mem_oc) > 
        0 | length(ifamily$mem_bcc) > 0 | length(ifamily$mem_mast) > 
        0 | length(ifamily$mem_ooph) > 0) {
      for (iIter in 1:nIter) {
        nf = ifamily$fff
        noophorectomy = oophorectomy
        nmastectomy = mastectomy
        if (length(ifamily$mem_bc) > 0) {
          nf$AgeBreast[ifamily$mem_bc] = ifamily$age_bc[iIter, 
                                                        ifamily$mem_bc]
        }
        if (length(ifamily$mem_oc) > 0) {
          nf$AgeOvary[ifamily$mem_oc] <- ifamily$age_oc[iIter, 
                                                        ifamily$mem_oc]
        }
        if (length(ifamily$mem_bcc) > 0) {
          nf$AgeBreastContralateral[ifamily$mem_bcc] <- ifamily$age_bcc[iIter, 
                                                                        ifamily$mem_bcc]
        }
        if (length(ifamily$mem_mast) > 0) {
          nf$AgeMastectomy[ifamily$mem_mast] = ifamily$age_mast[iIter, 
                                                                ifamily$mem_mast]
          nmastectomy$AgeMastectomy[ifamily$mem_mast] = ifamily$age_mast[iIter, 
                                                                         ifamily$mem_mast]
        }
        if (length(ifamily$mem_ooph) > 0) {
          nf$AgeOophorectomy[ifamily$mem_ooph] = ifamily$age_ooph[iIter, 
                                                                  ifamily$mem_ooph]
          noophorectomy$AgeOophorectomy[ifamily$mem_ooph] = ifamily$age_ooph[iIter, 
                                                                             ifamily$mem_ooph]
        }
        #postList = rbind(postList, runPeeling(family = nf, 
        #                                      params = params, ngen = ngen, oophorectomy = noophorectomy, 
        #                                      mastectomy = nmastectomy, germline.testing = germline.testing, 
        #                                      marker.testing = marker.testing, psize = psize, 
        #                                      counselee.id = counselee.id, allef = allef))
        postList = rbind(postList, runPeeling(family = nf, params = params, ngen = ngen, 
                                              oophorectomy = oophorectomy, mastectomy = mastectomy, 
                                              germline.testing = germline.testing, marker.testing = marker.testing, 
                                              psize = psize, counselee.id = counselee.id, allef = allef,mod=mod,gene=gene,nloci=nloci,mrate1=mrate1,
                                              mrate2=mrate2, f_index=f_index,m_index=m_index))
      }
      post = apply(postList, 2, mean)
    }
    if (length(ifamily$mem_bc) == 0 & length(ifamily$mem_oc) == 
        0 & length(ifamily$mem_bcc) == 0 & length(ifamily$mem_mast) == 
        0 & length(ifamily$mem_ooph) == 0) {
      #post = runPeeling(family = ifamily$fff, params = params, 
      #                  ngen = ngen, oophorectomy = oophorectomy, mastectomy = mastectomy, 
      #                  germline.testing = germline.testing, marker.testing = marker.testing, 
      #                  psize = psize, counselee.id = counselee.id, allef = allef)
      post = runPeeling(family = ifamily$fff, params = params, ngen = ngen, 
                        oophorectomy = oophorectomy, mastectomy = mastectomy, 
                        germline.testing = germline.testing, marker.testing = marker.testing, 
                        psize = psize, counselee.id = counselee.id, allef = allef,mod=mod,gene=gene,nloci=nloci,mrate1=mrate1,
                        mrate2=mrate2, f_index=f_index,m_index=m_index)
    }
  }
  if (!missingage) {
    agewarning = ""
    post = runPeeling(family = family, params = params, ngen = ngen, 
                      oophorectomy = oophorectomy, mastectomy = mastectomy, 
                      germline.testing = germline.testing, marker.testing = marker.testing, 
                      psize = psize, counselee.id = counselee.id, allef = allef,mod=mod,gene=gene,nloci=nloci,mrate1=mrate1,
                      mrate2=mrate2, f_index=f_index,m_index=m_index)
  }
  if (!missingage | imputeAges == FALSE) {
    family = family
  }
  if (missingage & imputeAges == TRUE) {
    family = ifamily$fff
  }
  
  ll <- NULL
  post <- matrix(post, nrow = 3, ncol = 3, byrow = FALSE)
  post <- post[-3, -3]
  rownames(post) <- c("BRCA10", "BRCA11")
  colnames(post) <- c("BRCA20", "BRCA21")
  ages.cancer <- c(family[which(family$ID == counselee.id), 
                          "AgeBreast"], family[which(family$ID == counselee.id), 
                                               "AgeOvary"], family[which(family$ID == counselee.id), 
                                                                   "AgeBreastContralateral"])
  current.age <- max(ages.cancer)
  ages <- seq(proband.current.age + params$age.by, ifelse(params$age.to >= 
                                                            proband.current.age + params$age.by, params$age.to, 110), 
              by = params$age.by)
  p0 <- post["BRCA10", "BRCA20"]
  p2 <- sum(post["BRCA10", ]) - p0
  p1 <- sum(post[, "BRCA20"]) - p0
  p12 <- 1 - p1 - p2 - p0
  if (print == TRUE) {
    cat("The probability of being a carrier is", 1 - p0, 
        "\n an BRCA1 carrier", p1, "\n an BRCA2 carrier", 
        p2, "\n")
  }
  return(probs=c(p0=p0,p1=p1,p2=p2,p12=p12))
}



runPeeling = function(family, params, ngen, oophorectomy, 
                      mastectomy, germline.testing, marker.testing, psize, 
                      counselee.id, allef, mod, gene, nloci, mrate1, mrate2, f_index, m_index) {
  if (is.null(oophorectomy) & is.null(mastectomy)) {
    interventions <- family[, "ID"] == 0
    oophonly <- mastonly <- mastbeforeooph <- oophbeforemast <- family[, 
                                                                       "ID"] == 0
  }
  else {
    if (!is.null(oophorectomy) & !is.null(mastectomy)) {
      interventions <- family$Oophorectomy == 1 | family$Mastectomy == 
        1
      mastonly <- family$Mastectomy == 1 & family$Oophorectomy == 
        0
      oophonly <- family$Mastectomy == 0 & family$Oophorectomy == 
        1
      mastbeforeooph <- family$Oophorectomy == 1 & 
        family$Mastectomy == 1 & family$AgeMastectomy <= 
        family$AgeOophorectomy
      oophbeforemast <- family$Oophorectomy == 1 & 
        family$Mastectomy == 1 & family$AgeMastectomy > 
        family$AgeOophorectomy
    }
    else {
      if (!is.null(oophorectomy) & is.null(mastectomy)) {
        interventions <- family$Oophorectomy == 1
        mastonly <- family[, "ID"] == 0
        oophonly <- family$Oophorectomy == 1
        mastbeforeooph <- family[, "ID"] == 0
        oophbeforemast <- family[, "ID"] == 0
      }
      else {
        if (is.null(oophorectomy) & !is.null(mastectomy)) {
          interventions <- family$Mastectomy == 1
          mastonly <- family$Mastectomy == 1
          oophonly <- family[, "ID"] == 0
          mastbeforeooph <- family[, "ID"] == 0
          oophbeforemast <- family[, "ID"] == 0
        }
      }
    }
  }
  if (sum(interventions) > 0) {
    if (sum(oophonly) > 0) {
      oophfamily <- family[oophonly, , drop = FALSE]
      output <- FamilyHistoryContributions(PostIntervention(oophfamily, 
                                                            whichintervention = "Oophorectomy"), params$penetrance, 
                                           ngen, type = "PostIntervention", whichintervention = "Oophorectomy", 
                                           CBCpenetrance = params$CBCpenetrance)
      PostIntOophOnlyDIS <- output$DIS
      PostIntOophOnlyAFF <- output$AFF
      PostIntOophOnlyUNA <- output$UNA
    }
    if (sum(mastonly) > 0) {
      mastfamily <- family[mastonly, , drop = FALSE]
      output <- FamilyHistoryContributions(PostIntervention(mastfamily, 
                                                            whichintervention = "Mastectomy"), params$penetrance, 
                                           ngen, type = "PostIntervention", whichintervention = "Mastectomy", 
                                           CBCpenetrance = params$CBCpenetrance)
      PostIntMastOnlyDIS <- output$DIS
      PostIntMastOnlyAFF <- output$AFF
      PostIntMastOnlyUNA <- output$UNA
    }
    if (sum(mastbeforeooph) > 0) {
      mastfamily <- family[mastbeforeooph, , drop = FALSE]
      output <- FamilyHistoryContributions(PostIntervention(mastfamily, 
                                                            whichintervention = "Mastectomy"), params$penetrance, 
                                           ngen, type = "PostIntervention", whichintervention = "MastectomyFirst", 
                                           CBCpenetrance = params$CBCpenetrance)
      PostIntMastFirstDIS <- output$DIS
      PostIntMastFirstAFF <- output$AFF
      PostIntMastFirstUNA <- output$UNA
      output <- FamilyHistoryContributions(PostIntervention(mastfamily, 
                                                            whichintervention = "Oophorectomy"), params$penetrance, 
                                           ngen, type = "PostIntervention", whichintervention = "Oophorectomy", 
                                           CBCpenetrance = params$CBCpenetrance)
      PostIntOophAfterDIS <- output$DIS
      PostIntOophAfterAFF <- output$AFF
      PostIntOophAfterUNA <- output$UNA
    }
    if (sum(oophbeforemast) > 0) {
      oophfamily <- family[oophbeforemast, , drop = FALSE]
      output <- FamilyHistoryContributions(PostIntervention(oophfamily, 
                                                            whichintervention = "Oophorectomy"), params$penetrance, 
                                           ngen, type = "PostIntervention", whichintervention = "OophorectomyFirst", 
                                           CBCpenetrance = params$CBCpenetrance)
      PostIntOophFirstDIS <- output$DIS
      PostIntOophFirstAFF <- output$AFF
      PostIntOophFirstUNA <- output$UNA
      output <- FamilyHistoryContributions(PostIntervention(oophfamily, 
                                                            whichintervention = "Mastectomy"), params$penetrance, 
                                           ngen, type = "PostIntervention", whichintervention = "Mastectomy", 
                                           CBCpenetrance = params$CBCpenetrance)
      PostIntMastAfterDIS <- output$DIS
      PostIntMastAfterAFF <- output$AFF
      PostIntMastAfterUNA <- output$UNA
    }
  }
  if (sum(interventions) > 0) {
    PreInterventionFamily <- CensorAtIntervention(family, 
                                                  interventions)
  }
  else {
    PreInterventionFamily <- family
  }
  output <- FamilyHistoryContributions(PreInterventionFamily, 
                                       penetrance = params$penetrance, ngen, type = "PreIntervention", 
                                       CBCpenetrance = params$CBCpenetrance)
  DIS <- output$DIS
  AFF <- output$AFF
  UNA <- output$UNA
  output <- TestContributions(family, psize, ngen, params$sensitivity1, 
                              params$specificity1, params$sensitivity2, params$specificity2, 
                              params$marker.prob, params$allef, counselee.id)
  TES <- output$TES
  ER <- output$ER
  ER.CK <- output$ER.CK
  HER2 <- output$HER2
  PR <- output$PR
  LIK <- matrix(1, psize, ngen)
  maxages <- apply(family[, c("AgeBreast", "AgeOvary", "AgeBreastContralateral")], 
                   1, max)
  sex <- family$Gender
  for (gg in 1:ngen) {
    if (gg == 1 | gg == 2 | gg == 4 | gg == 5) {
      ggcr <- ifelse(gg == 1, 1, ifelse(gg == 2, 2, 
                                        ifelse(gg == 4, 3, 4)))
      if (is.matrix(params$comprisk[maxages, ggcr * 
                                    (sex == 0) + (ggcr + 4) * (sex == 1)])) {
        LIK[, gg] <- apply(DIS * AFF[, , gg] + (1 - 
                                                  DIS) * UNA[, , gg], 1, prod) * TES[, gg] * 
          ER[, gg] * ER.CK[, gg] * PR[, gg] * HER2[, 
                                                   gg] * diag(params$comprisk[maxages, ggcr * 
                                                                                (sex == 0) + (ggcr + 4) * (sex == 1)])
      }
      if (!is.matrix(params$comprisk[maxages, ggcr * 
                                     (sex == 0) + (ggcr + 4) * (sex == 1)])) {
        LIK[, gg] <- apply(DIS * AFF[, , gg] + (1 - 
                                                  DIS) * UNA[, , gg], 1, prod) * TES[, gg] * 
          ER[, gg] * ER.CK[, gg] * PR[, gg] * HER2[, 
                                                   gg] * diag(params$comprisk[maxages, ggcr * 
                                                                                (sex == 0) + (ggcr + 4) * (sex == 1)], nrow = 1)
      }
    }
    else {
      LIK[, gg] <- rep(0, psize)
    }
  }
  if (sum(interventions) > 0) {
    if (sum(oophonly) > 0) {
      for (gg in 1:ngen) {
        LIK[oophonly, gg] <- LIK[oophonly, gg] * apply(PostIntOophOnlyDIS * 
                                                         PostIntOophOnlyAFF[, , gg] + (1 - PostIntOophOnlyDIS) * 
                                                         PostIntOophOnlyUNA[, , gg], 1, prod)
      }
    }
    if (sum(mastonly) > 0) {
      for (gg in 1:ngen) {
        LIK[mastonly, gg] <- LIK[mastonly, gg] * apply(PostIntMastOnlyDIS * 
                                                         PostIntMastOnlyAFF[, , gg] + (1 - PostIntMastOnlyDIS) * 
                                                         PostIntMastOnlyUNA[, , gg], 1, prod)
      }
    }
    if (sum(mastbeforeooph) > 0) {
      for (gg in 1:ngen) {
        LIK[mastbeforeooph, gg] <- LIK[mastbeforeooph, 
                                       gg] * apply(PostIntMastFirstDIS * PostIntMastFirstAFF[, 
                                                                                             , gg] + (1 - PostIntMastFirstDIS) * PostIntMastFirstUNA[, 
                                                                                                                                                     , gg], 1, prod) * apply(PostIntOophAfterDIS * 
                                                                                                                                                                               PostIntOophAfterAFF[, , gg] + (1 - PostIntOophAfterDIS) * 
                                                                                                                                                                               PostIntOophAfterUNA[, , gg], 1, prod)
      }
    }
    if (sum(oophbeforemast) > 0) {
      for (gg in 1:ngen) {
        LIK[oophbeforemast, gg] <- LIK[oophbeforemast, 
                                       gg] * apply(PostIntOophFirstDIS * PostIntOophFirstAFF[, 
                                                                                             , gg] + (1 - PostIntOophFirstDIS) * PostIntOophFirstUNA[, 
                                                                                                                                                     , gg], 1, prod) * apply(PostIntMastAfterDIS * 
                                                                                                                                                                               PostIntMastAfterAFF[, , gg] + (1 - PostIntMastAfterDIS) * 
                                                                                                                                                                               PostIntMastAfterUNA[, , gg], 1, prod)
      }
    }
  }
  if (sum(family$Twins) > 0) {
    if (length(unique(family$Twins)) >= 1 & !any(family$Twins == 
                                                 0)) {
      loopID <- length(unique(family$Twins))
    }
    if (length(unique(family$Twins)) > 1 & any(family$Twins == 
                                               0)) {
      loopID <- length(unique(family$Twins)) - 1
    }
    family$NewMotherIndex = family$NewFatherIndex = 0
    for (iiiii in 1:loopID) {
      temp <- family[family$Twins == unique(family$Twins[family$Twins > 
                                                           0])[iiiii], ]
      if (temp$Gender[1] == 0) {
        family[family$Twins == unique(family$Twins[family$Twins > 
                                                     0])[iiiii], "NewMotherIndex"] = temp$ID[1]
      }
      if (temp$Gender[1] == 1) {
        family[family$Twins == unique(family$Twins[family$Twins > 
                                                     0])[iiiii], "NewFatherIndex"] = temp$ID[1]
      }
    }
    twins = family$ID[family$Twins > 0]
    offspring = family$ID[is.element(family$MotherID, 
                                     twins) | is.element(family$FatherID, twins)]
    if (length(offspring) > 0) {
      for (ooo in 1:length(offspring)) {
        motherIsTwin = family$Twins[family$ID == family$MotherID[family$ID == 
                                                                   offspring[ooo]]]
        fatherIsTwin = family$Twins[family$ID == family$FatherID[family$ID == 
                                                                   offspring[ooo]]]
        if (length(motherIsTwin) != 0) {
          if (motherIsTwin != 0) {
            family$MotherID[family$ID == offspring[ooo]] = family$NewMotherIndex[family$ID == 
                                                                                   family$MotherID[family$ID == offspring[ooo]]]
          }
        }
        if (length(fatherIsTwin) != 0) {
          if (fatherIsTwin != 0) {
            family$FatherID[family$ID == offspring[ooo]] = family$NewFatherIndex[family$ID == 
                                                                                   family$FatherID[family$ID == offspring[ooo]]]
          }
        }
      }
    }
    firsttwin = which(family$Twins > 0)
    firsttwin = firsttwin[match(unique(family$Twins[family$Twins != 
                                                      0]), family$Twins[family$Twins != 0])]
    nottwins = which(family$Twins == 0)
    collapsedtwins = sort(c(firsttwin, nottwins))
    ped = family[collapsedtwins, c("ID", "Gender", "FatherID", 
                                   "MotherID", "ethnic")]
    newLIK = LIK
    twinIDs = unique(family$Twins[family$Twins != 0])
    for (ttt in 1:length(twinIDs)) {
      twinrows = which(family$Twins == twinIDs[ttt])
      newLIK[twinrows[1], ] = LIK[twinrows[1], ] * 
        LIK[twinrows[2], ]
      newLIK[twinrows[2], ] = rep(NA, ngen)
    }
    LIK = newLIK[apply(newLIK, 1, function(x) {
      return(!any(is.na(x)))
    }), ]
  }
  if (sum(family$Twins) == 0) {
    ped = family[, c("ID", "Gender", "FatherID", "MotherID", 
                     "ethnic")]
  }
  if(mod == 2) {
    #LIK[f_index, 4:9] <- 0
    #LIK[m_index, 4:9] <- 0
    LIK[f_index,-1] <- 0
    LIK[m_index,-1] <- 0
  } else if(mod == 1) {
    LIK[f_index,-1] <- 0
    LIK[m_index,-1] <- 0
    #LIK[f_index, c(2,5,8,3,6,9)] <- 0
    #LIK[m_index, c(2,5,8,3,6,9)] <- 0
  } else if (mod == 0) {
  } else {
    cat("wrong input of mod!\nShould be 1 or 2\n")
  }
  
  post <- peelingRC(allef = allef, LIK, ped = ped, counselee.id = counselee.id, 
                    nloci = nloci, mRate = c(mrate1,mrate2))	# set the de novo mutation rate here
  return(post)
}

Famdenovo.BRCA <- function(BRCA.inp, denovo_ratio1, denovo_ratio2) {
  
  csv <- BRCA.inp
  csv.fam <- data.frame(csv$FamilyID, csv$BRCA1carrier, csv$BRCA2carrier, csv$ID, csv$Gender, csv$FatherID, csv$MotherID, csv$AffectedBreast, csv$AffectedOvary, csv$AgeBreast, csv$AgeOvary, csv$AgeBreastContralateral, csv$Twins, csv$ethnic)
  colnames(csv.fam) <- c("FamilyID", "BRCA1carrier", "BRCA2carrier", "ID", "Gender", "FatherID", "MotherID", "AffectedBreast", "AffectedOvary", "AgeBreast", "AgeOvary", "AgeBreastContralateral", "Twins", "ethnic")
  csv.fam0 <- csv.fam
  
  #denovo_ratioAJ<-0.5*denovo_ratio
  #denovo_ratioAJ <- denovo_ratio
  if (csv.fam0$ethnic[1]=="AJ"){
    mrate1 <- 0.00609756097560976 * denovo_ratio1
    mrate2 <- 0.00679723502304147 * denovo_ratio2
  }else{
    mrate1 <- 0.0005829 * denovo_ratio1
    mrate2 <- 0.000676 * denovo_ratio2
  }
  families <- csv.fam$FamilyID[!duplicated(csv.fam$FamilyID)]
  agewarninglist=list()
  out2 <- t(c(9, -9.9, "BRCA2", 9.9))  # the id is set to -9.9 and the denovo_probability is set to 9.9, which is an example, will be deleted in the output
  colnames(out2) <- c("FamilyID", "ID", "gene", "denovo_probability")
  out1 <- t(c(9, -9.9, "BRCA1", 9.9))
  colnames(out1) <- c("FamilyID", "ID", "gene", "denovo_probability")
  
  for(n in 1:length(families)) {             # loop by family
    cat(n, '\n')
    csv.fam <- csv.fam0[csv.fam0$FamilyID == families[n], 4:ncol(csv.fam0)]             
    csv.fam <- csv.fam[!is.na(csv.fam$Gender), ]
    colnames(csv.fam) <- c("ID", "Gender", "FatherID", "MotherID", "AffectedBreast", "AffectedOvary", "AgeBreast", "AgeOvary", "AgeBreastContralateral", "Twins", "ethnic")
    csv.fam[,11] <- as.character(csv.fam[,11])
    ## recode individual id; NA = 0; otherwise an integer
    # pick individuals with NA father
    fid <- rep(0, times = nrow(csv.fam))
    index_f <- substr(csv.fam[,3], nchar(csv.fam[,3])-1, nchar(csv.fam[,3])) == "_0"
    fid[index_f] <- 0                   # father NA
    # pick individuals with NA mother
    mid <- rep(0, nrow(csv.fam))
    index_m <- substr(csv.fam[,4], nchar(csv.fam[,4])-1, nchar(csv.fam[,4])) == "_0"
    mid[index_m] <- 0                   # mother NA
    # recode the kid
    id <- rep(0, times = nrow(csv.fam))
    id <- 1:nrow(csv.fam)
    id <- as.double(id)
    # transform the remaining ids in father and mother
    for(i in 1:nrow(csv.fam)) {
      tp_index <- csv.fam[i,3] == csv.fam[,1]
      if(sum(tp_index) >= 1) {
        fid[i] <- id[tp_index][1]
      }
      tp1_index <- csv.fam[i,4] == csv.fam[,1]
      if(sum(tp1_index) >= 1) {
        mid[i] <- id[tp1_index][1]
      }
    }
    CGI.fam <- data.frame(id, csv.fam$Gender, fid, mid, csv.fam[,5:ncol(csv.fam)])
    colnames(CGI.fam) <- c("ID", "Gender", "FatherID", "MotherID", "AffectedBreast", "AffectedOvary", "AgeBreast", "AgeOvary", "AgeBreastContralateral", "Twins", "ethnic")
    data(brca.fam,BRCApenet.metaDSL.2008,death.othercauses, compriskSurv, CBRCApenet.2012, BrOvJointDsn.2014)
    ## loop for mutation carriers in the family
    temp <- csv.fam0[csv.fam0$FamilyID == families[n], ]
    temp <- temp[!is.na(temp$Gender), ]
    temp$BRCA1carrier[is.na(temp$BRCA1carrier)] <- -9
    temp$BRCA2carrier[is.na(temp$BRCA2carrier)] <- -9
    index1 <- temp$BRCA1carrier == 1 
    index2 <- temp$BRCA2carrier == 1
    # BRCA2 mutation carriers
    if(sum(index2) > 0) {
      for(k in 1:sum(index2)) {
        #is_familial2 <- 0  # mark familial state as 0
        # mutation carrier is the counselee
        cs0 <- temp$ID[index2][k] # counselee id
        index_counselee <- csv.fam$ID == cs0
        cs <- CGI.fam$ID[index_counselee]# recoded counselee id for brcapro
        ## if father or mother not available, next
        if(CGI.fam$FatherID[index_counselee] == 0 || CGI.fam$MotherID[index_counselee] == 0) {
          next
        }
        ## if the father or the mother is a carrier, mark it as familial
        ##if(temp$BRCA2carrier[temp$ID == temp$FatherID[temp$ID == cs0]] == 1 || temp$BRCA2carrier[temp$ID == temp$MotherID[temp$ID == cs0]] == 1) {
        ##  is_familial2 = 1
        ##}
        
        ## calculate p1 = P(Gc=1|Gm=0,Gf=0,D,P)
        tp_modified_brcapro <- modified_brcapro(CGI.fam, counselee.id = cs, 
                                                mrate1 = mrate1, mrate2 = mrate2, 
                                                f_index = which(CGI.fam$ID == CGI.fam$FatherID[index_counselee]), 
                                                m_index = which(CGI.fam$ID == CGI.fam$MotherID[index_counselee]), 
                                                gene=2, mod = 2, print = F)
        #agewarninglist[length(agewarninglist)+1]<-tp_modified_brcapro[[2]]
        #p1 <- tp_modified_brcapro[[1]]@probs[3] + tp_modified_brcapro[[1]]@probs[4]
        p1 <- 1-tp_modified_brcapro[1]
        
        ## calculate p2 = P(Gf=0|D,P) 
        tp_modified_brcapro <- modified_brcapro(CGI.fam, counselee.id = CGI.fam$FatherID[index_counselee], 
                                                mrate1 = mrate1, mrate2 = mrate2, 
                                                f_index = NULL, 
                                                m_index = NULL, 
                                                gene=2, mod = 0, print = F)
        #agewarninglist[length(agewarninglist)+1]<-tp_modified_brcapro[[2]]
        #p2 <- 1-tp_modified_brcapro[[1]]@probs[3]-tp_modified_brcapro[[1]]@probs[4]
        p2 <- tp_modified_brcapro[1]
        
        ## calculate p3 = P(Gm=0|D,P)
        tp_modified_brcapro <- modified_brcapro(CGI.fam, counselee.id = CGI.fam$MotherID[index_counselee], 
                                                mrate1 = mrate1, mrate2 = mrate2, 
                                                f_index = NULL, 
                                                m_index = NULL, 
                                                gene=2, mod = 0, print = F)
        #agewarninglist[length(agewarninglist)+1]<-tp_modified_brcapro[[2]]
        #p3 <- 1-tp_modified_brcapro[[1]]@probs[3]-tp_modified_brcapro[[1]]@probs[4]
        p3 <- tp_modified_brcapro[1]
        
        ## calculate p4 = P(Gc=1|D,P)
        tp_modified_brcapro <- modified_brcapro(CGI.fam, counselee.id = cs, 
                                                mrate1 = mrate1, mrate2 = mrate2, 
                                                f_index = NULL, 
                                                m_index = NULL, 
                                                gene=2, mod = 0, print = F)
        #agewarninglist[length(agewarninglist)+1]<-tp_modified_brcapro[[2]]
        #p4 = tp_modified_brcapro[[1]]@probs[3] + tp_modified_brcapro[[1]]@probs[4]
        p4 = 1-tp_modified_brcapro[1]
        
        ## the de novo probability p_BRCA2_denovo
        #print(c(p1=p1,p2=p2,p3=p3,p4=p4))
        p_BRCA2_denovo = p1*p2*p3/p4
        tp <- t(c(families[n], cs0, "BRCA2_denovo_prob", p_BRCA2_denovo))
        colnames(tp) <- colnames(out2)
        out2 <- rbind(out2, tp)
      }
    } #else {
      #cat("no BRCA2 mutation carriers\n")
    #}
    # BRCA1 mutation carriers
    if(sum(index1) > 0) {
      for(k in 1:sum(index1)) {
        #is_familial1 <- 0
        # mutation carrier is the counselee
        cs0 <- temp$ID[index1][k] # counselee id
        index_counselee <- csv.fam$ID == cs0
        cs <- CGI.fam$ID[index_counselee]# recoded counselee id for brcapro
        ## if father or mother not available, next
        if(CGI.fam$FatherID[index_counselee] == 0 || CGI.fam$MotherID[index_counselee] == 0) {
          next
        }
        ## if the father or mother is a carrier, mark is_familial1 = 1
        #if(temp$BRCA1carrier[temp$ID == temp$FatherID[temp$ID == cs0]] == 1 || temp$BRCA1carrier[temp$ID == temp$MotherID[temp$ID == cs0]] == 1) {
        #  is_familial1 = 1
        #}
        
        ## calculate p1 = P(Gc=1|Gm=0,Gf=0,D,P)
        tp_modified_brcapro <- modified_brcapro(CGI.fam, counselee.id = cs, mrate1 = mrate1, mrate2 = mrate2, 
                                                f_index = which(CGI.fam$ID == CGI.fam$FatherID[index_counselee]), 
                                                m_index = which(CGI.fam$ID == CGI.fam$MotherID[index_counselee]), 
                                                gene = 1, mod = 1, print = F)
        #agewarninglist[length(agewarninglist)+1]<-tp_modified_brcapro[[2]]
        #p1 <- tp_modified_brcapro[[1]]@probs[2] + tp_modified_brcapro[[1]]@probs[4]
        p1 <- 1-tp_modified_brcapro[1]
        #if(p1 < 0) {
        #  write.table(tp_modified_brcapro[[1]]@probs, file = "minus_0.txt", quote = F, col.names = F, row.names = F, append = F)
        #}
        
        ## calculate p2 = P(Gf=0|D,P) 
        tp_modified_brcapro <- modified_brcapro(CGI.fam, counselee.id = CGI.fam$FatherID[index_counselee], 
                                                mrate1 = mrate1, mrate2 = mrate2, 
                                                f_index = NULL, 
                                                m_index = NULL, 
                                                gene = 1, mod = 0, print = F)
        #agewarninglist[length(agewarninglist)+1]<-tp_modified_brcapro[[2]]
        p2 <- tp_modified_brcapro[1]
        #p2 <- 1-tp_modified_brcapro[[1]]@probs[2]-tp_modified_brcapro[[1]]@probs[4]
        #if(p2 < 0) {
        #  write.table(c("p2", p2), file = "minus_0.txt", append = T)
        #}
        
        ## calculate p3 = P(Gm=0|D,P)
        tp_modified_brcapro <- modified_brcapro(CGI.fam, counselee.id = CGI.fam$MotherID[index_counselee], 
                                                mrate1 = mrate1, mrate2 = mrate2, 
                                                f_index = NULL, 
                                                m_index = NULL, 
                                                gene = 1, mod = 0, print = F)
        #agewarninglist[length(agewarninglist)+1]<-tp_modified_brcapro[[2]]
        p3 <- tp_modified_brcapro[1]
        #p3 <- 1-tp_modified_brcapro[[1]]@probs[2]-tp_modified_brcapro[[1]]@probs[4]
        #print(tp_modified_brcapro[[1]]@probs)
        #if(p3 < 0) {
        #  write.table(c("p3", p3), file = "minus_0.txt", append = T)
        #}
        
        ## calculate p4 = P(Gc=1|D,P)
        tp_modified_brcapro <- modified_brcapro(CGI.fam, counselee.id = cs, 
                                                mrate1 = mrate1, mrate2 = mrate2,
                                                f_index = NULL, 
                                                m_index = NULL, 
                                                gene = 1, mod = 0, print = F)
        #agewarninglist[length(agewarninglist)+1]<-tp_modified_brcapro[[2]]
        p4 <- 1-tp_modified_brcapro[1]
        #print(tp_modified_brcapro[[1]]@probs)
        #p4 = tp_modified_brcapro[[1]]@probs[2] + tp_modified_brcapro[[1]]@probs[4]
        #if(p4 < 0) {
        #  write.table(c("p4", p4), file = "minus_0.txt", append = T)
        #}
        
        ## the de novo probability p_BRCA1_denovo
        ##print(c(p1=p1,p2=p2,p3=p3,p4=p4))
        p_BRCA1_denovo = p1*p2*p3/p4
        tp <- t(c(families[n], cs0, "BRCA1_denovo_prob", p_BRCA1_denovo))
        colnames(tp) <- colnames(out1)
        out1 <- rbind(out1, tp)
      }
    } #else {
      #cat("no BRCA1 mutation carriers\n")
    #}
  }
  out <- rbind(out1, out2)
  if(nrow(out) == 2) {
    cat("no BRCA1 or BRCA2 mutation carriers with parents available in input\n")
  } else {
    out <- out[out[,2] != -9.9 & out[,4] != 9.9, ]
  }
  x = as.matrix(out)
  if (ncol(x)==1) x = t(x)
  return(x)
}
