
#ifndef EXTRACT_UNMAPREAD_H
#define EXTRACT_UNMAPREAD_H

#include <iostream>
#include <vector>
#include <fstream>
#include <sstream>
#include <string>
#include <math.h>
#include <algorithm>

using namespace std;
class ExtractRead
{
 public:
    char* sam_file;
    ofstream out_l, out_r, out_s;
 public:

 ExtractRead (char* file1)
 {
    sam_file = file1;
    //out_l.open("new_left.fq",ios::app);
    //out_r.open("new_right.fq", ios::app);
 }

 //flag info
 vector<int> Binary(int n){
    int temp=n;
    int num;
    vector<int> binary;
    while(temp!=0){
        num=temp%2;
        binary.push_back(num);
        temp=temp/2;
    }
    for(int i=binary.size();i<11;i++) binary.push_back(0);
    return binary;
 }

 //reverse complementary
 string read_revcomp(string s)
 {
    string revstring="";
    if(s == "*") return s;
    for(int i=s.length() - 1;i>=0;i--)
    {
        char c = s[i];
    char revchar;
    switch (c) {
      case 'g':
        revchar = 'C';
        break;
      case 'G':
        revchar = 'C';
        break;
      case 'a':
        revchar = 'T';
        break;
      case 'A':
        revchar = 'T';
        break;
      case 't':
        revchar = 'A';
        break;
      case 'T':
        revchar = 'A';
        break;
      case 'c':
        revchar = 'G';
        break;
      case 'C':
        revchar = 'G';
        break;
      default:
        revchar = 'N';
    }
    revstring += revchar;
    }
    return revstring;
  }
  void process_one_single_read(string info)
  {
    istringstream istr;
    istr.str(info);
    string seq,qual, chr, temp,id;
    istr>>id>>temp>>chr>>temp>>temp>>temp>>temp>>temp>>temp
    >>seq>>qual;
    if(chr == "*")
    {
	out_s<<"@"<<id<<'\n';
	out_s<<seq<<'\n'<<"+"<<'\n'<<qual<<'\n';

    }
  }
  void process_one_pair_read(vector<string>& pair_info)
  {
    istringstream istr;
    string id,temp;
    string seq1, seq2, qual1, qual2, seq,qual;
    int flag;
    bool f1 = false, f2 = false;
    for(int i = 0;i< pair_info.size();i++)
    {
	istr.str(pair_info[i]);
	istr>>id>>flag>>temp>>temp>>temp>>temp>>temp>>temp>>temp
	>>seq>>qual;
	istr.clear();
	//cerr<<pair_info[i]<<endl;
	vector<int> vec_flag = Binary(flag);

	if(vec_flag[2] == 0 && vec_flag[3] == 0) return;// self && pair are all mapped

	if(vec_flag[6] == 1) //mate 1
	{
	    if(f1) continue;
	    f1 = true;
	    if(vec_flag[4] == 0) //forward
	    {
		seq1 = seq;
	 	qual1 = qual;
	    }
	    else //reverse
	    {
		seq1 = read_revcomp(seq);
		reverse(qual.begin(),qual.end());
		qual1 = qual;
	    }
	}
	else//mate 2
	{
	    if(f2) continue;
	    f2 = true;
	    if(vec_flag[4] == 0) //forward
	    {
		seq2 = seq;
		qual2 = qual;
	    }
	    else
	    {
		seq2 = read_revcomp(seq);
		reverse(qual.begin(),qual.end());
		qual2 = qual;
	    }
	}
	if( f1 && f2) break;
    }
    out_l<<"@"<<id<<"/1"<<'\n';
    out_l<<seq1<<'\n'<<"+"<<'\n'<<qual1<<'\n';

    out_r<<"@"<<id<<"/2"<<'\n';
    out_r<<seq2<<'\n'<<"+"<<'\n'<<qual2<<'\n';
    
  }
  void extract_pairread()
  {
    
    ifstream in(sam_file);
    out_l.open("reads_unmapped_left.fq");
    out_r.open("reads_unmapped_right.fq");
    istringstream istr;
    string s,last_id;
    vector<string> pair_info;

    while(getline(in,s))
    {
	if(s[0] == '@') continue;
	else{
	    istr.str(s);
	    istr>>last_id;
	    pair_info.push_back(s);
	    istr.clear();
	    break;
 	}
    }
    while(getline(in,s))
    {
	string curr_id;
	istr.str(s);
	istr>>curr_id;
	if(curr_id == last_id)
	    pair_info.push_back(s);
	else
	{
	    process_one_pair_read(pair_info);
	    pair_info.clear();
	    pair_info.push_back(s);
	    last_id = curr_id;
	}
	istr.clear();
    }
    process_one_pair_read(pair_info);
    in.close(); out_l.close(); out_r.close();
    return;	
  }
  void extract_singleread()
  {
    ifstream in(sam_file);
    out_s.open("reads_unmapped_single.fq",ios::app);
    string s;
    istringstream istr;
    while(getline(in,s))
    {
	if(s[0] == '@') continue;
	else{
	    process_one_single_read(s);
	    break;
	}
    }
    while(getline(in,s))
    {
	process_one_single_read(s);
    }
    return;

  }

  
};

#endif
