#ifndef SCTIE_H
#define SCTIE_H

#include<iostream>
#include<fstream>
#include<string>
#include<vector>
#include<sstream>
#include <getopt.h>
#include<stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "get_plus_minus_from_gtf.h"
#include "sort_gtf.h"
#include "get_bound.h"

using namespace std;
class SCTie_build
{
	private:
	//bool Help;
	const char * ref_gtf;
	const char * ref_genome;
	const char * index_dir;
	const char * threads;
	public:
	SCTie_build(const char * Ref_gtf,const char * Ref_genome,const char * Index_dir,const char * Threads);
	void Process();
};
SCTie_build::SCTie_build(const char * Ref_gtf,const char * Ref_genome,const char * Index_dir,const char * Threads)
{
        ref_gtf=Ref_gtf;
        ref_genome=Ref_genome;
        index_dir=Index_dir;
        threads=Threads;
        return;
}
void SCTie_build::Process()
{
const char * path_plus="plus.gtf";
const char * path_plus_sort="plus_sort.gtf";
const char * path_minus="minus.gtf";
const char * path_minus_sort="minus_sort.gtf";
const char * path_plus_gene="plus.g";
const char * path_plus_chr="pseudo_chr_plus";
const char * path_minus_gene="minus.g";
const char * path_minus_chr="pseudo_chr_minus";
const char * cmd_pseudo_genome="cat pseudo_chr_plus pseudo_chr_minus >Pseudo_genome.fa";
char cmd_gtf[1000];
char mv_ref_genome[1000];
char rm_files[3000];

FILE * stream;

Get_plus_minus get_plus_minus_1(ref_gtf,path_plus,"+");
get_plus_minus_1.Process();// plus.gtf

Sort_GTF sort_gtf_1(path_plus,path_plus_sort);
sort_gtf_1.Process();

Get_plus_minus get_plus_minus_2(ref_gtf,path_minus,"-");
get_plus_minus_2.Process();// minus.gtf

Sort_GTF sort_gtf_2(path_minus,path_minus_sort);
sort_gtf_2.Process();

Get_gene_bound get_gene_bound_1(path_plus_sort);
get_gene_bound_1.Process();
Get_exon_bound get_exon_bound_1(path_plus_sort,ref_genome,path_plus_gene,path_plus_chr,get_gene_bound_1.Gene_bound,get_gene_bound_1.Gene_chr_num,get_gene_bound_1.Genome_chr);
get_exon_bound_1.get_chr_from_genome();
get_exon_bound_1.Process();
get_gene_bound_1.variant_clear();
get_exon_bound_1.variant_clear();

Get_gene_bound get_gene_bound_2(path_minus_sort);
get_gene_bound_2.Process();
Get_exon_bound get_exon_bound_2(path_minus_sort,ref_genome,path_minus_gene,path_minus_chr,get_gene_bound_2.Gene_bound,get_gene_bound_2.Gene_chr_num,get_gene_bound_2.Genome_chr);
get_exon_bound_2.get_chr_from_genome();
get_exon_bound_2.Process();
get_gene_bound_2.variant_clear();
get_exon_bound_2.variant_clear();

strcpy(cmd_gtf,"cat plus.g minus.g >");
strcat(cmd_gtf,index_dir);
strcat(cmd_gtf,".g ");
stream = popen(cmd_gtf,"r");
pclose(stream);// mkdir SCTie_tmp;

stream = popen(cmd_pseudo_genome,"r");
pclose(stream);// mkdir SCTie_tmp;

strcpy(rm_files,"rm ");
strcat(rm_files,path_plus_gene);
strcat(rm_files," ");
strcat(rm_files,path_plus_chr);
strcat(rm_files," ");
strcat(rm_files,path_minus_gene);
strcat(rm_files," ");
strcat(rm_files,path_minus_chr);
strcat(rm_files," ");
strcat(rm_files,path_plus);
strcat(rm_files," ");
strcat(rm_files,path_plus_sort);
strcat(rm_files," ");
strcat(rm_files,path_minus);
strcat(rm_files," ");
strcat(rm_files,path_minus_sort);
strcat(rm_files," ");
strcat(rm_files,"Pseudo_genome.fa");
stream = popen(rm_files,"r");
pclose(stream);

return;
}

#endif

















