#include<iostream>
#include<fstream>
#include<string>
#include<vector>
#include<sstream>
#include <getopt.h>
#include<stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "SCTie_build.h"

using namespace std;
bool Help = false;
bool Version=false;
const char * ref_gtf="";
const char * ref_genome="";
const char * index_base="";
const char * threads="1";
const char * version="The current version is: v.1.0";
const char * short_opt="a:g:ht:i:v";
struct option long_opt[]={
    {"ref_gtf",1,0,'a'},
    {"ref_genome",1,0,'g'},
    {"help",0,0,'h'},
    {"index_base",1,0,'i'},
    {"threads",1,0,'t'},
    {"version",1,0,'v'},
    {0,0,0,0}
};
string  usage(){
    stringstream use_info;
    use_info<<endl<<"================================================================"<<endl;
    use_info<<"Usage:"<<"\n"<<endl;
    use_info<<"  scRNAss_build [options] -a <annotation> -g <genome> -i <index_base>"<<endl;
    use_info<<""<<endl;
    use_info<<"** Required **"<<"\n"<<endl
    <<"  --ref_gtf/-a <string>    "<<": Path of reference transcriptome (GTF format);"<<"\n"<<endl
    <<"  --ref_genome/-g <string> "<<": Path of reference genome (FASTA format);"<<"\n"<<endl
    <<"  --index_base/-i <string> "<<": Write scRNAss index files to dir/basename;"<<"\n"<<endl
    <<"** Optional **"<<"\n"<<endl
    <<"  --help/-h                "<<": Help infomation;"<<"\n"<<endl
    <<"  --threads/-t <int>       "<<": Number of threads to launch, default: 1;"<<"\n"<<endl
    <<"  --version/-v             "<<": Show current version of scRNAss;"<<"\n"<<endl
    <<"** Note **"<<"\n"<<endl
    <<"  (1) The version of annotation GTF file must match that of genome file;"<<"\n"<<endl
    <<"  (2) All chromsomes recorded in annotation GTF file must exist in genome file;"<<"\n"<<endl;
    use_info<<"================================================================"<<endl;
    return use_info.str();
}
int parse_options(int argc,char*argv[]){
    int option_index=0;
    int next_option;
    while((next_option=getopt_long(argc,argv,short_opt,long_opt,&option_index)) != -1){
        switch(next_option){
            case 'g':
                ref_genome=optarg;
                break;
            case 'a':
                ref_gtf=optarg;
                break;
            case 'h':
                Help=true;
                break;
	    case 'v':
		Version=true;
		break;
            case 'i':
                index_base=optarg;
                break;
            case 't':
                threads=optarg;
                break;
            case '?':
                cout<<usage();
                exit(1);
        }
    }
    if(Help) 
    {
	cout<<usage()<<endl;
     	exit(1);
    }
    if(Version)
    {
	cout<<version<<endl;
	exit(1);
    }
    if(ref_gtf=="")
    {
        cout<<"Error : -a option needs an argument!! "<<endl;
        cout<<usage();
        exit(1);
    }
    if(ref_genome=="")
    {
        cout<<"Error : -g option needs an argument!! "<<endl;
        cout<<usage();
        exit(1);
    }
    if(index_base=="")
    {
	    cout<<"Error : -i option needs an argument!! "<<endl;
	    cout<<usage();
	    exit(1);
    }
	return 0;
}

int main(int argc, char * argv[])
{
	parse_options(argc,argv);
	SCTie_build sctie_build(ref_gtf,ref_genome,index_base,threads);
	sctie_build.Process();
return 0;
}

