#ifndef SCTIE_H
#define SCTIE_H

#include<iostream>
#include<fstream>
#include<string>
#include<vector>
#include<sstream>
#include <getopt.h>
#include<stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "gtf2fa.h"
#include "abundance.h"
#include "get_info_gene.h"
#include "get_info_gene_single.h"
#include "get_junction_graph.h"
#include "junction_paths.h"
#include "recover_paths.h"
#include "PairPacker.h"
#include "extract_UnmapRead.h"
#include "combine_gtf.h"

using namespace std;
bool check_gtf_single(const char* file)
{
    ifstream in(file);
    istringstream istr;
    string s;

    string chr, strand, lable;
    string tranid,gene_id;
    string temp;
    int exon_l,exon_r;
    vector<int> vecExon;

    getline(in,s);
    istr.str(s);

    istr>>chr>>temp>>lable>>exon_l>>exon_r>>temp>>strand>>temp>>temp>>gene_id;
    while(istr>>temp) if( temp == "transcript_id") istr>>tranid;
    if(lable == "exon"){ vecExon.push_back(exon_l); vecExon.push_back(exon_r);}
    istr.clear();
    int single_number = 0, all_number = 0;
    while(getline(in,s))
    {
        istr.str(s);
        string current_id,current_gid;
        string curr_chr, curr_strand;
        int curr_el, curr_er;

        istr>>curr_chr>>temp>>lable>>curr_el>>curr_er>>temp>>curr_strand>>temp>>temp>>current_gid;
        if(lable != "exon") continue;

        while(istr>>temp) if( temp == "transcript_id") istr>>current_id;
        istr.clear();
        if(current_id == tranid)//commom transcript
        {
            vecExon.push_back(curr_el); vecExon.push_back(curr_er);
        }
        else
        {   
            for(size_t i=1;i<vecExon.size()-1;)
            {   
                if(vecExon[i+1] - vecExon[i] == 1)
                {   
                    vecExon.erase(vecExon.begin() + i);
                    vecExon.erase(vecExon.begin() + i);
                    continue;
                } 
                i = i+2;
            }
	    if(vecExon.size() == 2) single_number++;
	    all_number++;
            vecExon.clear();
            vecExon.push_back(curr_el); vecExon.push_back(curr_er);
            chr = curr_chr; strand = curr_strand;
            tranid = current_id;
            gene_id = current_gid;

        }
    }
    in.close();
    double R = double(1.0*single_number/all_number);
    if(R>0.5) return true;
    return false;
}
class SCTie
{
	private:
	const char * ref_gtf;
	const char * ref_genome;
	const char * BAM;
	const char * STRAND;
	const char * output;
	int min_trans_len;
	int stable_num;
	double min_seed;
	const char * min_cov;
	const char * temp_dir;
	const char * threads;
	public:
	const char * output_1;
	SCTie(const char * Ref_gtf, const char * Ref_genome, const char * bam, const char * strand, const char * Output,int Min_trans_len,int Sta_num,double Min_seed,const char * Min_cov,const char * Temp_dir,const char * Threads);
	void Process();
};
SCTie::SCTie(const char * Ref_gtf, const char * Ref_genome, const char * bam, const char * strand, const char * Output,int Min_trans_len,int Sta_num,double Min_seed,const char * Min_cov,const char * Temp_dir,const char * Threads)
{
	ref_gtf=Ref_gtf;
	ref_genome=Ref_genome;
	BAM=bam;
	STRAND=strand;
        output=Output;
        min_trans_len=Min_trans_len;
	stable_num=Sta_num;
        min_seed=Min_seed;
        min_cov=Min_cov;
        temp_dir=Temp_dir;
        threads=Threads;
	FILE * stream;
	char mkdir[1000];
/*
	strcpy(mkdir,"mkdir TransBorrow_results");
	stream = popen(mkdir,"r");
	pclose(stream);
*/
	output_1="./TransBorrow_results/";
        return;
}
void SCTie::Process()
{
char mkdir[1000];
char output_stable[1000];
char output_raw[1000];
char output_combine[1000];
char output_combine_s[1000];
char get_exon[1000];
char gtf2fa[1000];
char abundance_1[1000];
char abundance_2[1000];
char abundance_3[1000];
char rm_dir[1000];
char Path[1000];
char work_path[1000];
memset(work_path, 0x00, sizeof(work_path));
getcwd(work_path, sizeof(work_path)-1);
memset(Path, 0x00, sizeof(Path));
int ret =  readlink("/proc/self/exe", Path, sizeof(Path)-1 );
//YU

strcpy(output_stable,temp_dir);
strcat(output_stable,"/stable.gtf");
strcpy(output_raw,temp_dir);
strcat(output_raw,"/raw.gtf");
strcpy(output_combine,temp_dir);
strcat(output_combine,"/combine_junc.gtf");
strcpy(output_combine_s,temp_dir);
strcat(output_combine_s,"/combine_s.gtf");

FILE * stream;
strcpy(mkdir,"mkdir ");
strcat(mkdir,temp_dir);
stream = popen(mkdir,"r");
pclose(stream);// mkdir SCTie_tmp;

char info_gene[1000];
strcpy(info_gene,temp_dir);
strcat(info_gene,"/Index.g");
char log_file[1000];
strcpy(log_file,temp_dir);
strcat(log_file,"/log");

int revise =1;
//YU
ifstream in(ref_genome);
string genome_yu = "", temp_yu;
while(getline(in,temp_yu))
{
    genome_yu.append(temp_yu);
    if(genome_yu.length() > 20000000) //spk 50m
    {

	revise = 0;
        break;
    }
}
genome_yu.clear();
genome_yu = temp_yu;
in.close();
if (revise == 1){
//revise ref_gtf and build Index.g
char revise[1000];
strcpy(revise,Path);
strcat(revise,"_revise ");
strcat(revise,ref_gtf);
strcat(revise,"> ");
strcat(revise,temp_dir);
strcat(revise,"/revised.gtf");
stream = popen(revise,"r");
pclose(stream);

char build_1[1000];
strcpy(build_1,Path);
strcat(build_1,"_build -a ");
strcat(build_1,temp_dir);
strcat(build_1,"/revised.gtf");
strcat(build_1," -g ");
strcat(build_1,ref_genome);
strcat(build_1," -i ");
strcat(build_1,temp_dir);
strcat(build_1,"/Index");
stream = popen(build_1,"r");
pclose(stream);
}
else{
// build Index.g
char build_1[1000];
strcpy(build_1,Path);
strcat(build_1,"_build -a ");
strcat(build_1,ref_gtf);
strcat(build_1," -g ");
strcat(build_1,ref_genome);
strcat(build_1," -i ");
strcat(build_1,temp_dir);
strcat(build_1,"/Index");
stream = popen(build_1,"r");
pclose(stream);
}
// build log based on Index.g
Gene_info gene_info(info_gene,log_file,stable_num);
gene_info.Generate_genes();
cerr<<"Processing gene_paths ..."<<endl;
gene_info.get_stable_paths();
cerr<<"Gene_paths finished ..."<<endl;
cerr<<"************************"<<endl;
gene_info.show_genes();

// generate stable.gtf
char file_graph[1000];
strcpy(file_graph,temp_dir);
strcat(file_graph,"/log");
ifstream ifs(file_graph);
istringstream istr;
string temp, curr_chr;
vector<string> Gene_chrs;
vector<vector<int> > curr_path;
vector<double> curr_node_temp;
vector<double> curr_edge_temp;
vector<vector<double> > curr_node,curr_edge;
vector<int> curr_path_temp;
vector<vector<vector<double> > > Gene_nodes, Gene_edges;
vector<vector<vector<int> > > Combined_gene_and_pair_paths;
double gene_id=0;
int Graph_num;
while (getline(ifs,temp))
{
        if (temp == "** Chr **")
        {
                getline(ifs,temp);
		curr_chr=temp;
                Gene_chrs.push_back(curr_chr);
        }
	if (temp == "** Nodes **")
        {
                curr_node.clear();
		double val_1, val_2, val_3, val_4, val_5;
                while (1)
                {
                        getline(ifs,temp);
                        if (temp == "** Edges **")
                                break;
                        istr.str(temp);
                        istr>>val_1>>val_2>>val_3>>val_4>>val_5;
                        istr.clear();
                        curr_node_temp.push_back(val_1);
                        curr_node_temp.push_back(val_2);
                        curr_node_temp.push_back(val_3);
                        curr_node_temp.push_back(val_4);
                        curr_node_temp.push_back(val_5);
                        curr_node.push_back(curr_node_temp);
                        curr_node_temp.clear();
                }
                Gene_nodes.push_back(curr_node);
        }
	if (temp == "** Edges **")
        {
                double VAL_1, VAL_2, VAL_3;
                int edge_id=0;
                curr_edge.clear();
                while (1)
                {
                        getline(ifs,temp);
                        if (temp == "** Combine gene and pair paths **")
                                break;
                        istr.str(temp);
                        istr>>VAL_1>>VAL_2>>VAL_3;
                        istr.clear();
                        curr_edge_temp.push_back(VAL_1);
                        curr_edge_temp.push_back(VAL_2);
                        curr_edge_temp.push_back(VAL_3);
                        curr_edge.push_back(curr_edge_temp);
                        curr_edge_temp.clear();
			edge_id++;
                }
                Gene_edges.push_back(curr_edge);
        }
	if (temp == "** Combine gene and pair paths **")
        {
		curr_path.clear();
                vector<string> curr_path_name;
                string alg_name;
                while (1)
                {
                        getline(ifs,temp);
                        if (temp == "** End **")
                                break;
                        int path_start_pos=0;
                        for (size_t i=path_start_pos;i<temp.size();i++)
                        {
                                if (temp[i]==' ')
                                {
                                        curr_path_temp.push_back(atoi(temp.substr(path_start_pos,i-path_start_pos).c_str()));
                                        path_start_pos=i+1;
                                }
                        }
                        int node_start = curr_path_temp[0];
                        int node_end = curr_path_temp[curr_path_temp.size()-1];
			for (int i=node_start;i>0;i--)
                        {
                                if (Gene_nodes[gene_id][i-1][1]+1 == Gene_nodes[gene_id][curr_path_temp[0]][0])
                                {
                                        curr_path_temp.insert(curr_path_temp.begin(),i-1);
                                }
                                else
                                {
                                        break;
                                }
                        }
                        for (int i=node_end;i<Gene_nodes[gene_id].size()-1;i++)
                        {
                                if (Gene_nodes[gene_id][curr_path_temp[curr_path_temp.size()-1]][1]+1 == Gene_nodes[gene_id][i+1][0])
                                {
                                        curr_path_temp.push_back(i+1);
                                }
                                else
                                {
                                        break;
                                }
                        }
                        curr_path.push_back(curr_path_temp);
                        curr_path_temp.clear();
                }
                Combined_gene_and_pair_paths.push_back(curr_path);
                gene_id++;
        }
}//while (getline(ifs,temp)
ifs.close();
for (size_t i=0;i<Gene_edges.size();i++)
{
	vector<vector<int> > Vec_edges;
	vector<double> Vec_weights;
	vector<int> Unused_junctions;
	vector<vector<int> > Unused_pair_paths;
	vector<int> Cons_left;
        vector<int> Cons_right;
	double SEED_Filter=min_seed;
	vector<string> Node_seq_1;
	vector<int> Node_seq_2, Node_seq_3;
	vector<double> Node_seq_4;
	int Strand=0;
	//int Path_length=atoi(argv[4]);
	int Path_length=min_trans_len;
	int Trans_id=0;
	vector<int> Vec_edges_temp;
	int edge_temp;
	Graph_num=i;
	for (size_t j=0;j<Gene_edges[i].size();j++)
	{
		if (Gene_edges[i][j].size()==3 && Gene_edges[i][j][2]>=0)
		{
			edge_temp=int(Gene_edges[i][j][0]);
			Vec_edges_temp.push_back(edge_temp);
			edge_temp=int(Gene_edges[i][j][1]);
			Vec_edges_temp.push_back(edge_temp);
			Vec_edges.push_back(Vec_edges_temp);
			Vec_edges_temp.clear();
			Vec_weights.push_back(Gene_edges[i][j][2]);
		}
	}
	for (size_t j=0;j<Gene_nodes[i].size();j++)
	{
		Node_seq_1.push_back(Gene_chrs[i].substr(0,Gene_chrs[i].size()-1));
		Node_seq_2.push_back(Gene_nodes[i][j][0]);
		Node_seq_3.push_back(Gene_nodes[i][j][1]);
		//Node_seq_4.push_back(Gene_nodes[i][j][4]);
		Node_seq_4.push_back(100);
	}
	if (Gene_chrs[i][Gene_chrs[i].size()-1] == '+')
	{
		Strand=1;
	}
	if (Gene_chrs[i][Gene_chrs[i].size()-1] == '-')
	{
		Strand=2;
	}
	//Combined_gene_and_pair_paths;
	vector<int> Single_nodes;
	vector<vector<int> > used_edges;
	vector<int> used_edges_temp;
	vector<vector<int> >::iterator pos;
	vector<vector<double> >::iterator pos_new;
	vector<int> vec_rm;
	PairPacker pairpacker(Combined_gene_and_pair_paths[i],Node_seq_1,Node_seq_2,Node_seq_3,Node_seq_4,Graph_num,Trans_id,Single_nodes,output_stable,Path_length,Strand,Gene_edges[i],"STABLE"); 
        pairpacker.PairPacker_Output();
} //for (i=0;i<Gene_edges.size();i++)
// build graph and add paths to stable.gtf
int Revise = revise;
if(revise == 1 && check_gtf_single(ref_gtf)) Revise = 2;
stringstream ss;
ss<<Revise;
const char* s_revise = ss.str().c_str();

char build_g[1000];
strcpy(build_g,Path);
strcat(build_g,"_graph -b ");
strcat(build_g,BAM);
strcat(build_g," -s ");
strcat(build_g,STRAND);
strcat(build_g," -g NO -o ");
strcat(build_g,temp_dir);
strcat(build_g,"/stable.gtf");

strcat(build_g," -t ");
strcat(build_g, s_revise);//YU
stream = popen(build_g,"r");
pclose(stream);

char move_graph[1000];
/*//YU
strcpy(move_graph,"mv MyReads_1.fa MyReads_2.fa MyReads.fa ");
strcat(move_graph,temp_dir);
stream = popen(move_graph,"r");
pclose(stream);
*/
//build Index_new.g based on stable.gtf
char build[1000];
strcpy(build,Path);
strcat(build,"_build -a ");
strcat(build,temp_dir);
strcat(build,"/stable.gtf");
strcat(build," -g ");
strcat(build,ref_genome);
strcat(build," -i ");
strcat(build,temp_dir);
strcat(build,"/Index_new");
stream = popen(build,"r");
pclose(stream);
// build log_new based on Index_new.g
char info_gene_new[1000];
strcpy(info_gene_new,temp_dir);
strcat(info_gene_new,"/Index_new.g");
char log_file_new[1000];
strcpy(log_file_new,temp_dir);
strcat(log_file_new,"/log_new");
Gene_info gene_info_new(info_gene_new,log_file_new,1);
gene_info_new.Generate_genes();
cerr<<"Processing gene_paths ..."<<endl;
gene_info_new.get_stable_paths();
cerr<<"Gene_paths finished ..."<<endl;
cerr<<"************************"<<endl;
gene_info_new.show_genes();
// generate combine.gtf based on log_new
ifs.open(log_file_new);
Gene_chrs.clear();
Gene_nodes.clear();
Gene_edges.clear();
Combined_gene_and_pair_paths.clear();
gene_id=0;
while (getline(ifs,temp))
{
        if (temp == "** Chr **")
        {
                getline(ifs,temp);
		curr_chr=temp;
                Gene_chrs.push_back(curr_chr);
        }
	if (temp == "** Nodes **")
        {
                curr_node.clear();
		double val_1, val_2, val_3, val_4, val_5;
                while (1)
                {
                        getline(ifs,temp);
                        if (temp == "** Edges **")
                                break;
                        istr.str(temp);
                        istr>>val_1>>val_2>>val_3>>val_4>>val_5;
                        istr.clear();
                        curr_node_temp.push_back(val_1);
                        curr_node_temp.push_back(val_2);
                        curr_node_temp.push_back(val_3);
                        curr_node_temp.push_back(val_4);
                        curr_node_temp.push_back(val_5);
                        curr_node.push_back(curr_node_temp);
                        curr_node_temp.clear();
                }
                Gene_nodes.push_back(curr_node);
        }
	if (temp == "** Edges **")
        {
                double VAL_1, VAL_2, VAL_3;
                int edge_id=0;
                curr_edge.clear();
                while (1)
                {
                        getline(ifs,temp);
                        if (temp == "** Combine gene and pair paths **")
                                break;
                        istr.str(temp);
                        istr>>VAL_1>>VAL_2>>VAL_3;
                        istr.clear();
                        curr_edge_temp.push_back(VAL_1);
                        curr_edge_temp.push_back(VAL_2);
                        curr_edge_temp.push_back(VAL_3);
                        curr_edge.push_back(curr_edge_temp);
                        curr_edge_temp.clear();
			edge_id++;
                }
                Gene_edges.push_back(curr_edge);
        }
	if (temp == "** Combine gene and pair paths **")
        {
		curr_path.clear();
                vector<string> curr_path_name;
                string alg_name;
                while (1)
                {
                        getline(ifs,temp);
                        if (temp == "** End **")
                                break;
                        int path_start_pos=0;
                        for (size_t i=path_start_pos;i<temp.size();i++)
                        {
                                if (temp[i]==' ')
                                {
                                        curr_path_temp.push_back(atoi(temp.substr(path_start_pos,i-path_start_pos).c_str()));
                                        path_start_pos=i+1;
                                }
                        }
                        int node_start = curr_path_temp[0];
                        int node_end = curr_path_temp[curr_path_temp.size()-1];
			for (int i=node_start;i>0;i--)
                        {
                                if (Gene_nodes[gene_id][i-1][1]+1 == Gene_nodes[gene_id][curr_path_temp[0]][0])
                                {
                                        curr_path_temp.insert(curr_path_temp.begin(),i-1);
                                }
                                else
                                {
                                        break;
                                }
                        }
                        for (int i=node_end;i<Gene_nodes[gene_id].size()-1;i++)
                        {
                                if (Gene_nodes[gene_id][curr_path_temp[curr_path_temp.size()-1]][1]+1 == Gene_nodes[gene_id][i+1][0])
                                {
                                        curr_path_temp.push_back(i+1);
                                }
                                else
                                {
                                        break;
                                }
                        }
                        curr_path.push_back(curr_path_temp);
                        curr_path_temp.clear();
                }
                Combined_gene_and_pair_paths.push_back(curr_path);
                gene_id++;
        }
}//while (getline(ifs,temp)
ifs.close();
for (size_t i=0;i<Gene_edges.size();i++)
{
	vector<vector<int> > Vec_edges;
	vector<double> Vec_weights;
	vector<int> Unused_junctions;
	vector<vector<int> > Unused_pair_paths;
	vector<int> Cons_left;
        vector<int> Cons_right;
	double SEED_Filter=min_seed;
	vector<string> Node_seq_1;
	vector<int> Node_seq_2, Node_seq_3;
	vector<double> Node_seq_4;
	int Strand=0;
	//int Path_length=atoi(argv[4]);
	int Path_length=min_trans_len;
	int Trans_id=0;
	vector<int> Vec_edges_temp;
	int edge_temp;
	Graph_num=i;
	for (size_t j=0;j<Gene_edges[i].size();j++)
	{
		if (Gene_edges[i][j].size()==3 && Gene_edges[i][j][2]>=0)
		{
			edge_temp=int(Gene_edges[i][j][0]);
			Vec_edges_temp.push_back(edge_temp);
			edge_temp=int(Gene_edges[i][j][1]);
			Vec_edges_temp.push_back(edge_temp);
			Vec_edges.push_back(Vec_edges_temp);
			Vec_edges_temp.clear();
			Vec_weights.push_back(Gene_edges[i][j][2]);
		}
	}
	for (size_t j=0;j<Gene_nodes[i].size();j++)
	{
		Node_seq_1.push_back(Gene_chrs[i].substr(0,Gene_chrs[i].size()-1));
		Node_seq_2.push_back(Gene_nodes[i][j][0]);
		Node_seq_3.push_back(Gene_nodes[i][j][1]);
		//Node_seq_4.push_back(Gene_nodes[i][j][4]);
		Node_seq_4.push_back(100);
	}
	if (Gene_chrs[i][Gene_chrs[i].size()-1] == '+')
	{
		Strand=1;
	}
	if (Gene_chrs[i][Gene_chrs[i].size()-1] == '-')
	{
		Strand=2;
	}
	vector<int> Single_nodes;
	vector<vector<int> > used_edges;
	vector<int> used_edges_temp;
	vector<vector<int> >::iterator pos;
	vector<vector<double> >::iterator pos_new;
	vector<int> vec_rm;
	PairPacker pairpacker(Combined_gene_and_pair_paths[i],Node_seq_1,Node_seq_2,Node_seq_3,Node_seq_4,Graph_num,Trans_id,Single_nodes,output_combine,Path_length,Strand,Gene_edges[i],"STABLE"); 
        pairpacker.PairPacker_Output_combine();
} //for (i=0;i<Gene_edges.size();i++)
char get_single[1000];
strcpy(get_single,Path);
strcat(get_single,"_single ");
strcat(get_single,temp_dir);
strcat(get_single,"/stable.gtf ");
strcat(get_single,temp_dir);
strcat(get_single,"/combine_junc.gtf >");
strcat(get_single,temp_dir);
strcat(get_single,"/combine.gtf ");
stream = popen(get_single,"r");
pclose(stream);

// estimate abundance using kallisto
/*
strcpy(gtf2fa,temp_dir);
strcat(gtf2fa,"/combine.gtf");
char gtf2fa_out[1000];
strcpy(gtf2fa_out,temp_dir);
strcat(gtf2fa_out,"/temp.fa");
GTF2FASTA gtf2fasta(gtf2fa,ref_genome,gtf2fa_out);
gtf2fasta.process();
strcpy(abundance_1,"kallisto index -i ");
strcat(abundance_1,temp_dir);
strcat(abundance_1,"/k_index ");
strcat(abundance_1,temp_dir);
strcat(abundance_1,"/temp.fa 2>log_index");
stream = popen(abundance_1,"r");
pclose(stream);

if (STRAND[0] == 's' && STRAND[1] == 'i' && STRAND[2] == 'n')
{
	strcpy(abundance_2,"kallisto quant -i ");
	strcat(abundance_2,temp_dir);
	strcat(abundance_2,"/k_index -t ");
	strcat(abundance_2,threads);
	strcat(abundance_2," -l 250 -s 50 ");
	strcat(abundance_2," -o ");
	strcat(abundance_2,temp_dir);
	strcat(abundance_2,"/k_results ");
	strcat(abundance_2,temp_dir);
	strcat(abundance_2,"/MyReads.fa --single 2>log_quant");
}
else
{
	strcpy(abundance_2,"kallisto quant -i ");
	strcat(abundance_2,temp_dir);
	strcat(abundance_2,"/k_index -t ");
	strcat(abundance_2,threads);
	strcat(abundance_2," -o ");
	strcat(abundance_2,temp_dir);
	strcat(abundance_2,"/k_results ");
	strcat(abundance_2,temp_dir);
	strcat(abundance_2,"/MyReads_1.fa ");
	strcat(abundance_2,temp_dir);
	strcat(abundance_2,"/MyReads_2.fa 2>log_quant");
}
stream = popen(abundance_2,"r");
pclose(stream);
*/
// generate final GTF file TransBorrow.gtf by setting cov >= c	
/*
strcpy(abundance_3,temp_dir);
strcat(abundance_3,"/k_results/abundance.tsv");
char path_abun_gtf[1000];
strcpy(path_abun_gtf,temp_dir);
strcat(path_abun_gtf,"/combine.gtf");
char path_final_gtf[1000];
strcpy(path_final_gtf,output_1);
strcat(path_final_gtf,"/TransBorrow.gtf");
Abundance abundance(abundance_3,path_abun_gtf,path_final_gtf,min_cov);
abundance.Process();
*/
/*
strcpy(rm_dir,"rm -rf ");
strcat(rm_dir,temp_dir);
stream = popen(rm_dir,"r");
pclose(stream);
*/
//YU
stringstream sss;
sss<<revise;
const char* Str_revise = sss.str().c_str();
FILE * stream_yu;
string path_yu = Path;
path_yu = path_yu.substr(0,path_yu.length() - 11);
char path_[1000];
strncpy(path_, path_yu.c_str(), path_yu.length() + 1); 
 char abdu[100000];
strcpy(abdu,path_);
strcat(abdu,"../src/transborrow_abundance ");
strcat(abdu,BAM);
strcat(abdu," -e ");
strcat(abdu," -G ");
//strcat(abdu," outdir/iPAC_temp.gtf");
strcat(abdu, temp_dir);
strcat(abdu, "/combine.gtf");
strcat(abdu," -o ");
strcat(abdu,output);
strcat(abdu," -f ");
strcat(abdu,Str_revise);
strcat(abdu," -c ");
strcat(abdu,min_cov);
stream_yu = popen(abdu,"r");
pclose(stream_yu);
char abd[1000];
return;
}

#endif

