#include<iostream>
#include<fstream>
#include<string>
#include<vector>
#include<sstream>
#include <getopt.h>
#include<stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h> //YU
#include "SCTie.h"
using namespace std;

const char * ref_gtf="";
const char * ref_genome="";
const char * bam="";
const char * strand="";
bool Help = false;
bool Version=false;
const char * output="TransBorrow_results"; //output_dir YU
int min_trans_len=200;
int cre_num=2;
double min_seed=0;
const char * min_cov="1"; //YU
const char * temp_dir="TransBorrow_tmp";
const char * threads="1";
const char * version="The current version is: v.1.2";
const char * short_opt="r:g:b:s:ho:l:n:d:c:t:vT:";
struct option long_opt[]={
    {"ref_gtf",1,0,'r'},
    {"ref_genome",1,0,'g'},
    {"bam",1,0,'b'},
    {"strand",1,0,'s'},
    {"help",0,0,'h'},
    {"output",1,0,'o'},
    {"min_trans_len",1,0,'l'},
    {"cre_num",1,0,'n'},
    {"min_seed",1,0,'d'},
    {"min_cov",1,0,'c'},
    {"threads",1,0,'t'},
    {"version",1,0,'v'},
    {"temp_dir",1,0,'T'},//YU
    {0,0,0,0}
};
string  usage(){
    stringstream use_info;
    use_info<<endl<<"================================================================"<<endl;
    use_info<<"Usage:"<<"\n"<<endl;
    use_info<<"  TransBorrow [options] -r <combined_assemblies> -g <reference_genome> -b <bam_file> -s <strand_info>"<<endl;
    use_info<<""<<endl;
    use_info<<"** Required **"<<"\n"<<endl
    <<"  --ref_gtf/-r <string>        "<<": Combined transcriptome assembled by different tools in GTF format (just combine the different assemblies into a GTF file, combine.gtf);"<<"\n"<<endl
    <<"  --ref_genome/-g <string>     "<<": Reference genome in FASTA format;"<<"\n"<<endl
    <<"  --bam/-b <string>            "<<": BAM file;"<<"\n"<<endl
    <<"  --strand/-s <string>         "<<": Strand-specific RNA-Seq reads orientation."<<"\n"<<endl
    <<"                                     If reads are paired:"<<"\n"<<endl
    <<"                                       1) Use <unstranded> to indicate RNA-seq reads are non-strand-specific;"<<"\n"<<endl
    <<"                                       2) Use <first> to indicate fr-first-stranded RNA-seq reads;"<<"\n"<<endl
    <<"                                       3) Use <second> to indicate fr-second-stranded RNA-seq reads;"<<"\n"<<endl
    <<"                                     If reads are single:"<<"\n"<<endl
    <<"                                       1) Use <single_unstranded> to indicate RNA-seq reads are non-strand-specific;"<<"\n"<<endl
    <<"                                       2) Use <single_forward> to indicate RNA-seq reads forward;"<<"\n"<<endl
    <<"                                       3) Use <single_reverse> to indicate NA-seq reads reverse;"<<"\n"<<endl//YU
    <<"** Optional **"<<"\n"<<endl
    <<"  --min_cov/-c <float>         "<<": Min coverage of recovered transcripts, default: 1;"<<"\n"<<endl
    <<"  --output/-o <string>         "<<": Output path, default: ./TransBorrow_results/TransBorrow.gtf;"<<"\n"<<endl
    <<"  --min_trans_len/-l <int>     "<<": Min length of recovered transcripts, default: 200;"<<"\n"<<endl
    <<"  --cre_num/-n <int>           "<<": Credible sub_paths assembled by at least this number of tools, default: 2;"<<"\n"<<endl
    <<"  --min_seed/-d <float>        "<<": Min seed coverage for extension, default: 0;"<<"\n"<<endl
    <<"  --temp_dir/-T <string>       "<<": Directory storing temporary files, default: ./TransBorrow_tmp;"<<"\n"<<endl//YU
    <<"  --threads/-t <int>           "<<": Number of threads to launch, default: 1;"<<"\n"<<endl
    <<"  --version/-v                 "<<": Show current version of TransBorrow;"<<"\n"<<endl
    <<"  --help/-h                    "<<": help infomation;"<<"\n"<<endl
    <<"** Typical commands **"<<"\n"<<endl
    <<"A typical TransBorrow command for paired-end data might be:"<<"\n"<<endl
    <<"  TransBorrow -r combine.gtf -g genome.fa -b file.bam -s first"<<"\n"<<endl;
    use_info<<"================================================================"<<endl;
    return use_info.str();
}
int parse_options(int argc,char*argv[]){
    int option_index=0;
    int next_option;
    while((next_option=getopt_long(argc,argv,short_opt,long_opt,&option_index)) != -1){
        switch(next_option){
	    case 'c':
                min_cov=optarg;
                break;
	    case 'r':
                ref_gtf=optarg;
                break;
	    case 'g':
                ref_genome=optarg;
                break;
	    case 'b':
                bam=optarg;
                break;
	    case 's':
                strand=optarg;
                break;
            case 'h':
                Help=true;
                break;
	    case 'v':
		Version=true;
		break;
            case 'o':
                output=optarg;
                break;
            case 'l':
                min_trans_len=atoi(optarg);
                break;
            case 'n':
                cre_num=atoi(optarg);
                break;
	    case 'T'://YU
		temp_dir=optarg;
		break;
            case 'd':
                min_seed=atof(optarg);
                break;
            case 't':
                threads=optarg;
                break;
            case '?':
                cout<<usage();
                exit(1);
        }
    }
    if(Version)
    {
        cout<<version<<endl;
        exit(1);
    }
    if(ref_gtf=="")
    {
        cout<<"Error : -r option needs an argument!! "<<endl;
        cout<<usage();
        exit(1);
    }
    if(ref_genome=="")
    {
        cout<<"Error : -g option needs an argument!! "<<endl;
        cout<<usage();
        exit(1);
    }
    if(bam=="")
    {
        cout<<"Error : -b option needs an argument!! "<<endl;
        cout<<usage();
        exit(1);
    }
    if(strand=="")
    {
        cout<<"Error : -s option needs an argument!! "<<endl;
        cout<<usage();
        exit(1);
    }
    if(Help) 
    {
	cout<<usage()<<endl;
     	exit(1);
    }
/*
    if(Version)
    {
	cout<<version<<endl;
	exit(1);
    }
*/
	return 0;
}

int main(int argc, char * argv[])
{
	parse_options(argc,argv);
	char RM[100000];
	if( (access( temp_dir, 0 )) != -1 )
	{
	    cout<<"[WARNING] : "<<temp_dir<<" exists already. It will be overwritten."<<endl;
	    FILE * stream;
	    strcpy(RM,"rm -r ");
	    strcat(RM,temp_dir);
	    stream = popen(RM,"r");
	    pclose(stream);
	}
	if( (access( output, 0 )) != -1 )
	{
	    cout<<"[WARNING] : "<<output<<" exists already. It will be overwritten."<<endl;
	    FILE * stream;
	    strcpy(RM,"rm -r ");
	    strcat(RM,output);
	    stream = popen(RM,"r");
	    pclose(stream);
	}
	SCTie sctie(ref_gtf,ref_genome,bam,strand,output,min_trans_len,cre_num,min_seed,min_cov,temp_dir,threads);
        sctie.Process();
return 0;
}




















