args=commandArgs(TRUE)
if(length(args)!=2)
{
	print("Usage: <hist.file> <op> ")
	q()
}
file=args[1]
op=args[2]

X=read.table(file)
pdf(paste(op,".JE.vs.size.pdf",sep=""))
par(mar=c(5,5,5,5))


plot(X$V5~X$V1, type='l', xlab='Size (bp)', ylab='CH Methylation in read2 (%)', cex.lab=1.5, cex.axis=1.5, ylim=c(0,50), xlim=c(80,600), main=op, lwd=1.5)
plot(X$V6~X$V1, type='l', xlab='Size (bp)', ylab='Averaged jagged end length (bp)', cex.lab=1.5, cex.axis=1.5, main=op, ylim=c(0,50),xlim=c(80,600), lwd=1.5)
dev.off()
