args=commandArgs(TRUE)
if(length(args)!=2)
{
	print("Usage: <data.file>  <outprefix> ")
	q()
}
file=args[1]
op=args[2]
n1=gsub(".jlen.hist", "",file)

pdf(paste(op, ".je.bar.pdf",sep=''))
par(mar=c(5,5,5,5))#, yaxs='r', xaxs='r')
par(xpd=TRUE)
dat=read.table(file, skip=1)

lg=c(seq(0,75,5))
pos=c(seq(2.5,154,10))

barplot(dat[,3], col=c('dodgerblue'), xaxt='n', xlab="Jagged end length (nt)", ylab="Frequency (%)", cex.lab=1.5, cex.axis=1.5, cex.main=1.5, beside=T, ylim=c(0,15), main=op, border=NA, space=c(1,2))
text(pos, -.8, lg,cex=1.5,srt=70)
axis(side=1,at=pos, label=FALSE)

dev.off()


