use strict;
use warnings;


if(@ARGV<1)
{
	warn "Usage: <*.J.bed ...> \n";
	exit 1;
}

my %h1; #mean
my %h2; #median
my %h3; #methylation
my %tot;
my %TOT;
while(<>)
{
	chomp;
#chr4	3779017	3779186	TTTAAATGTGTTGGATGTTTGGATGGGGAGTGGGTTGAATGTTAATTCGTGTTAGGGGTGATTTTTATTTTGTTT	ttCCCAAATGTGCTGGATGTCTGGATGGGGAGTGGGCTGAATGCCAACCCGTGCCAGGGGTGACCTCCACCCTGCCCtg	GTTTGTTTGGTTTTATTGGGTTTTTTTAGGGGTGGTAGGTGATTGTTTGTAGGATGAGATTAGGGAGAGGAGACC	atGCCTGCTTGGTCTCACTGGGCCCCTCCAGGGGTGGTAGGTGACTGTTTGTAGGATGAGATCGGGGAGAGGAGACCag	
#(7) R1C:0	R1T:22	R1CH:22	R2C:2	R2T:13	R2CH:15	STRAND:W	JPOS:-1	JLEN:0	JPASS:0	BLUNT:-1

	my @F=split;
	my @R1C=split /:/, $F[7];
	my @R1T=split /:/, $F[8];
	my @R1CH=split /:/, $F[9];
	my @R2C=split /:/, $F[10];
	my @R2T=split /:/, $F[11];
	my @R2CH=split /:/, $F[12];
	my @strand=split /:/, $F[13];
	my @jpos=split /:/, $F[14];
	my @jlen=split /:/, $F[15];
	my @jpass=split /:/, $F[16];
	my @blunt=split /:/, $F[17];
	my $len=$F[2]-$F[1];
	if($blunt[1] == 1 || $jlen[1] > 0)
	{
		$h1{$len}+=$jlen[1];
		$h2{$len}{$jlen[1]}++;
		$tot{$len}++;		
	}
	$h3{$len}{C}+=$R2C[1];
	$h3{$len}{T}+=$R2T[1];
	$TOT{$len}++;
}

for my $len (sort {$a<=>$b} keys %tot)
{
	my @jlen=sort {$a<=>$b} keys %{$h2{$len}};
	my $cum=0;
	my $idx=0;
	for my $j (@jlen)
	{
		$cum+=$h2{$len}{$j};
		my $diff=$cum/$tot{$len}*100-50;
		if($diff>0)
		{
			last;
		}
		$idx++;
	}
	my $median=($jlen[$idx-1]+$jlen[$idx])/2;
	
	print join("\t", $len, $TOT{$len}, $tot{$len}, $h2{$len}{0}||0,$h3{$len}{C}/($h3{$len}{C}+$h3{$len}{T})*100, $h1{$len}/$tot{$len}, $median), "\n";
	
}



