#script to process the score density per transcript
#maybe it's a good idea to split the motifs into individual files to accelorate the data processing (impemented)
#map can be generated by the following command, enrichMap(ego2), where ego2 is the object from the enrichGO cmd
# Also to visualize the complex association with: cnetplot(ego, categorySize="pvalue", foldChange=geneList)

library("plyr")
library("ggplot2")
library("topGO")
library("biomaRt")
library("clusterProfiler")
library("org.Hs.eg.db")
args=commandArgs(trailingOnly = T)

ovp=args[1]
namemap=args[2]
pval=args[3]
qval=args[4]


ID2HGNC=function(obj,ensembl){
  obj$HGNC=""
  for (i in 1:nrow(obj)){
    temID=strsplit(obj$geneID[i],"/")
    temsymbol=getBM(attributes='hgnc_symbol',filters = "ensembl_gene_id",values = temID, mart =ensembl )
    obj$HGNC[i]=paste(temsymbol$hgnc_symbol,collapse = "/")
  }
  as.data.frame(obj)
}

outfile=function(name,obj){
  if(file.exists(name)){
    write.table(obj,file=name,sep="\t",quote = F,append = T,row.names = F,col.names = F)
  }else{
    write.table(obj,file=name,sep="\t",quote = F,row.names = F,col.names = T)
  }
}
##Time stamp
tstring=Sys.Date()

## test data
# ovp="TACGCG40NCCG_EMO_GRUCGUGAUGN_m1_c4b0_short.pfm.ovp.gz"
# qval=0.01
# pval=0.01
# namemap="../../../../name_file.map.17Apr28.tsv"


###convert the ENSEMBL gene ID to HGNC_symbol
# gene.data <- getBM(attributes='hgnc_symbol',filters = "ensembl_gene_id",values = c("ENSG00000227551","ENSG00000227140"), mart =enseml )

##Data preparation
tab=read.table(ovp,sep="\t",quote = "")
nametab=read.table(namemap,sep="\t",quote = "")
namebase=sub(".ovp.gz",replacement="",x = ovp)
protein_name=paste(sep="-",as.character(nametab[grep(pattern = namebase,x=nametab$V8,perl=T),1]),as.character(nametab[grep(pattern = namebase,x=nametab$V8,perl=T),4]))

stab=aggregate(x=tab[,5]/(tab[,9]-tab[,8]),by=list(tab[,10],tab[,11],tab[,13]),FUN=sum)
names(stab)=c("gene","transcript","symbol","score.density")
human=useMart("ensembl",dataset = "hsapiens_gene_ensembl")
sstab=stab[order(stab$score.density,decreasing = T),]
top100=sstab[1:100,]
allgene=as.character(top100$transcript)

##another test data to validate whether the pipeline works
# ensembl=useMart("ensembl",dataset = "hsapiens_gene_ensembl")
# testgene <- getBM(attributes=c('hgnc_symbol', 'ensembl_gene_id', 'go_id'),filters = "go",values = 'GO:0036459', mart =human )
# totalgene=getBM(attributes = "ensembl_gene_id",mart = human)
# leftgene= subset(totalgene, ! ( totalgene$ensembl_gene_id %in% testgene$ensembl_gene_id ))


##perform the enrichment analysis for the following 3 parts: Cellular component, Biological process and Molecular function 

egoCC <- enrichGO(gene= allgene,OrgDb = org.Hs.eg.db, keyType = "ENSEMBL",ont = "CC", pAdjustMethod = "BH",pvalueCutoff = as.numeric(pval),qvalueCutoff = as.numeric(qval))
egoBP <- enrichGO(gene= allgene,OrgDb = org.Hs.eg.db, keyType = "ENSEMBL",ont = "BP", pAdjustMethod = "BH",pvalueCutoff = as.numeric(pval),qvalueCutoff = as.numeric(qval))
egoMF <- enrichGO(gene= allgene,OrgDb = org.Hs.eg.db, keyType = "ENSEMBL",ont = "MF", pAdjustMethod = "BH",pvalueCutoff = as.numeric(pval),qvalueCutoff = as.numeric(qval))

##output the result into a table 
sumCC=as.data.frame(egoCC)
sumBP=as.data.frame(egoBP)
sumMF=as.data.frame(egoMF)
if(nrow(sumCC) >=1 ){
  sumCC=ID2HGNC(sumCC,human)
  sumCC[,c("protein","function")]=list(protein_name,"CC")
  tabheader=colnames(sumCC)
  newtabheader=c(tabheader[11:12],tabheader[1:10])
  nsumCC=sumCC[,newtabheader]
  outfile_CCname=paste("GOenrich-CC",tstring,".tsv",sep="")
  outfile(outfile_CCname,nsumCC)  
}
if(nrow(sumBP) >=1 ){
  sumBP=ID2HGNC(sumBP,human)
  sumBP[,c("protein","function")]=list(protein_name,"BP")
  tabheader=colnames(sumBP)
  newtabheader=c(tabheader[11:12],tabheader[1:10])
  nsumBP=sumBP[,newtabheader]
  outfile_BPname=paste("GOenrich-BP",tstring,".tsv",sep="")
  outfile(outfile_BPname,nsumBP)
}

if(nrow(sumMF) >=1 ){
  sumMF=ID2HGNC(sumMF,human)
  sumMF[,c("protein","function")]=list(protein_name,"MF")
  tabheader=colnames(sumMF)
  newtabheader=c(tabheader[11:12],tabheader[1:10])
  nsumMF=sumMF[,newtabheader]
  outfile_MFname=paste("GOenrich-MF",tstring,".tsv",sep="")
  outfile(outfile_MFname,nsumMF)  
}




#### Alternative method to perform the GOenrichment with TOPGO package, idea dropped(due to id conversion problems and complicated result manipulation)
# allgene=rep(1,100)
# names(allgene)=as.character(top100$transcript)
# GOdata <- new("topGOdata", ontology = "BP", allGenes = all, geneSel = function(p) p < 0.01, description = "Test", annot = annFUN.org, mapping = "org.Hs.eg.db", ID = "Ensembl")
# resultFisher <- runTest(GOdata, algorithm = "classic", statistic = "fisher")
# filtresult=GenTable(GOdata, classicFisher = resultFisher, topNodes = 10)
# write.table(filtresult,file=paste(ovp,".GO.tsv",sep=""),quote = F,col.names = F,row.names = F)
