
#script to generate Fig.4A-F
#the dendrogram generated by aligning the amino acid sequences of the RBD (from the first amino acid of the 1st RBD to the ending amino acid of the last RBD) through PRANK.
#guide file can be re-constructed from the meta of each motif included in Supplemental Tables S2 and S3, tab sparated.
#png files must be provided.

#arguments: 1, tree file, 2,splited guide file; 3. offset for png file after tip label
#update 2017 Jan 03, considering the size of the png files, according to the seed length

#update 2017 Apr 18, scale the width of the motif according to the array width, the plots must have the same height
#update 2017 May 22, change to two pdf files with same height


library(ape)
library(png)
#library(ggplot2)
#library(extrafont)
args <- commandArgs(trailingOnly = TRUE)

treefile=args[1]
guidefile=args[2]
#pngoffset=as.numeric(args[3])
stemloop=args[3]

outnamebase=gsub(".dnd","",treefile,perl=TRUE)
tstring=gsub(" .*$","",Sys.time(),perl=TRUE)
outname=paste(outnamebase,tstring,"tree-p1.pdf",sep=".")
pngoutfile=paste(outnamebase,tstring,"tree-p2.pdf",sep=".")

tree =read.tree(treefile)
name=read.table(guidefile,sep="\t")
slm=read.table(stemloop, sep="\t")

nname=name[,2:ncol(name)]
rownames(nname)=name[,1]
treeorder=tree$tip.label
treemark=data.frame(treeorder,"0")
colnames(treemark)=c("treeorder","status")
treemark$star=""
treemark$status=treeorder %in% slm$V1 * 1
treemark$star[treemark$status ==1]="*"

twostar=subset(slm,V2==0)
treemark$star[treemark$treeorder %in% twostar$V1]="**"
newtreelabel=paste(treemark$treeorder,treemark$star,sep="")
tree$tip.label=newtreelabel


pngtable=nname[treeorder,]
pngfile=paste("tree_motif2017May18/",pngtable$V8,sep="")
file_height=if(round(length(pngfile)/2) >=14) round(length(pngfile)/2) else 5
file_width=round(0.75*length(pngfile)/2)


pdf(width=3,height=file_height,outname)
plot.phylo(tree,type="p",use.edge.length=F,show.tip.label=T, cex=1)
dev.off()

pdf(pngoutfile,height=14)
plot("",xlim=c(0,18),ylim=c(0,34), xaxt="n",yaxt="n",bty="n")
pxi=2
pyi=0
for(i in 1:length(pngfile)){
  img=readPNG(pngfile[i])
  img_width=ncol(img)/100
  rasterImage(img,pxi,pyi-0.5,pxi+img_width,pyi)
  text(pxi -2 ,pyi-0.25,cex=0.5,treemark$treeorder[i])
  text(pxi+img_width +0.5 ,pyi-0.25,cex=0.5,treemark$star[i])
  pyi=pyi+ 0.6
}
dev.off()
