#!/usr/bin/perl -w
use strict;
use File::Basename;
use Data::Dumper;
use PerlIO::gzip;
use SVG;
use Getopt::Long;

#script to generate the stem shaded logos for structured motifs

my $type;

GetOptions(
	't:s'=>\$type
);

$type ||='rna';

my $pwm=shift;
my $info=shift;
my $pwm_basename=basename $pwm;
open OUT,">$pwm_basename.svg";
my ($stem,$loop)=($1,$2) if($info=~/(\d+),(\d+)/);
my %matrix;
my $A="m 6.8910692,-2.720526 -3.7670144,0 -0.3782159,1.030503 0.3782159,0 q 0.5597597,0 0.7942476,0.230832 0.2344959,0.230832 0.2420559,0.618304 0,0.370975 -0.2344879,0.601807 Q 3.6913745,-0.008248 3.1240548,0 L 1.0363116,0 Q 0.47655181,0 0.24205591,-0.230832 0.00756801,-0.461664 0,-0.849135 0,-1.228359 0.24962391,-1.467439 0.49923981,-1.706511 1.0741276,-1.690023 l 2.435703,-6.611698 -1.0136156,0 q -0.5597598,0 -0.7942477,-0.230832 -0.2344959,-0.23084 -0.2420559,-0.618304 0,-0.379223 0.2344879,-0.610055 0.2344959,-0.230832 0.8018157,-0.23908 l 3.3509827,0.0082 3.0862308,8.301721 q 0.544632,0 0.718608,0.131904 0.34796,0.272056 0.34796,0.717232 0,0.370975 -0.234496,0.601807 -0.234488,0.230832 -0.794248,0.23908 l -2.0877433,0 q -0.5597597,0 -0.7942556,-0.230832 -0.2344879,-0.230832 -0.2420559,-0.618303 0,-0.370976 0.2344959,-0.601816 0.2344879,-0.230832 0.8018156,-0.239072 l 0.3782159,0 -0.3706559,-1.030503 z M 6.2481095,-4.410549 4.999998,-7.757618 l -1.2556715,3.347069 2.503783,0 z";
my $C="m 7.9562048,-9.347881 q 0.1733519,-0.204239 0.3740799,-0.306359 0.2007359,-0.10212 0.4470878,-0.10212 0.410584,0 0.666056,0.243512 0.255472,0.243519 0.2646,0.824815 l 0,1.366839 q 0,0.581295 -0.25548,0.824815 -0.255472,0.243512 -0.675176,0.251368 -0.3740879,0 -0.6021918,-0.180672 Q 7.9470768,-6.606355 7.8375889,-7.10125 7.7737489,-7.43117 7.582117,-7.611842 7.2080291,-7.965338 6.5419654,-8.177434 5.8759096,-8.389529 5.1916059,-8.389529 q -0.8394156,0 -1.5419754,0.314215 -0.7025517,0.314216 -1.2408715,1.0212 -0.5383197,0.706983 -0.5383197,1.681046 l 0,1.044767 q 0,1.162599 0.9762716,1.940279 0.9762796,0.777679 2.7281029,0.777679 1.0401436,0 1.7609513,-0.243512 0.4197038,-0.141399 0.8941596,-0.557735 0.2919679,-0.251368 0.4561998,-0.322072 0.16424,-0.07072 0.374088,-0.07856 0.374088,0 0.656936,0.24352 0.282848,0.243512 0.282848,0.57344 0,0.329927 -0.383208,0.706983 -0.556576,0.54988 -1.4324878,0.864095 Q 7.0072932,0 5.5839418,0 3.9233584,0 2.591239,-0.589152 1.5145994,-1.060471 0.75729571,-2.073814 0,-3.087158 0,-4.296885 L 0,-5.38878 Q 0,-6.645643 0.67518371,-7.729682 1.3503675,-8.813729 2.563871,-9.410736 q 1.2135035,-0.597008 2.554743,-0.589152 0.8120396,0 1.5145913,0.157112 0.7025598,0.157104 1.3229995,0.494887 z";
my $G="m 9.2454565,-3.181462 0,2.160255 Q 8.0399288,-0.432048 7.1986567,-0.219952 6.3573851,-0.007856 5.3686815,0 4.007034,0 2.8448665,-0.369208 1.9342188,-0.652 1.413843,-1.084055 0.89346721,-1.516103 0.44248341,-2.356638 -0.00850839,-3.197173 1.6360563e-4,-4.249797 l 0,-1.162607 q 0,-1.610374 1.08411159437,-2.875101 1.4570394,-1.712487 3.9635024,-1.712487 0.7285277,0 1.3789914,0.133544 0.6504638,0.133544 1.2488955,0.400624 0.3555843,-0.290648 0.6938322,-0.290648 0.3902798,0 0.6331198,0.24352 0.24284,0.243519 0.24284,0.824823 l 0,1.044775 q 0,0.581304 -0.24284,0.824823 -0.24284,0.24352 -0.6417918,0.251368 -0.3122239,0 -0.5377202,-0.172816 Q 7.6496485,-6.857811 7.5368966,-7.258442 7.4241526,-7.659066 7.2680407,-7.808322 7.0338728,-8.03613 6.444113,-8.208945 5.8543613,-8.381769 5.1084896,-8.389625 q -1.0580876,0 -1.8386473,0.392775 -0.5550638,0.290648 -1.0233996,1.013352 -0.4683358,0.722703 -0.4683358,1.571094 l 0,1.162607 q 0,1.296143 0.8239197,1.963863 0.8239276,0.667711 2.6365589,0.675567 1.2228715,0 2.2289271,-0.416343 l 0,-1.154752 -1.8126313,0 q -0.6417917,0 -0.9106476,-0.219951 -0.2688639,-0.219952 -0.2775359,-0.58916 0,-0.361352 0.2688559,-0.581303 0.2688639,-0.219952 0.9193276,-0.227808 l 3.1569272,0.008 q 0.6418,0 0.910656,0.219952 0.268856,0.219951 0.2775365,0.581303 0,0.2828 -0.1821365,0.494896 -0.182128,0.212096 -0.572408,0.314215 z";
my $T="m 5.9510296,-8.301721 0,6.611698 1.2994395,0 q 0.6967997,0 0.9886956,0.230832 0.2919039,0.230832 0.3013199,0.618304 0,0.370975 -0.2919039,0.601807 Q 7.9566848,-0.008248 7.2504691,0 L 2.7306949,0 Q 2.0338952,0 1.7419993,-0.230832 1.4500954,-0.461664 1.4406794,-0.849135 q 0,-0.370976 0.2919039,-0.601816 0.2918959,-0.230832 0.9981116,-0.239072 l 1.2900155,0 0,-6.611698 -2.0903912,0 0,1.599334 q 0,0.610056 -0.2636559,0.865624 -0.2636479,0.255567 -0.70621569,0.263807 -0.4237278,0 -0.6873757,-0.255567 Q 0.00941601,-6.084083 0,-6.702387 l 0,-3.297605 9.9999965,0.0082 0,3.289357 q 0,0.610056 -0.263656,0.865624 -0.263648,0.255567 -0.706216,0.263807 -0.4237279,0 -0.6873758,-0.255567 -0.2636559,-0.25556 -0.2730719,-0.873864 l 0,-1.599334 -2.1186472,0 z";
my $U="m 1.0966549,-8.8225952 0,5.1428531 c 0,2.3025166 1.5799292,3.68066910008 3.9219361,3.68066910008 2.6394046,0 3.9405131,-1.31092600008 3.9405131,-3.98318990008 l 0,-4.8403323 c 0.037178,0 0.092936,0 0.130111,0 0.6691451,0 0.9107811,-0.1344542 0.9107811,-0.5882348 0,-0.386554 -0.204461,-0.588235 -0.650557,-0.588235 -0.1487001,0 -0.278812,0 -0.42751,0 l -2.0074259,0 c -0.6691449,0 -0.985131,0.06722 -0.985131,0.588235 0,0.4873935 0.353161,0.5882348 1.1895921,0.5882348 0.1486989,0 0.3159855,0 0.4832717,0 l 0,4.6554585 c 0,1.9999961 -0.6691472,2.9915941 -2.4907082,2.9915941 -0.9107805,0 -1.710039,-0.3865551 -2.1375483,-1.0588229 C 2.5650578,-2.8898264 2.5650574,-3.5452893 2.5650574,-4.318397 l 0,-4.5041982 c 0.1486989,0 0.2788108,0 0.3903349,0 0.7992565,0 1.1338299,-0.1008413 1.1338299,-0.5882348 0,-0.571428 -0.3717481,-0.588235 -1.1338299,-0.588235 l -1.8587374,0 C 0.37174808,-9.999065 0,-9.965445 0,-9.41083 c 0,0.4537806 0.2602238,0.5882348 0.87360628,0.5882348 0.07435,0 0.14869912,0 0.22304862,0 z";

my %bpath=('A'=>$A,'C'=>$C,'G'=>$G,'U'=>$U,'T'=>$T);
my %color=('A'=>"green",'C'=>"blue",'G'=>"orange",'U'=>"red",'T'=>"red");

my $basenum;
my %freq;
open IN, "<",$pwm;
while(<IN>){
	chomp;
	my @bA=split  /\s+/;
	my $line2=<IN>; my @bC=split /\s+/, $line2;
	my $line3=<IN>; my @bG=split /\s+/, $line3;
	my $line4=<IN>; my @bT=split /\s+/, $line4;
	$basenum=$#bA;
for(my $i=0; $i<= $basenum; $i++){
	push @{$freq{'A'}},$bA[$i]/($bA[$i]+$bC[$i]+$bG[$i]+$bT[$i]);
	push @{$freq{'C'}},$bC[$i]/($bA[$i]+$bC[$i]+$bG[$i]+$bT[$i]);
	push @{$freq{'G'}},$bG[$i]/($bA[$i]+$bC[$i]+$bG[$i]+$bT[$i]);
	push @{$freq{'T'}},$bT[$i]/($bA[$i]+$bC[$i]+$bG[$i]+$bT[$i]) if($type =~ /dna/); 
	push @{$freq{'U'}},$bT[$i]/($bA[$i]+$bC[$i]+$bG[$i]+$bT[$i]) if($type =~ /rna/); 
}
#
#	$matrix{'C'}=[@bC];
#	$matrix{'G'}=[@bG];
#	$matrix{'T'}=[@bT];
}
close IN;

my ($figure_height,$figure_width);
$figure_height=100;
my $base_width=20;
$figure_width=$base_width* ($basenum+1);
my $s=SVG->new('width',$figure_width,'height',$figure_height);
my ($xstart,$ystart)=(0,100);
#print Dumper(%freq);
$s->rect('x',0,'y',0,'height',100,'width',$stem*$base_width,'stroke',"none",'fill',"grey",'fill-opacity',0.5);
$s->rect('x',($loop+$stem)*$base_width,'y',0,'height',100,'width',$stem*$base_width,'stroke',"none",'fill',"grey",'fill-opacity',0.5);

for(my $i=0; $i<= $basenum; $i++){
	my %tem;
	%tem=('A'=>$freq{'A'}->[$i],'C'=>$freq{'C'}->[$i],'G'=>$freq{'G'}->[$i],'T'=>$freq{'T'}->[$i]) if($type =~ /dna/);
	%tem=('A'=>$freq{'A'}->[$i],'C'=>$freq{'C'}->[$i],'G'=>$freq{'G'}->[$i],'U'=>$freq{'U'}->[$i]) if($type =~ /rna/);
	for my $k (sort {$tem{$a} <=> $tem{$b}} keys %tem){
		my $tmx=$xstart+ $i*$base_width;
		my $fold=$tem{$k}*100/10;
		$s->path('d',$bpath{$k},'fill',$color{$k},'transform',"translate($tmx,$ystart) scale(2,$fold)");
		$ystart-=100* $tem{$k};
	}
	$ystart=100;
}

print OUT $s->xmlify();

#letters
