%%

currGene = 'CHA1';
gn = GP.gene_table.(currGene);
% WT - deltaCha4
% conditions: 1) YPD, 2) Low N
currConditions = {'YPD', 'low N'};

wts_cond1 = cell(1, 4);
delta_cond1 = cell(1, 4);
deltaResult_cond1 = nan(2, 4);
deltaResults_cond1_vals = cell(1,4);
for i = 1:4
    currEntry = ['WCD', gb{i}];
    deltaIdx = find(contains(dataLabels.(currEntry), 'CHA4 TP1'));
    delta_cond1{i} = dataLabels.(currEntry)(deltaIdx);
    wtIdx = find(contains(dataLabels.(currEntry), 'WT TP1'));
    wts_cond1{i} = dataLabels.(currEntry)(wtIdx);
    
    expDelta = dataS.(currEntry)(gn, deltaIdx); 
    expWT = dataS.(currEntry)(gn, wtIdx);
    d = expDelta - nanmedian(expWT);
    deltaResults_cond1_vals{i} = d;
    d1 = nanmean(d);
    d2 = nanstd(d);
    deltaResult_cond1(:, i) = [d1; d2];
end

wts_cond2 = cell(1, 4);
delta_cond2 = cell(1, 4);
deltaResult_cond2 = nan(2, 4);
deltaResults_cond2_vals = cell(1,4);
for i = 1:4
    currEntry = ['WCD', gb{i}];
    deltaIdx = find(contains(dataLabels.(currEntry), 'CHA4 TP2'));
    delta_cond2{i} = dataLabels.(currEntry)(deltaIdx);
    wtIdx = find(contains(dataLabels.(currEntry), 'WT TP2'));
    wts_cond2{i} = dataLabels.(currEntry)(wtIdx);
    
    expDelta = dataS.(currEntry)(gn, deltaIdx); 
    expWT = dataS.(currEntry)(gn, wtIdx);
    d = expDelta - nanmedian(expWT);
    deltaResults_cond2_vals{i} = d;
    d1 = nanmean(d);
    d2 = nanstd(d);
    deltaResult_cond2(:, i) = [d1; d2];
end

wts_cond3 = cell(1, 4);
delta_cond3 = cell(1, 4);
deltaResult_cond3 = nan(2, 4);
deltaResults_cond3_vals = cell(1,4);
for i = 1:4
    currEntry = ['WCD', gb{i}];
    deltaIdx = find(contains(dataLabels.(currEntry), 'CHA4 TP3'));
    delta_cond3{i} = dataLabels.(currEntry)(deltaIdx);
    wtIdx = find(contains(dataLabels.(currEntry), 'WT TP3'));
    wts_cond3{i} = dataLabels.(currEntry)(wtIdx);
    
    expDelta = dataS.(currEntry)(gn, deltaIdx); 
    expWT = dataS.(currEntry)(gn, wtIdx);
    d = expDelta - nanmedian(expWT);
    deltaResults_cond3_vals{i} = d;
    d1 = nanmean(d);
    d2 = nanstd(d);
    deltaResult_cond3(:, i) = [d1; d2];
end
%%

figure; hold on;
bar([deltaResult_cond1(1, :), deltaResult_cond2(1, :), deltaResult_cond3(1, :)], 'FaceColor', rgb('lightblue')); 
errorbar([deltaResult_cond1(1, :), deltaResult_cond2(1, :), deltaResult_cond3(1, :)],...
    [deltaResult_cond1(2, :), deltaResult_cond2(2, :), deltaResult_cond3(2, :)], '.b');
plotSpread(horzcat(deltaResults_cond1_vals,deltaResults_cond2_vals, deltaResults_cond3_vals));
plot([4.5 4.5], ylim, 'k');
plot([8.5 8.5], ylim, 'k');
ylabel('log2 (mut/WT)');
set(gca, 'xtick', 1:12, 'xticklabels', {'cer', 'par', 'hyb.cer', 'hyb.par'}); xtickangle(90);
box on; 
% axis square; 
set(gca, 'fontsize', fs);
yl = get(gca, 'ylim');
text(1, yl(2)-1, 'YPD', 'fontsize', fs);
text(5, yl(2)-1, 'low N, 1 h', 'fontsize', fs);
text(9, yl(2)-1, 'low N, 16 h', 'fontsize', fs);
set(gcf, 'color', 'w');

