% figure S 7

examples_4_scatters('PGM1', {});
%%
genes = {'TDH3', 'FBA1', 'PDC1', 'ADH1', 'ENO2', 'CDC19', 'PGK1', 'GPM1', 'TDH2', 'TPI1', 'CPR1', ...
    'PGI1', 'AHP1', 'TMA19'};
glycolysisSGD = {'PGI1', 'PFK1', 'PFK2', 'FBP1', 'FBA1', 'TPI1', 'TDH1', 'TDH2', 'TDH3', 'PGK1', 'GPM1', ...
    'ENO2', 'ENO1', 'PYK2', 'CDC19'};
genes = allGenes(OGtable.vals{183});

coexpressed_with_TDH3 = {'TDH3', 'TDH2', 'ENO2', 'TDH1', 'ENO1', 'CCW12', 'FBA1', 'PGK1', 'CDC19', 'TPI1', 'ADH1'};

genes = coexpressed_with_TDH3;

Rs = nan(length(genes), 4);
for i = 1:length(genes)
    [f, currRs] = corr_two_genes2('PGM1', genes{i});    
    close(f);
    Rs(i, :) = currRs;
end

figure; 
% bar(Rs')
% legend(genes);
boxplot(Rs); hold on;
plotSpread(Rs)
ylabel('Regulatory similarity');
set(gca, 'xtick', 1:4, 'xticklabels', {'cer', 'par', 'hyb.cer', 'hyb.par'}); xtickangle(90);
axis square;
set(gcf, 'color', 'w');
ylim([-1 1]);
title('Regulatory similarity to Glycolytic genes');
fs = 16;
set(gca, 'fontsize', fs);
grid on;
%%


plot_enrichment_allSpecies('LSO2', {'Protein synthesis', 'amino-acid biosynthesis'});
