% figure S 5
nnCorrCer = nnWithinGenome.secondOrder.corrs(:, 1);
nnCorrPar = nnWithinGenome.secondOrder.corrs(:, 2);
x = nnCorrCer(goodGenes);
y = nnCorrPar(goodGenes);

% color code: distance from diagonal of E
x1 = obs_all_gg(:, 3); % cer-hyc
y1 = obs_all_gg(:, 4); % par-hyp
z = point_to_line_distance([x1, y1], [-1 -1], [1 1]);
z(y1 > x1) = -z(y1 > x1);

exampleGenes = {'MSF1', 'ERG12'};
listOfGenes = allGenes(intint(goodGenes));
exampleGenesIdx = ismember_smart(listOfGenes, exampleGenes);

figure;
scatter(x, y, sz, [.7 .7 .7]);
hold on;
scatter(x(gList), y(gList), sz, z(gList), 'filled', 'MarkerEdgeColor', 'k');
xlabel('Rc, cer - NNcer');
ylabel('Rc, par - NNpar');
axis square; grid on; box on; set(gca, 'fontsize', fs);
text(x(exampleGenesIdx), y(exampleGenesIdx), listOfGenes(exampleGenesIdx), 'fontsize', fs);
axis([.5 1 .5 1]);
set(gca, 'xtick', .5:.1:1, 'ytick', .5:.1:1);
nnTh = 0.85;
plot([nnTh nnTh], ylim, 'k--');
plot(xlim, [nnTh nnTh], 'k--');
% cm = cbrewer2('RdBu'); cm = cm(end:-1:1, :); 
cm = redblue;
colormap(cm); caxis([-.8 .8]);
cb = colorbar; cb.Label.String = 'Dominance';
set(gcf, 'color', 'w');
%%

figure; scatter(obs_all_gg(:, 3), obs_all_gg(:, 4), [], [.7 .7 .7]);
hold on;
diffTh = 0.2;
xl = [-0.8 1];
plot(xl, xl + diffTh, 'k--');
plot(xl+diffTh, xl, 'k--');
plot(xl, xl, 'k');
axis([xl(1) xl(2) xl(1) xl(2)]);
cm = cbrewer2('Blues'); cm = cm(end:-1:1, :);
colormap(cm);

xlabel('Rc, cer - hybrid cer');
ylabel('Rc, par - hybrid par');
axis square; grid on; box on; set(gca, 'fontsize', fs);
set(gcf, 'color', 'w');