% A: distributions of controls in all datasets
distsToPlot = {exp_all(goodGenes, :), nnWithinGenome.secondOrder.corrs(:, 1:4)};
titles = {'dataset control', 'Nearest Neighbor'};
figure; 
for j = 1:2
    subplot(1,2,j);
    dists = distsToPlot{j};
    hold on;
    for i = 1:size(dists, 2)
        d = dists(:, i);
        [ycdf, xcdf] = cdfcalc(d);
        yccdf = 1-ycdf(1:end-1);
        %     yccdf = ycdf(1:end-1);
        plot(xcdf, yccdf, '.-');
    end
    title(titles{j});
    ylabel('cumulative fraction of genes');
    xlabel('Rc');
    legend({'cer', 'par', 'hyb.cer', 'hyb.par'}, 'location', 'southwest');
    axis square; grid on; box on;
end
set(gcf, 'color', 'w');
%% B: # trans > # cis independent of the threshold
thComparative = 0.5:-.1:0;
thControl = 0.5:.1:.8;
xlabels = cellfun(@num2str, num2cell(thControl), 'UniformOutput', false);
ylabels = cellfun(@num2str, num2cell(thComparative), 'UniformOutput', false);
transMat = zeros(length(thComparative), length(thControl));
cisMat = zeros(length(thComparative), length(thControl));
for i = 1:length(thComparative)
    currThComparative = thComparative(i);
    for j = 1:length(thControl)
        currThControl = thControl(j);
        currTrans = find(obs_all(goodGenes, 1) < currThComparative & obs_all(goodGenes, 2) > currThControl);
        currCis = find(obs_all(goodGenes, 2) < currThComparative & expH(goodGenes) > currThControl);
        transMat(i,j) = length(currTrans);
        cisMat(i,j) = length(currCis);
    end
end

toPlot = {transMat, cisMat};
titles = {'trans', 'cis'};
figure; 
for i = 1:2
    currMat = toPlot{i};
    subplot(1,3,i); imagesc(currMat); 
    set(gca, 'xtick', 1:length(xlabels), 'xticklabels', xlabels);
    set(gca, 'ytick', 1:length(ylabels), 'yticklabels', ylabels);
    caxis([0 700]);
    title(titles{i});
    ylabel('comparative Th');
    xlabel('Control Th');
    cb = colorbar; cb.Label.String = '# genes pass Th';
end
s3 = subplot(1,3,3); imagesc(transMat - cisMat);
% cm1 = cbrewer2('RdBu'); cm1 = cm1(end:-1:1, :);
% colormap(s3, cm1);
title('# trans - # cis');
set(gca, 'xtick', 1:length(xlabels), 'xticklabels', xlabels);
set(gca, 'ytick', 1:length(ylabels), 'yticklabels', ylabels);
cb = colorbar; cb.Label.String = '# trans - # cis';
set(gcf, 'color', 'w');
%%