%%
run([homeDir, 'revision/DESeq_normalization/cis_trans_per_condition_after_DESeq.m']);

%% compensating vs. reinforcing

Ncomp = nan(nC, 1);
Nrein = nan(nC, 1);
for i = 1:nC
    currCis = comparable_samples_de.cis(:, i);
    currTrans = comparable_samples_de.trans(:, i);
    currCisGenes = intersect(find(abs(currCis) > currLfcTh), cisGenes);
    currTransGenes = intersect(find(abs(currTrans) > currLfcTh), transGenes);
    cisAndTransGenes = intersect(currCisGenes, currTransGenes);
    signCis = sign(currCis);
    signTrans = sign(currTrans);
    sameSign = find(signCis(cisAndTransGenes) == signTrans(cisAndTransGenes));
    diffSign = find(signCis(cisAndTransGenes) ~= signTrans(cisAndTransGenes));
    Nrein(i) = length(sameSign);
    Ncomp(i) = length(diffSign);
end

% figure; scatter(Nrein, Ncomp, [], corr_cis_trans); hold on;
% cb = colorbar(); cb.Label.String = 'correlation cis,trans';
figure; scatter(Nrein, Ncomp); hold on;
xlabel('# Reinforcing');
ylabel('# Compensating');
axis([0 150 0 150]);
grid on; axis square; box on;
plot(xlim, ylim, 'k');
NreinMedian = median(Nrein);
NcompMedian = median(Ncomp);
scatter([NreinMedian NreinMedian], [NcompMedian NcompMedian], [], 'filled', 'r');
plot([NreinMedian NreinMedian], [0 NcompMedian], ':k');
plot([0 NreinMedian], [NcompMedian NcompMedian], ':k');
set(gca, 'fontsize', fs);
set(gcf, 'color', 'w');
%% functional enrichment
bords = [111, 208, 317, 360, 403, 418, 433, 462];
conds = {'TP1 YPD', 'TP2 low N, 1 h', 'TP3 low N, 16 h', 'Cell Cycle 1', 'Cell Cycle 2',...
    'GC, WT', 'GC, \DeltaHAP4', 'no Phosphate'};
        
ctpc2 = struct;
ctpc2.cis = cell(nC, 1);
ctpc2.trans = cell(nC, 1);
for i = 1:nC
    ctpc2.cis{i} = cisGenes(find(genes_cond_cis(cisGenes, i)));
    ctpc2.trans{i} = transGenes(find(genes_cond_trans(transGenes, i)));
end

cistrans_per_condition_functionalEnrichment;