% genetic interaction evidence

currGene = 'VTC3';
gn = GP.gene_table.(currGene);
% WT - deltaPho4
% in 1) no Pi (3 h), 2) YPD
currConditions = {'no Pi', 'YPD'};

wts_cond1 = cell(1, 4);
delta_cond1 = cell(1, 4);
deltaResult_cond1 = nan(2, 4);
deltaResults_cond1_vals = cell(1,4);
for i = 1:4
    currEntry = ['WCD', gb{i}];
    deltaIdx = find(contains(dataLabels.(currEntry), 'PHO4 17'));
    delta_cond1{i} = dataLabels.(currEntry)(deltaIdx);
    currRegexp = ['WT [1-2][0-8] ', gb{i}, ' SCtoLowPi'];
    wtIdx = find(~cellfun(@isempty, regexp(dataLabels.(currEntry), currRegexp)));
    wts_cond1{i} = dataLabels.(currEntry)(wtIdx);
    
    expDelta = dataS.(currEntry)(gn, deltaIdx); 
    expWT = dataS.(currEntry)(gn, wtIdx);
    d = expDelta - nanmedian(expWT);
    deltaResults_cond1_vals{i} = d;
    d1 = nanmean(d);
    d2 = nanstd(d);
    deltaResult_cond1(:, i) = [d1; d2];
end
    
wts_cond2 = cell(1, 4);
delta_cond2 = cell(1, 4);
deltaResult_cond2 = nan(2, 4);
deltaResults_cond2_vals = cell(1,4);
for i = 1:4
    currEntry = ['WCD', gb{i}];
    deltaIdx = find(contains(dataLabels.(currEntry), 'PHO4 TP1'));
    delta_cond2{i} = dataLabels.(currEntry)(deltaIdx);
    wtIdx = find(contains(dataLabels.(currEntry), 'WT TP1'));
    wts_cond2{i} = dataLabels.(currEntry)(wtIdx);
    
    expDelta = dataS.(currEntry)(gn, deltaIdx); 
    expWT = dataS.(currEntry)(gn, wtIdx);
    d = expDelta - nanmedian(expWT);
    deltaResults_cond2_vals{i} = d;
    d1 = nanmean(d);
    d2 = nanstd(d);
    deltaResult_cond2(:, i) = [d1; d2];
end
%%

figure; 
subplot(1,2,1); hold on;
bar([deltaResult_cond1(1, :), deltaResult_cond2(1, :)], 'FaceColor', rgb('lightblue')); 
errorbar([deltaResult_cond1(1, :), deltaResult_cond2(1, :)], [deltaResult_cond1(2, :), deltaResult_cond2(2, :)], '.b');
plotSpread(horzcat(deltaResults_cond1_vals, deltaResults_cond2_vals));
plot([4.5 4.5], ylim, 'k');
ylabel('log2 (mut/WT)');
set(gca, 'xtick', 1:8, 'xticklabels', {'cer', 'par', 'hyb.cer', 'hyb.par'}); xtickangle(90);
box on; 
axis square; 
set(gca, 'fontsize', fs);
yl = get(gca, 'ylim');
text(1, yl(2)-1, currConditions{1}, 'fontsize', fs);
text(5, yl(2)-1, currConditions{2}, 'fontsize', fs);
