% figure 5 revision
% examples
exampleGenes = {'VTC3', 'CHA1'};
listOfGenes = allGenes(intint(goodGenes));
exampleGenesIdx = ismember_smart(listOfGenes, exampleGenes);

obs_all_gg = obs_all(goodGenes, :);
exp_all_gg = exp_all(goodGenes, :);
load('Rc_genes.mat', 'Rc_trans');
transGenes = Rc_genes.Rc_trans;
gList = find(ismember(intint(goodGenes), transGenes));
sz = 50;
fs = 14;
%% E
x = obs_all_gg(:, 3); % cer-hyc
y = obs_all_gg(:, 4); % par-hyp
z = obs_all_gg(:, 1); % species
% x = zscore(x); y = zscore(y); z = zscore(z);

% there are more cer-like than par-like effects
diffxy = x(gList) - y(gList);
thList = 0:0.1:0.5;
% thList = 0:.5:3;
for i = 1:length(thList)
    currTh = thList(i);
    n1 = length(find(x(gList) - y(gList) > currTh));
    n2 = length(find(y(gList) - x(gList) > currTh));
    disp(['th = ', num2str(currTh), ', x > y : ', num2str(n1), ', x < y : ', num2str(n2)]);
end

figure; 
subplot(1,3,1);
scatter(x, y, sz, [.7 .7 .7]);
hold on;
scatter(x(gList), y(gList), sz, z(gList), 'filled', 'MarkerEdgeColor', 'k');
diffTh = 0.2;
% xl = [min([min(x) min(y)]) 1];
xl = [-0.8 1];
plot(xl, xl + diffTh, 'k--');
plot(xl+diffTh, xl, 'k--');
plot(xl, xl, 'k');
axis([xl(1) xl(2) xl(1) xl(2)]);
cm = cbrewer2('Blues'); cm = cm(end:-1:1, :);
colormap(cm);

xlabel('Rc, cer - hybrid cer');
ylabel('Rc, par - hybrid par');
axis square; grid on; box on; set(gca, 'fontsize', fs);
set(gca, 'xtick', -.5:.5:1, 'ytick', -.5:.5:1);
text(x(exampleGenesIdx), y(exampleGenesIdx), listOfGenes(exampleGenesIdx), 'fontsize', fs);
% text(x(gList), y(gList), listOfGenes(gList));
%% F

nnCorrCer = nnWithinGenome.secondOrder.corrs(:, 1);
nnCorrPar = nnWithinGenome.secondOrder.corrs(:, 2);
x = nnCorrCer(goodGenes);
y = nnCorrPar(goodGenes);

subplot(1,3,2);
scatter(x, y, sz, [.7 .7 .7]);
hold on;
scatter(x(gList), y(gList), sz, z(gList), 'filled', 'MarkerEdgeColor', 'k');
xlabel('Rc, cer - NNcer');
ylabel('Rc, par - NNpar');
axis square; grid on; box on; set(gca, 'fontsize', fs);
text(x(exampleGenesIdx), y(exampleGenesIdx), listOfGenes(exampleGenesIdx), 'fontsize', fs);
axis([.5 1 .5 1]);
set(gca, 'xtick', .5:.1:1, 'ytick', .5:.1:1);
nnTh = 0.85;
plot([nnTh nnTh], ylim, 'k--');
plot(xlim, [nnTh nnTh], 'k--');
% text(x(gList), y(gList), listOfGenes(gList));
%% NN > th
nnTh = 0.85;
x = nnCorrCer(goodGenes);
y = nnCorrPar(goodGenes);
highNN = find(x(gList) > nnTh & y(gList) > nnTh);
lowNN = find(x(gList) < nnTh | y(gList) < nnTh);
xgty = find(x(gList) > nnTh & y(gList) < nnTh);
ygtx = find(y(gList) > nnTh & x(gList) < nnTh);
n = union(find(x < nnTh), find(y < nnTh));
n2 = union(find(x(gList) < nnTh), find(y(gList) < nnTh));
disp(['# genes < ', num2str(nnTh), ' : ', num2str(length(n)), ', ', num2str(length(n)*100/length(goodGenes)), '%']);
disp(['trans and high NN: ', num2str(length(highNN))]);
disp(['trans and low NN: ', num2str(nnTh), ' : ', num2str(length(n2)), ', ', num2str(length(n2)*100/length(gList)), '%']);
disp(['# genes x > th, y < th :', num2str(length(xgty))]);
disp(['# genes y > th, x < th :', num2str(length(ygtx))]);

x = obs_all_gg(:, 3); % cer-hyc
y = obs_all_gg(:, 4); % par-hyp
cerLike1 = find(x(gList) - y(gList) > diffTh);
parLike1 = find(y(gList) - x(gList) > diffTh);
nCerlike = intersect(xgty, cerLike1);
nParlike = intersect(ygtx, parLike1);
disp(['# genes x > th, y < th & cer-like: ', num2str(length(nCerlike)), ', ', num2str(length(nCerlike)*100/length(xgty)), '%']);
disp(['# genes y > th, x < th & par-like: ', num2str(length(nParlike)), ', ', num2str(length(nParlike)*100/length(ygtx)), '%']);
%% G

cerByParN = NNtop5.corr(:, 1);
parByCerN = NNtop5.corr(:, 2);
x = cerByParN(goodGenes);
y = parByCerN(goodGenes);

subplot(1,3,3);
scatter(x, y, sz, [.7 .7 .7]);
hold on;
scatter(x(gList), y(gList), sz, z(gList), 'filled', 'MarkerEdgeColor', 'k');
scatter(x(gList(highNN)), y(gList(highNN)), sz, z(gList(highNN)), 'filled', 'MarkerEdgeColor', 'r');
xlabel('Rc, cer - NNpar');
ylabel('Rc, par - NNcer');
axis square; grid on; box on; set(gca, 'fontsize', fs);
text(x(exampleGenesIdx), y(exampleGenesIdx), listOfGenes(exampleGenesIdx), 'fontsize', fs);
axis([-1 1 -1 1]);
set(gca, 'xtick', -1:.5:1, 'ytick', -1:.5:1);
cb = colorbar; cb.Label.String = 'Rc, species'; cb.FontSize = fs;
set(gcf, 'color', 'w');
% text(x(gList), y(gList), listOfGenes(gList));
%%

m = min([cerByParN(goodGenes) parByCerN(goodGenes)], [], 2);

figure; plotSpread({m(gList), m(gList(highNN)), m(gList(lowNN))})

%% cer-like, par-like
x = obs_all_gg(:, 3); % cer-hyc
y = obs_all_gg(:, 4); % par-hyp
cerLike1 = find(x(gList) - y(gList) > diffTh);
parLike1 = find(y(gList) - x(gList) > diffTh);
additive = find(x(gList) - y(gList) < diffTh & x(gList) - y(gList) > -diffTh);
genes = [cerLike1; parLike1; additive];
genesNameIdx = intint(goodGenes(gList(genes)));
geneNames = allGenes(genesNameIdx);
category = vertcat(repmat({'cer-like'}, length(cerLike1), 1), repmat({'par-like'}, length(parLike1), 1), ...
    repmat({'additive'}, length(additive), 1));
Rc_scores = obs_all_gg(gList(genes), :);
NNwithinSpecies = nnWithinGenome.secondOrder.corrs(goodGenes(gList(genes)), 1:2);
NNcrossSpecies = NNtop5.corr(goodGenes(gList(genes)), 1:2);
t = table(geneNames, category, Rc_scores(:, 1), Rc_scores(:, 2), Rc_scores(:, 3), Rc_scores(:, 4), ...
    NNwithinSpecies(:, 1), NNwithinSpecies(:, 2), NNcrossSpecies(:, 1), NNcrossSpecies(:, 2), ...
    GP.gene_infoR64.desc(genesNameIdx), ...
    'variableNames', {'GeneName', 'category', 'Rc_cer-par', 'Rc_hybrid', 'Rc_cer-hybrid_par', 'Rc_par-hybrid_par', ...
    'Rc_cer_NNcer', 'Rc_par_NNpar', 'Rc_cer_NNpar', 'Rc_par_NNcer', ...
    'SGD_description'});
t = sortrows(t, [2, 3]);
writetable(t, [homeDir, 'revision/trans_cerLike_parLike.xlsx']);
%% examples
% 
examples_4_scatters('VTC3', {});
figure5_revision_examples;
