spRange = [2 2];
figure;
xlabels = {'cis (expression level)', 'trans (expression level)'};
xl = [-.1 2];
for i = 1:2
    subplot(spRange(1), spRange(2),i); hold on;
    a = cisTransInAbs(:, i);
    b = cisTransInAbs(g, i);
    edges = 0:0.2:max(a);
    h1 = histcounts(a, edges, 'normalization', 'probability');
    h2 = histcounts(b, edges, 'normalization', 'probability');
    idxLim = find(edges == max(xl));
    h1_1(1:idxLim) = h1(1:idxLim);
    h1_1(idxLim+1) = sum(h1(idxLim:end));
    h2_1(1:idxLim) = h2(1:idxLim);
    h2_1(idxLim+1) = sum(h2(idxLim:end));
%     bar(edges(1:end-1), [h1; h2]', 'edgeColor', 'none');
    bar(edges(1:idxLim+1), [h1_1; h2_1]', 'edgeColor', 'none');
    
    legend({'all genes', [currLabel, '-diverging genes']});
    axis square;
    ylim([0 0.4]);
    ylabel('Fraction of genes');
    xlabel(xlabels{i});
    
    [p, h, stats] = ranksum(b,a);
%     xlim([-.1 round(max(a), 1)]);
%     xl = xlim;
    xlim(xl);
    text(xl(2), .2, {['p-vaule = ', num2str(round(p, 2))], ...
        ['z-statistic = ', num2str(round(stats.zval, 2))]}, 'horizontalAlignment', 'right', 'fontsize', fs);
    disp(p)
    %     text(xl(2), .2, ['z-statistic = ', num2str(round(stats.zval, 2))], 'horizontalAlignment', 'right', 'fontsize', fs);
    set(gca, 'fontsize', fs);
end

toCheck = [2,3];
deType = {'sp', 'cis', 'trans'};
randGenes = datasample(1:length(goodGenes), length(g));
zstats = nan(nC, length(toCheck), 3);
for i = 1:length(toCheck)
    currEffect = comparable_samples_de.(deType{toCheck(i)});
    for j = 1:nC
        effectInAbs = abs(currEffect(:, j));
        a = effectInAbs(intint(goodGenes(randGenes)));
        b = effectInAbs(intint(goodGenes(g)));
        [p, h, stats] = ranksum(b,a);
        zstats(j, i, 1) = stats.zval;
        zstats(j, i, 2) = p;
        zstats(j, i, 3) = h;
    end
end

% edges = -10:.5:10;
% xlabels = {'cis', 'trans'};
% for i = 1:2
%     subplot(spRange(1), spRange(2), i+2);
%     histogram(zstats(:, i, 1), edges);
%     %     ylim([0 200]);
%     xlabel('z-stat.');
%     ylabel('# conditions');
%     ylim([0 100]);
%     hold on; plot([2 2], ylim, '--k');
%     plot([-2 -2], ylim, '--k');
%     axis square;
%     set(gca, 'fontsize', fs);
% end
set(gcf, 'color', 'w', 'position', [520   153   836   645]);