% expression by experiment
currGene = 'CHA1';
gn = GP.gene_table.(currGene);

bords = {1:111, 112:208, 209:317, 318:360, 361:403, 404:433, 434:462};
conds = {'TP1 YPD', 'TP2 low N, 1 h', 'TP3 low N, 16 h', 'Cell Cycle 1', 'Cell Cycle 2',...
    'Growth curve', 'no Phosphate'};
distPerExperiment = cell(4, length(bords));
for i = 1:4
    for j = 1:length(bords)
        distPerExperiment{i, j} = expStruct.(gb{i}).exp(gn, bords{j});
    end
end

% figure;
% for i = 1:length(bords)
%     subplot(1, length(bords), i);
%     plotSpread(distPerExperiment(:, i));
%     title(conds{i});
% end
% set(gcf, 'position', [106         591        1457         243]);
%%

% dYPD = cell(4,1);
% for i = 1:4
%     dYPD{i} = [distPerExperiment{i, [1,4,5]}];
% end
% 
% d = {distPerExperiment(:, 1), distPerExperiment(:, 2), distPerExperiment(:, 3)};
% figure;
% for i = 1:3
%     subplot(1,3,i);
%     plotSpread(d{i});
%     title(conds{i});
%     ylim([0 10]);
%     set(gca, 'xtick', 1:4, 'xticklabels', {'cer', 'par', 'hyb.cer', 'hyb.par'});
%     ylabel('log2 expression');
% end
%%
figure;
xticklabels = {'YPD', 'low N, 1 h', 'low N, 16 h'};
for i = 1:4
    subplot(1,4,i);
    plotSpread(distPerExperiment(i, 1:3));
    ylim([0 10]);
    ylabel('log expression');
    set(gca, 'xtick', 1:3, 'xticklabels', xticklabels); xtickangle(45);
    axis square; box on; grid on;
    set(gca, 'fontsize', fs);
end
set(gcf, 'color', 'w', 'position', [259   428   997   273]);

means = cellfun(@nanmean, distPerExperiment);
meadins = cellfun(@nanmedian, distPerExperiment);
stderr = cellfun(@nanstd, distPerExperiment);
