function [] = examples_4_scatters(currGene, genesText)
global PCMs intint allGenes
F = fields(PCMs);
gidx = find(ismember(allGenes(intint), currGene));
if ~isempty(genesText)
    genesText = ismember_smart(allGenes(intint), genesText);
end
% spRange = [2,2];
% spLocs = {1,2,3,4};
spRange = [2, 4];
spLocs = {1,2,3,4, 5,6};
figure;
fs = 12;
cm = cbrewer2('YlGnBu'); cm = cm(end:-1:1, :);
comps = {[1,2], [3,4], [1,3], [2,4]};
titles = {'Species', 'Hybrid', 'cer allele', 'par allele'};
labels = {'cer', 'par', 'Hyb. cer', 'Hyb. par'};
for i = 1:4
    x = PCMs.(F{comps{i}(1)}).PCM(:, gidx);
    y = PCMs.(F{comps{i}(2)}).PCM(:, gidx);
    subplot(spRange(1), spRange(2), spLocs{i});
    dscatter(x,y); hold on;
    set(gca, 'xtick', -1:.5:1, 'ytick', -1:.5:1);
    axis square; box on; axis([-1 1 -1 1]); grid on;
    r = corr(x,y,'rows', 'pairwise');
    text(-.9, .9, ['R = ', num2str(round(r, 2))], 'fontsize', fs);
    xlabel(['Corr, ', labels{comps{i}(1)}]);
    ylabel(['Corr, ', labels{comps{i}(2)}]);
    title(titles{i});
    set(gca, 'fontsize', fs);
    colormap(cm)
    if ~isempty(genesText)
%         text(x(genesText), y(genesText), allGenes(intint(genesText)), 'fontsize', fs);
        scatter(x(genesText), y(genesText), [], 'r');
    end
end

[sortd1, s1] = sort(PCMs.WCDcer.PCM(:, gidx), 'descend');
[sortd2, s2] = sort(PCMs.WCDpar.PCM(:, gidx), 'descend');
N = 7;
topCer = allGenes(intint(s1(2:N+1)));
topPar = allGenes(intint(s2(2:N+1)));
sp5 = subplot(spRange(1), spRange(2), spLocs{5});
d = [sortd1(2:N+1), sortd2(2:N+1)];
d1 = [1 1];
d = [d1; d];
imagesc(d);
text(repmat(.5, N+1, 1), 1:N+1, vertcat({'in cer'}, topCer));
text(repmat(1.5, N+1, 1), 1:N+1, vertcat({'in par'}, topPar));
caxis([0 1]); 
cb = colorbar; cb.Label.String = 'correlation';
cm2 = cbrewer2('Blues', 20); cm2 = cm2(end:-1:1, :); colormap(sp5, cm2);
set(gca, 'xtick', [], 'ytick', []);
title('Top correlated genes');
set(gca, 'fontsize', fs);

[sortd1, s1] = sort(PCMs.WCDhyc.PCM(:, gidx), 'descend');
[sortd2, s2] = sort(PCMs.WCDhyp.PCM(:, gidx), 'descend');
N = 7;
topCer = allGenes(intint(s1(2:N+1)));
topPar = allGenes(intint(s2(2:N+1)));
sp5 = subplot(spRange(1), spRange(2), spLocs{6});
d = [sortd1(2:N+1), sortd2(2:N+1)];
d1 = [1 1];
d = [d1; d];
imagesc(d);
text(repmat(.5, N+1, 1), 1:N+1, vertcat({'in cer'}, topCer));
text(repmat(1.5, N+1, 1), 1:N+1, vertcat({'in par'}, topPar));
caxis([0 1]); 
cb = colorbar; cb.Label.String = 'correlation';
cm2 = cbrewer2('Blues', 20); cm2 = cm2(end:-1:1, :); colormap(sp5, cm2);
set(gca, 'xtick', [], 'ytick', []);
title('Top correlated genes');
set(gca, 'fontsize', fs);

set(gcf, 'color', 'w', 'position', [490         200        1209         488]);
end
