% name: lnc = log2 normalized counts
d = dir([homeDir, 'R_DESeq/DESeq_out/']);
fileNames = {'log2NormCounts_CellCycle.csv', 'log2NormCounts_Growth_curve.csv', ...
    'log2NormCounts_SC_to_No_Pi.csv', 'log2NormCounts_YPD_to_Low_N.0.csv', ...
    'log2NormCounts_YPD_to_Low_N.60.csv', 'log2NormCounts_YPD_to_Low_N.960.csv'};

load([homeDir, 'Screen/read_organize_data/dataLabels_newname.mat']);
a = struct2cell(dataLabels_newname);
allNames = vertcat(a{:});
Nsamples = length(allNames);
lnc_mat = nan(6701, Nsamples);
% minTh = 0;

for i = 1:length(fileNames)
    currFile = fileNames{i};
    disp(currFile);
    csv_file = [homeDir, 'R_DESeq/DESeq_out/', currFile];
    opts=detectImportOptions(csv_file);
    %Defines the row location of channel variable name
    opts.VariableNamesLine = 1;
    %Specifies that the data is comma seperated
    opts.Delimiter =',';
    lnc = readtable(csv_file, 'ReadVariableNames', true);
    sample_names_lnc = lnc.Properties.VariableNames;
    sample_names_lnc(1) = [];
    sample_names_lnc = strrep(sample_names_lnc, '_', ' ');
    nameIdx = ismember_smart(allNames, sample_names_lnc);
    orfIdx = ismember_smart(allOrfs, lnc{:,1});
    lnc_mat(orfIdx, nameIdx) = table2array(lnc(:, 2:end));
    lnc_mat(isinf(lnc_mat)) = NaN;
%     lnc_mat(lnc_mat < minTh) = minTh;
end

dataS_deseqnorm = struct;
for i = 1:4
    currEntry = ['WCD', gb{i}];
    idx = ismember_smart(allNames, dataLabels_newname.(currEntry));
    dataS_deseqnorm.(currEntry) = lnc_mat(:, idx);
end

dataS = dataS_deseqnorm;

%% filter genes
fltBadGenes = 1;
run([homeDir, 'gene_gene_corr/filter_genes.m']);

%% exp struct: using 'comparable_conditions'

comparable_samples = readtable([homeDir, 'Screen/read_organize_data/comparable_samples.xlsx']);
comparable_samples = table2array(comparable_samples);
comparable_samples = strrep(comparable_samples, '_', ' ');
save('comparable_samples.mat', 'comparable_samples');
a = struct2cell(dataLabels_newname);
allNames = vertcat(a{:});

dataS_deseqnorm_mat = [dataS.WCDcer, dataS.WCDpar, dataS.WCDhyc, dataS.WCDhyp];

expStruct_deseq = struct;
expStruct_deseq.cer.exp = dataS_deseqnorm_mat(:, ismember_smart(allNames, comparable_samples(:, 1)));
expStruct_deseq.par.exp = dataS_deseqnorm_mat(:, ismember_smart(allNames, comparable_samples(:, 2)));
expStruct_deseq.hyc.exp = dataS_deseqnorm_mat(:, ismember_smart(allNames, strrep(comparable_samples(:, 3), 'hyb', 'hyc')));
expStruct_deseq.hyp.exp = dataS_deseqnorm_mat(:, ismember_smart(allNames, strrep(comparable_samples(:, 3), 'hyb', 'hyp'))); 

save('expStruct_deseqnorm.mat', 'expStruct');
save('dataS_deseqnorm.mat', 'dataS')
expSturct = expStruct_deseq;