%% generate expConList
load('divT.mat');
expConList = nan(6701, 8);
ggcForExpCon = struct;
for i = 1:length(gb)
    c = corr(expStruct.(gb{i}).exp');
    c(1:(size(c, 1)+1):numel(c)) = nan; % nan diagonal
    ggcForExpCon.(gb{i}) = c;
end
%
randomMatch = nan(6701, 4);
for i = 1:6701
    cer = expStruct.cer.exp(i, :)';
    par = expStruct.par.exp(i, :)';
    hyc = expStruct.hyc.exp(i, :)';
    hyp = expStruct.hyp.exp(i, :)';
    corrCerPar = corr(cer, par);
    corrHycHyp = corr(hyc, hyp);
    corrCerHyc = corr(cer, hyc);
    corrParHyp = corr(par, hyp);
    expCer = max(ggcForExpCon.cer(i, :));
    expPar = max(ggcForExpCon.par(i, :));
    expHyc = max(ggcForExpCon.hyc(i, :));
    expHyp = max(ggcForExpCon.hyp(i, :));
    expConList(i, :) = [corrCerPar, corrHycHyp, corrCerHyc, corrParHyp, expCer, expPar, expHyc, expHyp];
    bg = find(~isnan(ggcForExpCon.cer(i, :)) & ~isnan(ggcForExpCon.par(i, :)) & ...
        ~isnan(ggcForExpCon.hyc(i, :)) & ~isnan(ggcForExpCon.hyp(i, :)));
    if isempty(bg); continue; end;
    randOne = datasample(bg, 1);
    randomMatch(i, :) = [ggcForExpCon.cer(i, randOne), ggcForExpCon.par(i, randOne), ...
        ggcForExpCon.hyc(i, randOne), ggcForExpCon.hyp(i, randOne)];
end
expConListLabels = {'corrCerPar', 'corrHycHyp', 'corrCerHyc', 'corrParHyp', 'expCer', 'expPar', 'expHyc', 'expHyp'};
save('expConList_deseqnorm.mat', 'expConList');