
% NN by other species: take the max of top 5

% comparisons:
% 1. cer by par
% 2. par by cer
% 3. hyc by hyp
% 4. hyp by hyc
% 5. cer by hyc
% 6. hyc by cer
% 7. par by hyp
% 8. hyp by par
% 9. cer by hyp
% 10. hyp by cer
% 11. par by hyc
% 12. hyc by par

comps = {[1,2], [2,1], [3,4], [4,3], [1,3], [3,1], [2,4], [4,2], [1,4], [4,1], [2,3], [3,2]};
maxCorrs = nan(length(intint), length(comps));
idxes = nan(length(intint), length(comps));
for i = 1:length(intint)
    for j = 1:length(comps)
        currComps = comps{j};
        op1 = currComps(1);
        op2 = currComps(2);
        idx1 = nnWithinGenome.secondOrder.geneIdxN{op1}(i, :);
        idx2 = nnWithinGenome.secondOrder.geneIdxN{op2}(i, :);
        corr1 = PCM2(:, i, op1);
        [maxCorr, maxIdx] = max(corr1(idx2));
        maxCorrs(i, j) = maxCorr;
        idxes(i, j) = idx1(maxIdx);
    end
end
    
% idxCerN = nnWithinGenome.secondOrder.geneIdxN{1}(i, :);
% parCorr = PCM2(:, i, 2);
% [maxCorr, maxIdx] = max(parCorr(idxCerN));
% parByCerN(i) = maxCorr;
% parByCerNidx(i) = idxCerN(maxIdx);

corrCer = PCM2(:, :, 1);
corrPar = PCM2(:, :, 2);
idxCer = nnWithinGenome.secondOrder.geneIdx(:, 1);
idxPar = nnWithinGenome.secondOrder.geneIdx(:, 2);
idxCer = sub2ind([length(intint) length(intint)], 1:length(intint), idxCer')';
idxPar = sub2ind([length(intint) length(intint)], 1:length(intint), idxPar')';
cerByPar1 = corrCer(idxPar);
parByCer1 = corrPar(idxCer);

NNtop5 = struct;
NNtop5.corr = maxCorrs;
NNtop5.idx = idxes;
save([homeDir, 'revision/NNtop5.mat'], 'NNtop5');
%%
figure;
subplot(1,2,1);
dscatter(cerByPar1, parByCer1);
axis square; box on; grid on;
xlabel('corr cer with NN in par (1)'); ylabel('corr par with NN in cer (1)');
subplot(1,2,2);
dscatter(maxCorrs(:, 1), maxCorrs(:, 2));
axis square; box on; grid on;
xlabel('corr cer with NN in par (top of 5)'); ylabel('corr par with NN in cer (top of 5)');
%%

% x = cerByPar1;
% y = parByCer1;
% z = obs_all(:, 1);
% clpl = transGenes([cerLike; parLike]);
% idx = find(ismember(allGenes(intint), {'CHA1', 'VTC3', 'VTC1', 'VTC4', 'FET3', 'FTR1', 'SIT1', 'LSM2', 'COX17'}));
% idxLabels = allGenes(intint(idx));
% figure; hold on;
% lists = {cerLike, parLike};
% markers = {'o', '^'};
% for i = 1:length(lists)
%     currlist = lists{i};
%     currlist = goodGenes(transGenes(currlist));
%     scatter(x(currlist),y(currlist),[], z(currlist), markers{i}, 'filled', 'markerEdgeColor', 'k');
% end
% text(x(idx), y(idx), idxLabels);
% cb = colorbar; cb.Label.String = 'corr. b/w species';
% box on; grid on; axis square;
% xlabel('corr. in cer with NN in par');
% ylabel('corr. in par with NN in cer');
% set(gcf, 'color', 'w');
