% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaps.R
\name{tss_heatmap_matrix}
\alias{tss_heatmap_matrix}
\title{TSS Heatmap Count Matrix}
\usage{
tss_heatmap_matrix(experiment, samples = "all", upstream = 1000,
  downstream = 1000, threshold = 1, anno_type = c("transcriptId",
  "geneId"), quantiles = 1, use_cpm = FALSE)
}
\arguments{
\item{experiment}{tsrexplorer object with annotated TSSs}

\item{samples}{Either 'all' or name of samples to analyze}

\item{upstream}{Bases upstream to consider}

\item{downstream}{bases downstream to consider}

\item{threshold}{Reads required per TSS}

\item{anno_type}{Whether the heatmap is built on genes or transcripts ("geneId", "transcriptId")}

\item{quantiles}{Number of quantiles to break data down into}

\item{use_cpm}{Whether to use the CPM normalized values or not}
}
\value{
matrix of counts for each gene/transcript and position
}
\description{
Generate count matrix to make TSS heatmap
}
