% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaps.R
\name{tsr_heatmap_matrix}
\alias{tsr_heatmap_matrix}
\title{TSR Heatmap Count Matrix}
\usage{
tsr_heatmap_matrix(experiment, samples = "all", upstream = 1000,
  downstream = 1000, feature_type = c("transcriptId", "geneId"),
  quantiles = 1, threshold = 1, use_cpm = FALSE)
}
\arguments{
\item{experiment}{tsrexplorer object with annotated TSRs}

\item{samples}{Either 'all' or names of samples to analyze}

\item{upstream}{Bases upstream to consider}

\item{downstream}{bases downstream to consider}

\item{feature_type}{Whether the heatmap is built on genes or transcripts ("geneId", "transcriptId")}

\item{quantiles}{Number of quantiles to split data into}

\item{threshold}{Reads required per TSR}

\item{use_cpm}{Whether to use CPM normalized or raw counts}
}
\value{
matrix of counts for each gene/transcript and position
}
\description{
Generate count matrix to make TSR heatmap
}
